/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.ApplyGradlePluginCallback;
import org.jetbrains.plugins.gradle.service.notification.GotoSourceNotificationCallback;
import org.jetbrains.plugins.gradle.service.notification.OpenGradleSettingsCallback;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        if (error == null) {
            return;
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof ExternalSystemException) {
            GradleNotificationExtension.updateNotification(notification, project, (ExternalSystemException)unwrapped);
        }
    }

    private static void updateNotification(@NotNull NotificationData notificationData, @NotNull Project project, @NotNull ExternalSystemException e) {
        if (notificationData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        for (String fix : e.getQuickFixes()) {
            if ("open_gradle_settings".equals(fix)) {
                notificationData.setListener("open_gradle_settings", (NotificationListener)new OpenGradleSettingsCallback(project));
                continue;
            }
            if ("apply_gradle_plugin".equals(fix)) {
                notificationData.setListener("apply_gradle_plugin", (NotificationListener)new ApplyGradlePluginCallback(notificationData, project));
                continue;
            }
            if (!"goto_source".equals(fix)) continue;
            notificationData.setListener("goto_source", (NotificationListener)new GotoSourceNotificationCallback(notificationData, project));
        }
    }
}

