/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class GradleJavaHelper {
    public static final String GRADLE_JAVA_HOME_KEY = "gradle.java.home";

    @Nullable
    public String getJdkHome(@Nullable Project project) {
        String path;
        Sdk sdk;
        ArrayList candidates = ContainerUtilRt.newArrayList();
        candidates.add(System.getProperty(GRADLE_JAVA_HOME_KEY));
        candidates.add(System.getenv("JAVA_HOME"));
        for (String candidate : candidates) {
            if (candidate == null || !JdkUtil.checkForJdk((File)new File(candidate))) continue;
            return candidate;
        }
        if (project != null && (sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null && (path = sdk.getHomePath()) != null && JdkUtil.checkForJdk((File)new File(path))) {
            return path;
        }
        Sdk[] sdks = ProjectJdkTable.getInstance().getAllJdks();
        if (sdks != null) {
            for (Sdk sdk2 : sdks) {
                String path2 = sdk2.getHomePath();
                if (path2 == null || !JdkUtil.checkForJdk((File)new File(path2))) continue;
                return path2;
            }
        }
        return null;
    }
}

