/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.action.AbstractGradleLinkedProjectAction;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleOpenScriptAction
extends AbstractGradleLinkedProjectAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleOpenScriptAction.class.getName()));

    public GradleOpenScriptAction() {
        this.getTemplatePresentation().setText(GradleBundle.message("gradle.action.open.script.text", new Object[0]));
        this.getTemplatePresentation().setDescription(GradleBundle.message("gradle.action.open.script.description", new Object[0]));
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent event, @NotNull Project project, @NotNull String linkedProjectPath) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doUpdate"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doUpdate"));
        }
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent event, @NotNull Project project, @NotNull String linkedProjectPath) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doActionPerformed"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doActionPerformed"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/action/GradleOpenScriptAction", "doActionPerformed"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(linkedProjectPath);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't obtain virtual file for the target file path: '%s'", linkedProjectPath));
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }
}

