/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenArchetype
implements Serializable {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final String repository;
    public final String description;

    public MavenArchetype(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String repository, @Nullable String description) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/model/MavenArchetype", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/model/MavenArchetype", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/model/MavenArchetype", "<init>"));
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.repository = StringUtil.isEmptyOrSpaces((String)repository) ? null : repository;
        this.description = StringUtil.isEmptyOrSpaces((String)description) ? null : description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArchetype that = (MavenArchetype)o;
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

