/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import java.awt.Dimension;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TerminalMode {
    Null,
    CursorKey{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationArrowKeys(enabled);
        }
    }
    ,
    ANSI,
    WideColumn{

        public void setEnabled(Terminal terminal, boolean enabled) {
            int h = terminal.getTerminalHeight();
            Dimension d = enabled ? new Dimension(132, h) : new Dimension(80, h);
            terminal.resize(d, RequestOrigin.Remote);
            terminal.clearScreen();
            terminal.resetScrollRegions();
        }
    }
    ,
    CursorVisible{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setCursorVisible(enabled);
        }
    }
    ,
    AlternateBuffer{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.useAlternateBuffer(enabled);
        }
    }
    ,
    SmoothScroll,
    ReverseVideo,
    OriginMode{

        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoWrap{

        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoRepeatKeys,
    Interlace,
    Keypad{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationKeypad(enabled);
        }
    }
    ,
    StoreCursor{

        public void setEnabled(Terminal terminal, boolean enabled) {
            if (enabled) {
                terminal.saveCursor();
            } else {
                terminal.restoreCursor();
            }
        }
    }
    ,
    CursorBlinking{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setBlinkingCursor(enabled);
        }
    }
    ,
    AllowWideColumn,
    ReverseWrapAround,
    AutoNewLine{

        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setAutoNewLine(enabled);
        }
    }
    ,
    KeyboardAction,
    InsertMode,
    SendReceive,
    EightBitInput;

    private static final Logger LOG;

    public void setEnabled(Terminal terminal, boolean enabled) {
        LOG.error((Object)("Mode " + this.name() + " is not implemented, setting to " + enabled));
    }

    static {
        LOG = Logger.getLogger(TerminalMode.class);
    }
}

