/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class TerminalColor {
    public static final TerminalColor BLACK = TerminalColor.index(0);
    public static final TerminalColor WHITE = TerminalColor.index(15);
    private int myColorIndex;
    private int myR;
    private int myG;
    private int myB;

    public TerminalColor(int index) {
        this.myColorIndex = index;
        this.myR = -1;
        this.myG = -1;
        this.myB = -1;
    }

    public TerminalColor(int r, int g, int b) {
        this.myColorIndex = -1;
        this.myR = r;
        this.myG = g;
        this.myB = b;
    }

    public static TerminalColor index(int index) {
        return new TerminalColor(index);
    }

    public static TerminalColor rgb(int r, int g, int b) {
        return new TerminalColor(r, g, b);
    }

    public boolean isIndexed() {
        return this.myColorIndex != -1;
    }

    public Color toAwtColor() {
        if (this.isIndexed()) {
            throw new IllegalArgumentException("Color is indexed color so a palette is needed");
        }
        return new Color(this.myR, this.myG, this.myB);
    }

    public int getIndex() {
        return this.myColorIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalColor that = (TerminalColor)o;
        if (this.isIndexed()) {
            if (!that.isIndexed()) {
                return false;
            }
            if (this.myColorIndex != that.myColorIndex) {
                return false;
            }
        } else {
            if (that.isIndexed()) {
                return false;
            }
            if (this.myB != that.myB) {
                return false;
            }
            if (this.myG != that.myG) {
                return false;
            }
            if (this.myR != that.myR) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.myColorIndex;
        result = 31 * result + this.myR;
        result = 31 * result + this.myG;
        result = 31 * result + this.myB;
        return result;
    }

    @Nullable
    public static TerminalColor awt(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        return TerminalColor.rgb(color.getRed(), color.getGreen(), color.getBlue());
    }
}

