/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.emulator.charset.CharacterSets;
import com.jediterm.terminal.model.CharBuffer;
import java.util.Arrays;

public class CharacterUtils {
    public static final int ESC = 27;
    public static final int DEL = 127;
    public static final char EMPTY_CHAR = ' ';
    private static final String[] NONPRINTING_NAMES = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "TAB", "LF", "VT", "FF", "CR", "S0", "S1", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    public static byte[] VT102_RESPONSE = CharacterUtils.makeCode(27, 91, 63, 54, 99);
    private static final int[] ambiguous_chars = new int[]{161, 164, 167, 168, 170, 173, 174, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 188, 189, 190, 191, 198, 208, 215, 216, 222, 223, 224, 225, 230, 232, 233, 234, 236, 237, 240, 242, 243, 247, 248, 249, 250, 252, 254, 257, 273, 275, 283, 294, 295, 299, 305, 306, 307, 312, 319, 320, 321, 322, 324, 328, 329, 330, 331, 333, 338, 339, 358, 359, 363, 462, 464, 466, 468, 470, 472, 474, 476, 593, 609, 708, 711, 713, 714, 715, 717, 720, 728, 729, 730, 731, 733, 735, 931, 932, 933, 934, 935, 936, 937, 963, 964, 965, 966, 967, 968, 969, 1025, 1105, 8208, 8211, 8212, 8213, 8214, 8216, 8217, 8220, 8221, 8224, 8225, 8226, 8228, 8229, 8230, 8231, 8240, 8242, 8243, 8245, 8251, 8254, 8308, 8319, 8321, 8322, 8323, 8324, 8364, 8451, 8453, 8457, 8467, 8470, 8481, 8482, 8486, 8491, 8531, 8532, 8539, 8540, 8541, 8542, 8585, 8632, 8633, 8658, 8660, 8679, 8704, 8706, 8707, 8711, 8712, 8715, 8719, 8721, 8725, 8730, 8733, 8734, 8735, 8736, 8739, 8741, 8743, 8744, 8745, 8746, 8747, 8748, 8750, 8756, 8757, 8758, 8759, 8764, 8765, 8776, 8780, 8786, 8800, 8801, 8804, 8805, 8806, 8807, 8810, 8811, 8814, 8815, 8834, 8835, 8838, 8839, 8853, 8857, 8869, 8895, 8978, 9618, 9619, 9620, 9621, 9632, 9633, 9635, 9636, 9637, 9638, 9639, 9640, 9641, 9650, 9651, 9654, 9655, 9660, 9661, 9664, 9665, 9670, 9671, 9672, 9675, 9678, 9679, 9680, 9681, 9698, 9699, 9700, 9701, 9711, 9733, 9734, 9737, 9742, 9743, 9748, 9749, 9756, 9758, 9792, 9794, 9824, 9825, 9827, 9828, 9829, 9831, 9832, 9833, 9834, 9836, 9837, 9839, 9886, 9887, 9918, 9919, 9955, 10045, 10071, 11093, 11094, 11095, 11096, 11097, 65533};
    private static final int AMB_CHAR_NUMBER = ambiguous_chars.length;

    private CharacterUtils() {
    }

    public static String getNonControlCharacters(int maxChars, char[] buf, int offset, int charsLength) {
        int len;
        int origLen = len = maxChars > charsLength ? charsLength : maxChars;
        while (len > 0) {
            char tmp;
            if (' ' <= (tmp = buf[offset++])) {
                --len;
                continue;
            }
            --offset;
            break;
        }
        int length = origLen - len;
        return new String(buf, offset - length, length);
    }

    public static CharacterType appendChar(StringBuilder sb, CharacterType last, char c) {
        if (c <= '\u001f') {
            sb.append(' ');
            sb.append(NONPRINTING_NAMES[c]);
            return CharacterType.NONPRINTING;
        }
        if (c == '\u007f') {
            sb.append(" DEL");
            return CharacterType.NONPRINTING;
        }
        if (c > '\u001f' && c <= '~') {
            if (last != CharacterType.PRINTING) {
                sb.append(' ');
            }
            sb.append(c);
            return CharacterType.PRINTING;
        }
        sb.append(" 0x").append(Integer.toHexString(c));
        return CharacterType.NONASCII;
    }

    public static void appendBuf(StringBuilder sb, char[] bs, int begin, int length) {
        CharacterType last = CharacterType.NONPRINTING;
        int end = begin + length;
        for (int i = begin; i < end; ++i) {
            char c = bs[i];
            last = CharacterUtils.appendChar(sb, last, c);
        }
    }

    public static byte[] makeCode(int ... bytesAsInt) {
        byte[] bytes = new byte[bytesAsInt.length];
        int i = 0;
        for (int byteAsInt : bytesAsInt) {
            bytes[i] = (byte)byteAsInt;
            ++i;
        }
        return bytes;
    }

    public static int getTextLength(char[] buffer, int start, int length) {
        int result = 0;
        for (int i = start; i < start + length; ++i) {
            result += CharacterUtils.isDoubleWidthCharacter(buffer[i]) ? 2 : 1;
        }
        return result;
    }

    public static boolean isDoubleWidthCharacter(char unicode) {
        boolean ambiguousIsDoubleWidth = false;
        boolean YES = true;
        boolean NO = false;
        if (unicode <= '\u00a0' || unicode > '\u0452' && unicode < '\u1100') {
            return false;
        }
        if (unicode >= '\u1100' && unicode <= '\u115f' || unicode >= '\u11a3' && unicode <= '\u11a7' || unicode >= '\u11fa' && unicode <= '\u11ff' || unicode >= '\u2329' && unicode <= '\u232a' || unicode >= '\u2e80' && unicode <= '\u2e99' || unicode >= '\u2e9b' && unicode <= '\u2ef3' || unicode >= '\u2f00' && unicode <= '\u2fd5' || unicode >= '\u2ff0' && unicode <= '\u2ffb' || unicode >= '\u3000' && unicode <= '\u303e' || unicode >= '\u3041' && unicode <= '\u3096' || unicode >= '\u3099' && unicode <= '\u30ff' || unicode >= '\u3105' && unicode <= '\u312d' || unicode >= '\u3131' && unicode <= '\u318e' || unicode >= '\u3190' && unicode <= '\u31ba' || unicode >= '\u31c0' && unicode <= '\u31e3' || unicode >= '\u31f0' && unicode <= '\u321e' || unicode >= '\u3220' && unicode <= '\u3247' || unicode >= '\u3250' && unicode <= '\u32fe' || unicode >= '\u3300' && unicode <= '\u4dbf' || unicode >= '\u4e00' && unicode <= '\ua48c' || unicode >= '\ua490' && unicode <= '\ua4c6' || unicode >= '\ua960' && unicode <= '\ua97c' || unicode >= '\uac00' && unicode <= '\ud7a3' || unicode >= '\ud7b0' && unicode <= '\ud7c6' || unicode >= '\ud7cb' && unicode <= '\ud7fb' || unicode >= '\uf900' && unicode <= '\ufaff' || unicode >= '\ufe10' && unicode <= '\ufe19' || unicode >= '\ufe30' && unicode <= '\ufe52' || unicode >= '\ufe54' && unicode <= '\ufe66' || unicode >= '\ufe68' && unicode <= '\ufe6b' || unicode >= '\uff01' && unicode <= '\uff60' || unicode >= '\uffe0' && unicode <= '\uffe6' || unicode >= '\u1b000' && unicode <= '\u1b001' || unicode >= '\u1f200' && unicode <= '\u1f202' || unicode >= '\u1f210' && unicode <= '\u1f23a' || unicode >= '\u1f240' && unicode <= '\u1f248' || unicode >= '\u1f250' && unicode <= '\u1f251' || unicode >= '\u20000' && unicode <= '\u2fffd' || unicode >= '\u30000' && unicode <= '\u3fffd') {
            return YES;
        }
        if (ambiguousIsDoubleWidth) {
            if (unicode >= '\u0300' && unicode <= '\u036f' || unicode >= '\u0391' && unicode <= '\u03a1' || unicode >= '\u03b1' && unicode <= '\u03c1' || unicode >= '\u0410' && unicode <= '\u044f' || unicode >= '\u2160' && unicode <= '\u216b' || unicode >= '\u2170' && unicode <= '\u2179' || unicode >= '\u2190' && unicode <= '\u2199' || unicode >= '\u2460' && unicode <= '\u24e9' || unicode >= '\u24eb' && unicode <= '\u254b' || unicode >= '\u2550' && unicode <= '\u2573' || unicode >= '\u2580' && unicode <= '\u258f' || unicode >= '\u26c4' && unicode <= '\u26cd' || unicode >= '\u26cf' && unicode <= '\u26e1' || unicode >= '\u26e8' && unicode <= '\u26ff' || unicode >= '\u2776' && unicode <= '\u277f' || unicode >= '\u3248' && unicode <= '\u324f' || unicode >= '\ue000' && unicode <= '\uf8ff' || unicode >= '\ufe00' && unicode <= '\ufe0f' || unicode >= '\u1f100' && unicode <= '\u1f10a' || unicode >= '\u1f110' && unicode <= '\u1f12d' || unicode >= '\u1f130' && unicode <= '\u1f169' || unicode >= '\u1f170' && unicode <= '\u1f19a' || unicode >= '\ue0100' && unicode <= '\ue01ef' || unicode >= '\uf0000' && unicode <= '\uffffd' || unicode >= '\u100000' && unicode <= '\u10fffd') {
                return YES;
            }
            int ind = AMB_CHAR_NUMBER / 2;
            int start = 0;
            int end = AMB_CHAR_NUMBER;
            while (start < end) {
                if (ambiguous_chars[ind] == unicode) {
                    return YES;
                }
                if (ambiguous_chars[ind] < unicode) {
                    start = ind + 1;
                    ind = (start + end) / 2;
                    continue;
                }
                end = ind;
                ind = (start + end) / 2;
            }
        }
        return NO;
    }

    public static CharBuffer heavyDecCompatibleBuffer(CharBuffer buf) {
        char[] c = Arrays.copyOfRange(buf.getBuf(), 0, buf.getBuf().length);
        for (int i = 0; i < c.length; ++i) {
            c[i] = CharacterSets.getHeavyDecBoxChar(c[i]);
        }
        return new CharBuffer(c, buf.getStart(), buf.getLength());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterType {
        NONPRINTING,
        PRINTING,
        NONASCII,
        NONE;

    }
}

