/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.gradle.TaskParameter;

public class DefaultTaskParameter
implements TaskParameter,
Serializable {
    private final String taskName;
    private final String projectPath;

    public DefaultTaskParameter(String taskName) {
        this(taskName, null);
    }

    public DefaultTaskParameter(String taskName, String projectPath) {
        this.taskName = (String)Preconditions.checkNotNull((Object)taskName);
        this.projectPath = projectPath;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTaskParameter that = (DefaultTaskParameter)o;
        if (!Objects.equal((Object)this.projectPath, (Object)that.projectPath)) {
            return false;
        }
        return Objects.equal((Object)this.taskName, (Object)that.taskName);
    }

    public int hashCode() {
        int result = this.taskName != null ? this.taskName.hashCode() : 0;
        result = 31 * result + (this.projectPath != null ? this.projectPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultTaskParameter{taskName='" + this.taskName + '\'' + ",projectPath='" + this.projectPath + '\'' + '}';
    }
}

