/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.AbstractProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDirectoryProjectSpec
extends AbstractProjectSpec
implements Serializable {
    private final File dir;

    public ProjectDirectoryProjectSpec(File dir) {
        this.dir = dir;
    }

    @Override
    public String getDisplayName() {
        return String.format("with project directory '%s'", this.dir);
    }

    @Override
    protected String formatNoMatchesMessage() {
        return String.format("No projects in this build have project directory '%s'.", this.dir);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> matches) {
        return String.format("Multiple projects in this build have project directory '%s': %s", this.dir, matches);
    }

    @Override
    protected boolean select(ProjectIdentifier project) {
        return project.getProjectDir().equals(this.dir);
    }

    @Override
    protected void checkPreconditions(ProjectRegistry<?> registry) {
        if (!this.dir.exists()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' does not exist.", this.dir));
        }
        if (!this.dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' is not a directory.", this.dir));
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

