/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.TaskSelectionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolver {
    public SetMultimap<String, TaskSelectionResult> select(String name, Project project) {
        return this.select(name, (ProjectInternal)project, Collections.<Project>emptySet());
    }

    public SetMultimap<String, TaskSelectionResult> selectAll(String name, Project project) {
        return this.select(name, (ProjectInternal)project, project.getSubprojects());
    }

    private SetMultimap<String, TaskSelectionResult> select(String name, ProjectInternal project, Iterable<Project> additionalProjects) {
        LinkedHashMultimap selected = LinkedHashMultimap.create();
        Task task = (Task)project.getTasks().findByName(name);
        if (task != null) {
            selected.put((Object)task.getName(), (Object)new LazyTaskSelectionResult(task.getName(), project.getTasks()));
        } else {
            task = (Task)project.getImplicitTasks().findByName(name);
            if (task != null) {
                selected.put((Object)task.getName(), (Object)new LazyTaskSelectionResult(task.getName(), project.getImplicitTasks()));
            }
        }
        for (Project additionalProject : additionalProjects) {
            task = (Task)additionalProject.getTasks().findByName(name);
            if (task == null) continue;
            selected.put((Object)task.getName(), (Object)new LazyTaskSelectionResult(task.getName(), additionalProject.getTasks()));
        }
        if (!selected.isEmpty()) {
            return selected;
        }
        for (String taskName : project.getTasks().getNames()) {
            selected.put((Object)taskName, (Object)new LazyTaskSelectionResult(taskName, project.getTasks()));
        }
        for (String taskName : project.getImplicitTasks().getNames()) {
            if (selected.containsKey((Object)taskName)) continue;
            selected.put((Object)taskName, (Object)new LazyTaskSelectionResult(taskName, project.getImplicitTasks()));
        }
        for (Project additionalProject : additionalProjects) {
            for (String taskName : additionalProject.getTasks().getNames()) {
                selected.put((Object)taskName, (Object)new LazyTaskSelectionResult(taskName, additionalProject.getTasks()));
            }
        }
        return selected;
    }

    public static class LazyTaskSelectionResult
    implements TaskSelectionResult {
        private final TaskContainer taskContainer;
        private final String taskName;

        public LazyTaskSelectionResult(String taskName, TaskContainer tasksContainer) {
            this.taskContainer = tasksContainer;
            this.taskName = taskName;
        }

        public Task getTask() {
            return this.taskContainer.getByName(this.taskName);
        }
    }
}

