/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectUtil;

public class ConfigureDelegate
extends GroovyObjectSupport {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    protected final DynamicObject _owner;
    protected final DynamicObject _delegate;
    private final ThreadLocal<Boolean> _configuring = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public ConfigureDelegate(Object owner, Object delegate) {
        this._owner = DynamicObjectUtil.asDynamicObject(owner);
        this._delegate = DynamicObjectUtil.asDynamicObject(delegate);
    }

    public String toString() {
        return this._delegate.toString();
    }

    protected boolean _isConfigureMethod(String name, Object[] params) {
        return false;
    }

    protected Object _configure(String name, Object[] params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String name, Object paramsObj) {
        Object[] params = (Object[])paramsObj;
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            Object object = this._delegate.invokeMethod(name, params);
            return object;
        }
        catch (MissingMethodException e2) {
            if (!name.equals(e2.getMethod())) {
                throw e2;
            }
            MissingMethodException failure = e2;
            try {
                Object e2 = this._owner.invokeMethod(name, params);
                return e2;
            }
            catch (MissingMethodException e3) {
                if (!name.equals(e3.getMethod())) {
                    throw e3;
                }
                if (isAlreadyConfiguring || !this._isConfigureMethod(name, params)) {
                    throw failure;
                }
                Object object = this._configure(name, params);
                return object;
            }
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) {
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            Object object = this._delegate.getProperty(name);
            return object;
        }
        catch (MissingPropertyException e2) {
            if (!name.equals(e2.getProperty())) {
                throw e2;
            }
            MissingPropertyException failure = e2;
            try {
                Object e2 = this._owner.getProperty(name);
                return e2;
            }
            catch (MissingPropertyException e3) {
                if (!name.equals(e3.getProperty())) {
                    throw e3;
                }
                if (isAlreadyConfiguring) {
                    throw failure;
                }
                Object object = this._configure(name, EMPTY_PARAMS);
                return object;
            }
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }
}

