/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    private final int bufferSize;

    public BufferedInputStream(InputStream in) {
        this(in, 2048);
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
        this.count = this.bufferSize = size;
        this.pos = this.bufferSize;
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    public void close() throws IOException {
        this.buf = null;
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int totalBytesRead = Math.min(this.count - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, totalBytesRead);
        this.pos += totalBytesRead;
        off += totalBytesRead;
        len -= totalBytesRead;
        while (len > 0 && this.in.available() > 0 && this.refill()) {
            int remain = Math.min(this.count - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, remain);
            this.pos += remain;
            off += remain;
            len -= remain;
            totalBytesRead += remain;
        }
        return totalBytesRead;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos == -1) {
            throw new IOException(this.buf == null ? "Stream closed." : "Invalid mark.");
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long n) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        long origN = n;
        while (n > 0L) {
            if (this.pos >= this.count) {
                if (this.markpos == -1) {
                    n -= this.in.skip(n);
                    break;
                }
                if (!this.refill()) break;
            }
            int numread = (int)Math.min((long)(this.count - this.pos), n);
            this.pos += numread;
            n -= (long)numread;
        }
        return origN - n;
    }

    boolean refill() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        if (this.markpos == -1 || this.count - this.markpos >= this.marklimit) {
            this.markpos = -1;
            this.count = 0;
            this.pos = 0;
        } else {
            byte[] newbuf = this.buf;
            if (this.markpos < this.bufferSize) {
                newbuf = new byte[this.count - this.markpos + this.bufferSize];
            }
            System.arraycopy(this.buf, this.markpos, newbuf, 0, this.count - this.markpos);
            this.buf = newbuf;
            this.count -= this.markpos;
            this.pos -= this.markpos;
            this.markpos = 0;
        }
        int numread = this.in.read(this.buf, this.count, this.bufferSize);
        if (numread <= 0) {
            return false;
        }
        this.count += numread;
        return true;
    }
}

