/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.ShortBuffer;

final class ShortBufferImpl
extends ShortBuffer {
    private final boolean readOnly;

    ShortBufferImpl(int capacity) {
        this(new short[capacity], 0, capacity, capacity, 0, -1, false);
    }

    ShortBufferImpl(short[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark, null, buffer, offset);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ShortBuffer slice() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ShortBuffer duplicate() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public ShortBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int p = this.position();
        int n = this.limit() - p;
        if (n > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + p, this.backing_buffer, this.array_offset, n);
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public short get() {
        this.checkForUnderflow();
        short result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public ShortBuffer put(short value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public short get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index];
    }

    public ShortBuffer put(int index, short value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        this.backing_buffer[index] = value;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

