/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.key;

import gnu.javax.crypto.jce.key.SecretKeyFactoryImpl;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class DESSecretKeyFactoryImpl
extends SecretKeyFactoryImpl {
    protected SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof DESKeySpec) {
            return new SecretKeySpec(((DESKeySpec)spec).getKey(), "DES");
        }
        return super.engineGenerateSecret(spec);
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(DESKeySpec.class)) {
            try {
                return new DESKeySpec(key.getEncoded());
            }
            catch (InvalidKeyException ike) {
                InvalidKeySpecException ikse = new InvalidKeySpecException("can't create DES key spec");
                ikse.initCause(ike);
                throw ikse;
            }
        }
        return super.engineGetKeySpec(key, spec);
    }
}

