/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingMenuItemPeer;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuPeer;
import javax.swing.JMenu;

public class SwingMenuPeer
implements MenuPeer {
    Menu awtMenu;
    SwingMenu menu;

    public SwingMenuPeer(Menu awtMenu) {
        this.awtMenu = awtMenu;
        this.menu = new SwingMenu();
        this.menu.setDoubleBuffered(false);
        this.menu.setText(awtMenu.getLabel());
        int i = 0;
        while (i < awtMenu.getItemCount()) {
            MenuItem item = awtMenu.getItem(i);
            item.addNotify();
            SwingMenuItemPeer peer = (SwingMenuItemPeer)item.getPeer();
            this.menu.add(peer.menuItem);
            ++i;
        }
    }

    public void addItem(MenuItem item) {
        SwingMenuItemPeer menuItemPeer = (SwingMenuItemPeer)item.getPeer();
        this.menu.add(menuItemPeer.menuItem);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void delItem(int index) {
        this.menu.remove(index);
    }

    public void disable() {
        this.menu.setEnabled(false);
    }

    public void enable() {
        this.menu.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        this.menu.setEnabled(enabled);
    }

    public void setLabel(String text) {
        this.menu.setText(text);
    }

    public void dispose() {
        this.menu = null;
        this.awtMenu = null;
    }

    public void setFont(Font font) {
        this.menu.setFont(font);
    }

    public void handleMouseEvent(MouseEvent ev) {
        this.menu.handleMouseEvent(ev);
    }

    public void handleMouseMotionEvent(MouseEvent ev) {
        this.menu.handleMouseMotionEvent(ev);
    }

    int getX() {
        return this.menu.getX();
    }

    int getWidth() {
        return this.menu.getWidth();
    }

    public int getY() {
        return this.menu.getY();
    }

    private class SwingMenu
    extends JMenu {
        private SwingMenu() {
        }

        public boolean isShowing() {
            return true;
        }

        public Point getLocationOnScreen() {
            Point parentLoc = this.getParent().getLocationOnScreen();
            parentLoc.x += this.getX();
            parentLoc.y += this.getY();
            return parentLoc;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseEvent(ev);
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseMotionEvent(ev);
        }
    }
}

