/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;

public class InstallerTranslations {
    private static final File SOURCE_DIRECTORY = new File("data/strings");
    private static final File MAIN_FILE = new File(SOURCE_DIRECTORY, "FreeColMessages.properties");
    private static final File DESTINATION_DIRECTORY = new File("build/installer");
    private static final File LANGUAGE_CODES = new File(DESTINATION_DIRECTORY, "iso-639-2.txt");
    private static final String[][] IZPACK_CODES = new String[][]{{"ca", "cat", "Catalunyan"}, {"zh", "chn", "Chinese"}, {"cs", "cze", "Czech"}, {"da", "dan", "Danish"}, {"de", "deu", "German"}, {"en", "eng", "English"}, {"eu", "eus", "Basque"}, {"fi", "fin", "Finnish"}, {"fr", "fra", "French"}, {"gl", "glg", "Galician"}, {"hu", "hun", "Hungarian"}, {"it", "ita", "Italian"}, {"ja", "jpn", "Japanese"}, {"ms", "mys", "Malaysian"}, {"nl", "ned", "Nederlands"}, {"nn", "nor", "Norwegian"}, {"pl", "pol", "Polish"}, {"pt_BR", "por", "Portuguese (Brazilian)"}, {"pt_PT", "prt", "Portuguese (European)"}, {"ro", "rom", "Romanian"}, {"ru", "rus", "Russian"}, {"sr", "scg", "Serbian"}, {"es", "spa", "Spanish"}, {"sk", "svk", "Slovakian"}, {"sv", "swe", "Swedish"}, {"uk", "ukr", "Ukrainian"}};
    private static final String[] KEYS = new String[]{"FreeCol", "FreeCol.description", "GameManual", "GameManual.description", "SourceCode", "SourceCode.description", "Music", "Music.description", "SoundEffects", "SoundEffects.description", "MovieClips", "MovieClips.description", "MovieClips.description2", "Location.Web", "FreeColLanguage", "FreeColLanguage.autodetect", "FreeColLanguage.description", "UserFiles", "UserFiles.home", "UserFiles.freecol", "UserFiles.other"};

    public static void main(String[] args) throws Exception {
        String[] sourceFiles;
        if (!MAIN_FILE.exists()) {
            System.out.println("Main input file not found.");
            System.exit(1);
        }
        if (!DESTINATION_DIRECTORY.exists()) {
            DESTINATION_DIRECTORY.mkdirs();
        }
        HashMap<String, String> languageMappings = new HashMap<String, String>();
        for (String[] mapping : IZPACK_CODES) {
            languageMappings.put(mapping[0], mapping[1]);
        }
        Map<String, String> mainProperties = InstallerTranslations.readFile(MAIN_FILE);
        for (String name : sourceFiles = SOURCE_DIRECTORY.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_.*\\.properties");
            }
        })) {
            String languageCode = null;
            int index = name.indexOf(46, 16);
            if (index < 0) continue;
            languageCode = (String)languageMappings.get(name.substring(16, index));
            if (languageCode == null) {
                index = name.indexOf(95, 16);
                if (index < 0) continue;
                languageCode = (String)languageMappings.get(name.substring(16, index));
            }
            if (languageCode == null) {
                System.out.println("Skipping source file: " + name);
                continue;
            }
            System.out.println("Processing source file: " + name);
            File sourceFile = new File(SOURCE_DIRECTORY, name);
            Map<String, String> sourceProperties = InstallerTranslations.readFile(sourceFile);
            StringBuilder output = new StringBuilder();
            output.append("<?xml version = '1.0' encoding = 'UTF-8' standalone = 'yes'?>\n");
            output.append("<!-- ATTENTION: Do not modify this file directly,\n");
            output.append("     modify the source file\n         ");
            output.append(sourceFile.getPath());
            output.append("\n     instead. -->\n");
            output.append("<langpack>\n");
            for (String key : KEYS) {
                String longKey = "installer." + key;
                String value = sourceProperties.get(longKey);
                if (value == null) {
                    value = mainProperties.get(longKey);
                }
                output.append("    <str id=\"");
                output.append(key);
                output.append("\" txt=\"");
                output.append(value);
                output.append("\" />\n");
            }
            output.append("</langpack>\n");
            File destinationFile = new File(DESTINATION_DIRECTORY, "lang.xml_" + languageCode);
            FileWriter out = new FileWriter(destinationFile);
            out.write(output.toString());
            out.close();
        }
    }

    private static Map<String, String> readFile(File file) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    result.put(line.substring(0, index), line.substring(index + 1));
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

