/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.panel.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.panel.Flag;

public class FlagTest
extends JFrame
implements ActionListener,
ItemListener {
    private final Flag[] FLAGS = new Flag[]{ConfirmDeclarationDialog.ENGLISH_FLAG, ConfirmDeclarationDialog.SPANISH_FLAG, ConfirmDeclarationDialog.FRENCH_FLAG, ConfirmDeclarationDialog.DUTCH_FLAG, ConfirmDeclarationDialog.PORTUGUESE_FLAG, ConfirmDeclarationDialog.SWEDISH_FLAG, ConfirmDeclarationDialog.DANISH_FLAG, ConfirmDeclarationDialog.RUSSIAN_FLAG, null};
    private static final String[] FLAG_NAMES = new String[]{"England", "Spain", "France", "Netherlands", "Portugal", "Sweden", "Denmark", "Russia", "Custom"};
    private Flag flag;
    private JComboBox<String> flags = new JComboBox<String>(FLAG_NAMES);
    private JComboBox<Flag.Decoration> decoration = new JComboBox<Flag.Decoration>(Flag.Decoration.values());
    private JComboBox<Flag.Background> background = new JComboBox<Flag.Background>(Flag.Background.values());
    private JComboBox<Flag.UnionPosition> union = new JComboBox<Flag.UnionPosition>(Flag.UnionPosition.values());
    private JComboBox<Flag.UnionShape> unionShape = new JComboBox<Flag.UnionShape>(Flag.UnionShape.values());
    private JComboBox<String> stars = new JComboBox<String>(this.getNumbers(50));
    private JComboBox<String> stripes = new JComboBox<String>(this.getNumbers(13));
    private ConfirmDeclarationDialog.ColorButton unionColor = new ConfirmDeclarationDialog.ColorButton(Color.BLUE);
    private ConfirmDeclarationDialog.ColorButton starColor = new ConfirmDeclarationDialog.ColorButton(Color.WHITE);
    private ConfirmDeclarationDialog.ColorButton decorationColor = new ConfirmDeclarationDialog.ColorButton(Color.WHITE);
    private ConfirmDeclarationDialog.ColorButton[] backgroundColors = new ConfirmDeclarationDialog.ColorButton[]{new ConfirmDeclarationDialog.ColorButton(null), new ConfirmDeclarationDialog.ColorButton(null), new ConfirmDeclarationDialog.ColorButton(null), new ConfirmDeclarationDialog.ColorButton(null), new ConfirmDeclarationDialog.ColorButton(null), new ConfirmDeclarationDialog.ColorButton(null)};
    private Component[] customComponents = new Component[]{this.background, this.decoration, this.union, this.unionShape, this.stripes, this.unionColor, this.starColor, this.decorationColor, this.backgroundColors[0], this.backgroundColors[1], this.backgroundColors[2], this.backgroundColors[3], this.backgroundColors[4], this.backgroundColors[5]};
    final JLabel label = new JLabel();

    public FlagTest() {
        super("FlagTest");
        this.setDefaultCloseOperation(3);
        this.setLayout(new MigLayout("wrap 2", "[][fill]"));
        this.flags.addItemListener(this);
        this.add(new JLabel("predefined flags"));
        this.add(this.flags);
        this.background.addItemListener(this);
        this.add(new JLabel("background"));
        this.add(this.background);
        this.decoration.addItemListener(this);
        this.add(new JLabel("decoration"));
        this.add(this.decoration);
        this.union.addItemListener(this);
        this.add(new JLabel("union position"));
        this.add(this.union);
        this.unionShape.addItemListener(this);
        this.add(new JLabel("union shape"));
        this.add(this.unionShape);
        this.stars.setSelectedIndex(12);
        this.stars.addItemListener(this);
        this.add(new JLabel("number of stars"));
        this.add(this.stars);
        this.stripes.setSelectedIndex(12);
        this.stripes.addItemListener(this);
        this.add(new JLabel("number of stripes"));
        this.add(this.stripes);
        this.unionColor.addActionListener(this);
        this.add(new JLabel("union color"));
        this.add(this.unionColor);
        this.decorationColor.addActionListener(this);
        this.add(new JLabel("decoration color"));
        this.add(this.decorationColor);
        this.starColor.addActionListener(this);
        this.add(new JLabel("star color"));
        this.add(this.starColor);
        this.add(new JLabel("background colors"));
        for (int index = 0; index < this.backgroundColors.length; ++index) {
            ConfirmDeclarationDialog.ColorButton button = this.backgroundColors[index];
            button.addActionListener(this);
            if (index == 0) {
                this.add((Component)button, "split 3");
                continue;
            }
            if (index % 3 == 0) {
                this.add((Component)button, "skip, split 3");
                continue;
            }
            this.add(button);
        }
        this.add((Component)this.label, "width 200, height 100");
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Flag.Background newBackground = (Flag.Background)((Object)this.background.getSelectedItem());
        Flag.Decoration newDecoration = (Flag.Decoration)((Object)this.decoration.getSelectedItem());
        Flag.UnionPosition newPosition = (Flag.UnionPosition)((Object)this.union.getSelectedItem());
        Flag.UnionShape newShape = (Flag.UnionShape)((Object)this.unionShape.getSelectedItem());
        Flag newFlag = this.FLAGS[this.flags.getSelectedIndex()];
        if (e == null || e.getSource() == this.flags) {
            if (newFlag == null) {
                this.enable(this.customComponents, true);
            } else {
                this.enable(this.customComponents, false);
                this.flag = newFlag;
                this.unionColor.setColor(this.flag.getUnionColor());
                this.starColor.setColor(this.flag.getStarColor());
                this.decorationColor.setColor(this.flag.getDecorationColor());
                List<Color> colors = this.flag.getBackgroundColors();
                for (int index = 0; index < this.backgroundColors.length; ++index) {
                    Color color = index < colors.size() ? colors.get(index) : null;
                    this.backgroundColors[index].setColor(color);
                }
            }
        } else {
            if (newFlag == null) {
                if (e.getSource() == this.decoration) {
                    Flag.UnionPosition oldPosition = (Flag.UnionPosition)((Object)this.union.getSelectedItem());
                    this.union.removeAllItems();
                    for (Flag.UnionPosition position : newDecoration.unionPositions) {
                        this.union.addItem(position);
                    }
                    this.union.setSelectedItem((Object)oldPosition);
                }
                this.flag = new Flag(newBackground, newDecoration, newPosition, newShape);
                this.flag.setStripes(this.stripes.getSelectedIndex() + 1);
                this.setColors();
            }
            this.flag.setStars(this.stars.getSelectedIndex() + 1);
        }
        this.stripes.setEnabled(newBackground == Flag.Background.PALES || newBackground == Flag.Background.FESSES);
        this.label.setIcon(new ImageIcon(this.flag.getImage()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ConfirmDeclarationDialog.ColorButton button = (ConfirmDeclarationDialog.ColorButton)e.getSource();
        Color color = JColorChooser.showDialog(this, this.label.getText(), button.getBackground());
        button.setColor(color);
        this.setColors();
        this.label.setIcon(new ImageIcon(this.flag.getImage()));
    }

    private void setColors() {
        this.flag.setUnionColor(this.unionColor.getColor());
        this.flag.setStarColor(this.starColor.getColor());
        this.flag.setDecorationColor(this.decorationColor.getColor());
        ArrayList<Color> colors = new ArrayList<Color>();
        for (ConfirmDeclarationDialog.ColorButton button : this.backgroundColors) {
            Color color = button.getColor();
            if (color != null) {
                colors.add(color);
            }
            this.flag.setBackgroundColors(colors);
        }
    }

    public final String[] getNumbers(int count) {
        String[] result = new String[count];
        for (int index = 0; index < count; ++index) {
            result[index] = Integer.toString(index + 1);
        }
        return result;
    }

    private void enable(Component[] components, boolean value) {
        for (Component component : components) {
            component.setEnabled(value);
        }
    }

    public static void main(String[] args) {
        FlagTest frame = new FlagTest();
        frame.pack();
        frame.setVisible(true);
    }
}

