/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;

public class DesktopEntry {
    private static final File SOURCE_DIRECTORY = new File("data", "strings");
    private static final String GENERIC_NAME = "freecol.desktopEntry.GenericName";
    private static final String COMMENT = "freecol.desktopEntry.Comment";

    public static void main(String[] args) throws Exception {
        String[] sourceFiles;
        FileWriter result = new FileWriter(new File(args[0]));
        result.append("[Desktop Entry]\n");
        result.append("Version=1.0\n");
        result.append("Type=Application\n");
        result.append("Name=FreeCol\n");
        result.append("Exec=freecol\n");
        result.append("Icon=data/freecol.png\n");
        result.append("Categories=Game;StrategyGame;\n");
        block0: for (String name : sourceFiles = SOURCE_DIRECTORY.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("FreeColMessages") && name.endsWith(".properties");
            }
        })) {
            System.out.println("Processing source file: " + name);
            String languageCode = null;
            if (name.startsWith("FreeColMessages_")) {
                int index = name.indexOf(46, 16);
                languageCode = name.substring(16, index).replace('-', '@');
            }
            boolean foundGenericName = false;
            boolean foundComment = false;
            File sourceFile = new File(SOURCE_DIRECTORY, name);
            FileReader fileReader = new FileReader(sourceFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    String key = line.substring(0, index).trim();
                    if (GENERIC_NAME.equals(key)) {
                        result.append("GenericName");
                        foundGenericName = true;
                    } else if (COMMENT.equals(key)) {
                        result.append("Comment");
                        foundComment = true;
                    } else {
                        line = bufferedReader.readLine();
                        continue;
                    }
                    if (languageCode != null) {
                        result.append("[" + languageCode + "]");
                    }
                    result.append("=");
                    result.append(line.substring(index + 1).trim());
                    result.append("\n");
                    if (foundGenericName && foundComment) continue block0;
                }
                line = bufferedReader.readLine();
            }
        }
        result.flush();
        result.close();
    }
}

