/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

public final class Server
extends Thread {
    private static Logger logger = Logger.getLogger(Server.class.getName());
    private static final int BACKLOG_DEFAULT = 10;
    private ServerSocket serverSocket;
    private HashMap<Socket, Connection> connections = new HashMap();
    private boolean running = true;
    private FreeColServer freeColServer;
    private int port;
    private final Object shutdownLock = new Object();

    public Server(FreeColServer freeColServer, int port) throws IOException {
        super("FreeColServer:Server");
        this.freeColServer = freeColServer;
        this.port = port;
        this.serverSocket = new ServerSocket(port, 10, InetAddress.getByName("localhost"));
        this.serverSocket.setReuseAddress(true);
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection(Socket socket) {
        return this.connections.get(socket);
    }

    public void addDummyConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        this.connections.put(new Socket(), connection);
    }

    public void addConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        this.connections.put(connection.getSocket(), connection);
    }

    public void removeConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        this.connections.remove(connection.getSocket());
    }

    public void setMessageHandlerToAllConnections(MessageHandler mh) {
        for (Connection c : this.connections.values()) {
            c.setMessageHandler(mh);
        }
    }

    public void sendToAll(Element element, Connection exceptConnection) {
        for (Connection c : new ArrayList<Connection>(this.connections.values())) {
            if (c == exceptConnection) continue;
            try {
                c.sendAndWait(element);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to send to: " + c, e);
            }
        }
    }

    public void sendToAll(Element element) {
        this.sendToAll(element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = this.shutdownLock;
        synchronized (object) {
            while (this.running) {
                Socket clientSocket = null;
                try {
                    clientSocket = this.serverSocket.accept();
                    logger.info("Got client connection from " + clientSocket.getInetAddress());
                    Connection connection = new Connection(clientSocket, this.freeColServer.getUserConnectionHandler(), "FreeColServer:");
                    if (connection == null) continue;
                    this.connections.put(clientSocket, connection);
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    logger.log(Level.WARNING, "Connection failed: ", e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            this.serverSocket.close();
            logger.fine("Closed server socket.");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not close the server socket!", e);
        }
        Object e = this.shutdownLock;
        synchronized (e) {
            logger.fine("Wait for Server.run to complete.");
        }
        for (Connection c : this.connections.values()) {
            c.close();
        }
        this.connections.clear();
        this.freeColServer.removeFromMetaServer();
        logger.fine("Server shutdown.");
    }
}

