/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.TransactionSession;

public class TradeSession
extends TransactionSession {
    private static final Logger logger = Logger.getLogger(TradeSession.class.getName());
    private int movesLeft;
    private boolean actionTaken;
    private boolean canBuy;
    private boolean canSell;
    private boolean canGift;

    public TradeSession(Unit unit, Settlement settlement) {
        super(TradeSession.makeSessionKey(TradeSession.class, unit, settlement));
        this.movesLeft = unit.getMovesLeft();
        this.actionTaken = false;
        boolean atWar = settlement.getOwner().atWarWith(unit.getOwner());
        this.canBuy = !atWar;
        this.canSell = !atWar && unit.hasGoodsCargo();
        this.canGift = unit.hasGoodsCargo();
    }

    @Override
    public void complete(ChangeSet cs) {
        super.complete(cs);
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public boolean getActionTaken() {
        return this.actionTaken;
    }

    public boolean getBuy() {
        return this.canBuy;
    }

    public boolean getSell() {
        return this.canSell;
    }

    public boolean getGift() {
        return this.canGift;
    }

    public void setBuy() {
        this.actionTaken = true;
        this.canBuy = false;
    }

    public void setSell() {
        this.actionTaken = true;
        this.canSell = false;
    }

    public void setGift() {
        this.actionTaken = true;
        this.canGift = false;
    }
}

