/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;

public class ServerUnit
extends Unit
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerUnit.class.getName());
    private static final int MAYAN_PROPHESY_YEAR = 2012;
    private static int rumourNothing = -1;

    public ServerUnit(Game game, String id) {
        super(game, id);
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type) {
        this(game, location, owner, type, type.getDefaultRole());
    }

    public ServerUnit(Game game, Location location, Unit template) {
        this(game, location, game.getPlayer(template.getOwner().getNationId()), game.getSpecification().getUnitType(template.getType().getId()), game.getSpecification().getDefaultRole());
        Specification spec = this.getSpecification();
        this.setNationality(template.getNationality());
        this.setEthnicity(template.getEthnicity());
        this.workLeft = template.getWorkLeft();
        this.workType = spec.getGoodsType(template.getWorkType().getId());
        this.movesLeft = template.getMovesLeft();
        this.hitPoints = template.getType().getHitPoints();
        this.changeRole(spec.getRole(template.getRole().getId()), template.getRoleCount());
        this.setStateUnchecked(template.getState());
        if (this.getType().canCarryGoods()) {
            this.setGoodsContainer(new GoodsContainer(game, this));
        }
        this.visibleGoodsCount = -1;
    }

    public ServerUnit(Game game, Location location, Player owner, UnitType type, Role role) {
        super(game);
        UnitType newType = type.getTargetType(UnitTypeChange.ChangeType.CREATION, owner);
        this.unitType = newType == null ? type : newType;
        this.owner = owner;
        this.state = Unit.UnitState.ACTIVE;
        this.role = this.getSpecification().getDefaultRole();
        this.location = null;
        this.entryLocation = null;
        if (this.unitType.hasAbility("model.ability.person")) {
            this.ethnicity = this.nationality = owner.getNationId();
        } else {
            this.nationality = null;
            this.ethnicity = null;
        }
        this.workLeft = -1;
        this.workType = null;
        this.movesLeft = this.getInitialMovesLeft();
        this.hitPoints = this.unitType.getHitPoints();
        this.experienceType = null;
        this.experience = 0;
        this.workImprovement = null;
        this.teacher = null;
        this.student = null;
        this.turnsOfTraining = 0;
        this.indianSettlement = null;
        this.hitPoints = this.unitType.getHitPoints();
        this.destination = null;
        this.tradeRoute = null;
        this.currentStop = -1;
        this.treasureAmount = 0;
        this.attrition = 0;
        this.visibleGoodsCount = -1;
        this.changeRole(role, role.getMaximumCount());
        this.setStateUnchecked(this.state);
        this.setLocation(location);
        if (this.getType().canCarryGoods()) {
            this.setGoodsContainer(new GoodsContainer(game, this));
        }
        owner.addUnit(this);
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        int maximumExperience;
        int maxValue;
        UnitType learn;
        GoodsType produce;
        lb.add(this);
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Specification spec = this.getSpecification();
        Location loc = this.getLocation();
        boolean locDirty = false;
        boolean unitDirty = false;
        if (loc instanceof Tile && !((Tile)loc).hasSettlement()) {
            int attrition = this.getAttrition() + 1;
            this.setAttrition(attrition);
            if (attrition > this.getType().getMaximumAttrition()) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.unit.attrition", this).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%location%", loc.getLocationLabelFor(owner)));
                cs.add(ChangeSet.See.perhaps(), (Tile)loc);
                cs.addDispose(ChangeSet.See.perhaps().always(owner), loc, this);
                owner.invalidateCanSeeTiles();
                lb.add(", ");
                return;
            }
        } else {
            this.setAttrition(0);
        }
        if (this.isInColony() && (produce = this.getWorkType()) != null && (learn = spec.getExpertForProducing(produce)) != null && learn != this.getType() && this.getType().canBeUpgraded(learn, UnitTypeChange.ChangeType.EXPERIENCE) && (maxValue = 100 * (maximumExperience = this.getType().getMaximumExperience()) / this.getType().getUnitTypeChange(learn).getProbability(UnitTypeChange.ChangeType.EXPERIENCE)) > 0 && RandomUtils.randomInt(logger, "Experience", random, maxValue) < Math.min(this.getExperience(), maximumExperience)) {
            StringTemplate oldName = this.getLabel();
            this.changeType(learn);
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "model.unit.experience", this.getColony(), this).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", this.getLabel()).addName("%colony%", this.getColony().getName()));
            lb.add(" experience upgrade to ", this.getType());
            unitDirty = true;
        }
        if (this.isInMission()) {
            this.getTile().updateIndianSettlement(owner);
            this.setMovesLeft(0);
        } else if (this.isDamaged()) {
            this.setMovesLeft(0);
        } else {
            this.setMovesLeft(this.getInitialMovesLeft());
        }
        if (this.getWorkLeft() > 0) {
            unitDirty = true;
            switch (this.getState()) {
                case IMPROVING: {
                    TileImprovement ti = this.getWorkImprovement();
                    if (ti == null || ti.isComplete()) {
                        this.setState(Unit.UnitState.ACTIVE);
                        this.setWorkLeft(-1);
                        break;
                    }
                    int amount = this.getType().hasAbility("model.ability.expertPioneer") ? 2 : 1;
                    int turns = ti.getTurnsToComplete();
                    if ((turns -= amount) < 0) {
                        turns = 0;
                    }
                    ti.setTurnsToComplete(turns);
                    this.setWorkLeft(turns);
                    if (!ti.isRoad() || !ti.isComplete()) break;
                    ti.updateRoadConnections(true);
                    for (Tile t : loc.getTile().getSurroundingTiles(1)) {
                        if (!t.hasRoad()) continue;
                        cs.add(ChangeSet.See.perhaps(), t);
                    }
                    locDirty = true;
                    break;
                }
                default: {
                    this.setWorkLeft(this.getWorkLeft() - 1);
                }
            }
            if (loc instanceof HighSeas && this.getOwner().isREF()) {
                this.setWorkLeft(0);
            }
        }
        if (this.getState() == Unit.UnitState.SKIPPED) {
            this.setState(Unit.UnitState.ACTIVE);
            unitDirty = true;
        }
        if (this.getWorkLeft() == 0) {
            this.setWorkLeft(-1);
            unitDirty = true;
            if (this.getLocation() instanceof HighSeas) {
                Europe europe = owner.getEurope();
                Location dst = this.getDestination();
                Location result = this.resolveDestination();
                if (result == europe) {
                    lb.add(" arrives in Europe");
                    if (this.getTradeRoute() == null) {
                        this.setDestination(null);
                        cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.unit.arriveInEurope", europe, this).add("%europe%", europe.getNameKey()));
                    }
                    this.setState(Unit.UnitState.ACTIVE);
                    this.setLocation(europe);
                    cs.add(ChangeSet.See.only(owner), owner.getHighSeas());
                    locDirty = true;
                } else if (result instanceof Tile) {
                    Tile tile = ((Tile)result).getSafeTile(owner, random);
                    lb.add(" arrives in America at ", tile);
                    if (dst != null) {
                        lb.add(" sailing for ", dst);
                    }
                    if (dst instanceof Map) {
                        this.setDestination(null);
                    }
                    this.csMove(tile, random, cs);
                    unitDirty = false;
                    locDirty = false;
                } else {
                    lb.add(" has unsupported destination ", this.getDestination());
                }
            } else {
                switch (this.getState()) {
                    case FORTIFYING: {
                        this.setState(Unit.UnitState.FORTIFIED);
                        break;
                    }
                    case IMPROVING: {
                        this.csImproveTile(random, cs);
                        this.setWorkImprovement(null);
                        locDirty = true;
                        break;
                    }
                    default: {
                        lb.add(new Object[]{" unknown work completed, state=", this.getState()});
                        this.setState(Unit.UnitState.ACTIVE);
                    }
                }
            }
        }
        if (locDirty) {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)this.getLocation()));
        } else if (unitDirty) {
            cs.add(ChangeSet.See.perhaps(), this);
        } else {
            cs.addPartial(ChangeSet.See.only(owner), this, "movesLeft");
        }
        lb.add(", ");
    }

    private void csImproveTile(Random random, ChangeSet cs) {
        TileImprovementType tileImprovementType;
        int exposeResource;
        TileImprovement ti;
        TileType changeType;
        Tile tile = this.getTile();
        tile.cacheUnseen();
        AbstractGoods deliver = this.getWorkImprovement().getType().getProduction(tile.getType());
        if (deliver != null) {
            Settlement settlement;
            Turn turn = this.getGame().getTurn();
            int amount = deliver.getAmount();
            if (this.getType().hasAbility("model.ability.expertPioneer")) {
                amount *= 2;
            }
            if ((settlement = tile.getSettlement()) != null && this.owner.owns(settlement)) {
                amount = (int)settlement.applyModifiers(amount, turn, "model.modifier.tileTypeChangeProduction", deliver.getType());
                settlement.addGoods(deliver.getType(), amount);
            } else {
                ArrayList<Settlement> adjacent = new ArrayList<Settlement>();
                int newAmount = amount;
                for (Tile t : tile.getSurroundingTiles(2)) {
                    Settlement ts = t.getSettlement();
                    if (ts == null || !this.owner.owns(ts)) continue;
                    adjacent.add(ts);
                    int modAmount = (int)ts.applyModifiers(amount, turn, "model.modifier.tileTypeChangeProduction", deliver.getType());
                    if (modAmount <= newAmount) continue;
                    newAmount = modAmount;
                }
                if (adjacent.size() > 0) {
                    int deliverPerCity = newAmount / adjacent.size();
                    for (Settlement s : adjacent) {
                        s.addGoods(deliver.getType(), deliverPerCity);
                    }
                    ((Settlement)adjacent.get(0)).addGoods(deliver.getType(), newAmount % adjacent.size());
                }
            }
        }
        if ((changeType = (ti = this.getWorkImprovement()).getChange(tile.getType())) != null) {
            tile.changeType(changeType);
        }
        if ((exposeResource = (tileImprovementType = ti.getType()).getExposeResourcePercent()) > 0 && !tile.hasResource() && RandomUtils.randomInt(logger, "Expose resource", random, 100) < exposeResource) {
            int maxValue;
            int minValue;
            ResourceType resType = (ResourceType)RandomChoice.getWeightedRandom(logger, "Resource type", tile.getType().getWeightedResources(), random);
            int value = minValue + ((minValue = resType.getMinValue()) == (maxValue = resType.getMaxValue()) ? 0 : RandomUtils.randomInt(logger, "Resource quantity", random, maxValue - minValue + 1));
            tile.addResource(new Resource(this.getGame(), tile, resType, value));
        }
        if (this.changeRoleCount(-ti.getType().getExpendedAmount())) {
            ServerPlayer owner = (ServerPlayer)this.getOwner();
            StringTemplate locName = this.getLocation().getLocationLabelFor(owner);
            String messageId = this.getType() + ".noMoreTools";
            if (!Messages.containsKey(messageId)) {
                messageId = "model.unit.noMoreTools";
            }
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, messageId, this).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%location%", locName));
        }
        for (Unit unit : tile.getUnitList()) {
            if (unit.getWorkImprovement() == null || unit.getWorkImprovement().getType() != ti.getType() || unit.getState() != Unit.UnitState.IMPROVING) continue;
            unit.setWorkLeft(-1);
            unit.setWorkImprovement(null);
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
        }
    }

    public void csEmbark(Unit carrier, ChangeSet cs) {
        Colony colony;
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Location oldLocation = this.getLocation();
        Colony colony2 = colony = oldLocation instanceof WorkLocation ? this.getColony() : null;
        if (colony != null) {
            oldLocation.getTile().cacheUnseen();
        }
        this.setLocation(carrier);
        this.setMovesLeft(0);
        cs.add(ChangeSet.See.only(owner), colony != null ? colony : (FreeColGameObject)((Object)oldLocation));
        if (carrier.getLocation() != oldLocation) {
            cs.add(ChangeSet.See.only(owner), carrier);
        }
        if (oldLocation instanceof Tile) {
            if (carrier.getTile() != (Tile)oldLocation) {
                cs.addMove(ChangeSet.See.only(owner), this, (Tile)oldLocation, carrier.getTile());
                owner.invalidateCanSeeTiles();
            }
            cs.addDisappear(owner, (Tile)oldLocation, this);
        }
    }

    public void csRepairUnit(ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        this.setHitPoints(this.getHitPoints() + 1);
        if (!this.isDamaged()) {
            Location loc = this.getLocation();
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage("model.unit.unitRepaired", this, (FreeColObject)((FreeColGameObject)((Object)loc))).addStringTemplate("%unit%", this.getLabel()).addStringTemplate("%repairLocation%", loc.getLocationLabelFor(owner)));
            this.setState(Unit.UnitState.ACTIVE);
        }
        cs.addPartial(ChangeSet.See.only(owner), this, "hitPoints");
    }

    private Unit getSlowedBy(Tile newTile, Random random) {
        Player player = this.getOwner();
        Game game = this.getGame();
        CombatModel combatModel = game.getCombatModel();
        boolean pirate = this.hasAbility("model.ability.piracy");
        Unit attacker = null;
        float attackPower = 0.0f;
        float totalAttackPower = 0.0f;
        if (!this.isNaval() || this.getMovesLeft() <= 0) {
            return null;
        }
        for (Tile tile : newTile.getSurroundingTiles(1)) {
            Player enemy;
            if (tile.isLand() || tile.getColony() != null || tile.getFirstUnit() == null || (enemy = tile.getFirstUnit().getOwner()) == player) continue;
            for (Unit enemyUnit : tile.getUnitList()) {
                if (!pirate && !enemyUnit.hasAbility("model.ability.piracy") && (!enemyUnit.isOffensiveUnit() || !player.atWarWith(enemy)) || !enemyUnit.isNaval() || !(combatModel.getOffencePower(enemyUnit, this) > attackPower)) continue;
                attackPower = combatModel.getOffencePower(enemyUnit, this);
                totalAttackPower += attackPower;
                attacker = enemyUnit;
            }
        }
        if (attacker != null) {
            float defencePower = combatModel.getDefencePower(attacker, this);
            float totalProbability = totalAttackPower + defencePower;
            if ((float)RandomUtils.randomInt(logger, "Slowed", random, Math.round(totalProbability) + 1) < totalAttackPower) {
                int diff = Math.max(0, Math.round(totalAttackPower - defencePower));
                int moves = Math.min(9, 3 + diff / 3);
                this.setMovesLeft(this.getMovesLeft() - moves);
                logger.info(this.getId() + " slowed by " + attacker.getId() + " by " + Integer.toString(moves) + " moves.");
            } else {
                attacker = null;
            }
        }
        return attacker;
    }

    private void csNativeBurialGround(ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = this.getTile();
        ServerPlayer indianPlayer = (ServerPlayer)tile.getOwner();
        serverPlayer.csContact(indianPlayer, cs);
        indianPlayer.csModifyTension(serverPlayer, Tension.Level.HATEFUL.getLimit(), cs);
        serverPlayer.csChangeStance(Player.Stance.WAR, indianPlayer, true, cs);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.burialGround", serverPlayer, this).addStringTemplate("%nation%", indianPlayer.getNationName()));
    }

    private boolean csExploreLostCityRumour(Random random, ChangeSet cs) {
        boolean mounds;
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = this.getTile();
        LostCityRumour lostCity = tile.getLostCityRumour();
        if (lostCity == null) {
            return true;
        }
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        int difficulty = spec.getInteger("model.option.rumourDifficulty");
        int dx = 10 - difficulty;
        ServerUnit newUnit = null;
        List<UnitType> treasureUnitTypes = spec.getUnitTypesWithAbility("model.ability.carryTreasure");
        LostCityRumour.RumourType rumour = lostCity.getType();
        if (rumour == null) {
            rumour = lostCity.chooseType(this, random);
        }
        switch (rumour) {
            case BURIAL_GROUND: 
            case MOUNDS: {
                if (tile.getOwner() != null && tile.getOwner().isIndian()) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
            case LEARN: {
                if (!this.getType().getUnitTypesLearntInLostCity().isEmpty()) break;
                rumour = LostCityRumour.RumourType.NOTHING;
                break;
            }
        }
        boolean bl = mounds = rumour == LostCityRumour.RumourType.MOUNDS;
        if (mounds) {
            boolean done = false;
            boolean nothing = false;
            block21: while (!done) {
                rumour = lostCity.chooseType(this, random);
                switch (rumour) {
                    case NOTHING: {
                        if (nothing) {
                            done = true;
                            continue block21;
                        }
                        nothing = true;
                        continue block21;
                    }
                    case EXPEDITION_VANISHES: 
                    case TRIBAL_CHIEF: {
                        done = true;
                        continue block21;
                    }
                    case RUINS: {
                        done = true;
                        if (RandomUtils.randomInt(logger, "Ruins+Burial", random, 100) >= spec.getInteger("model.option.badRumour")) continue block21;
                    }
                    case BURIAL_GROUND: {
                        if (tile.getOwner() != null && tile.getOwner().isIndian()) {
                            this.csNativeBurialGround(cs);
                        }
                        done = true;
                        continue block21;
                    }
                }
            }
        }
        logger.info("Unit " + this.getId() + " is exploring rumour " + (Object)((Object)rumour));
        boolean result = true;
        switch (rumour) {
            case BURIAL_GROUND: {
                this.csNativeBurialGround(cs);
                break;
            }
            case EXPEDITION_VANISHES: {
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.expeditionVanishes", serverPlayer));
                result = false;
                break;
            }
            case NOTHING: {
                if (game.getTurn().getYear() % 100 == 12 && RandomUtils.randomInt(logger, "Mayans?", random, 4) == 0) {
                    int years = 2012 - game.getTurn().getYear();
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.mayans", serverPlayer, this).add("%years%", Integer.toString(years)));
                    break;
                }
                if (mounds) {
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.moundsNothing", serverPlayer, this));
                    break;
                }
                if (rumourNothing < 0) {
                    int i = 0;
                    while (Messages.containsKey("lostCityRumour.nothing." + Integer.toString(i))) {
                        ++i;
                    }
                    rumourNothing = i;
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.nothing." + RandomUtils.randomInt(logger, "Nothing rumour", random, rumourNothing), serverPlayer, this));
                break;
            }
            case LEARN: {
                StringTemplate oldName = this.getLabel();
                List<UnitType> learnTypes = this.getType().getUnitTypesLearntInLostCity();
                UnitType unitType = RandomUtils.getRandomMember(logger, "Choose learn", learnTypes, random);
                this.changeType(unitType);
                serverPlayer.invalidateCanSeeTiles();
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.learn", serverPlayer, this).addStringTemplate("%unit%", oldName).add("%type%", this.getType().getNameKey()));
                break;
            }
            case TRIBAL_CHIEF: {
                int chiefAmount = RandomUtils.randomInt(logger, "Chief base amount", random, dx * 10) + dx * 5;
                serverPlayer.modifyGold(chiefAmount);
                cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, mounds ? "lostCityRumour.moundsTrinkets" : "lostCityRumour.tribalChief", serverPlayer, this).addAmount("%money%", chiefAmount));
                serverPlayer.invalidateCanSeeTiles();
                break;
            }
            case COLONIST: {
                List<UnitType> foundTypes = spec.getUnitTypesWithAbility("model.ability.foundInLostCity");
                UnitType unitType = RandomUtils.getRandomMember(logger, "Choose found", foundTypes, random);
                newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.colonist", serverPlayer, newUnit));
                break;
            }
            case CIBOLA: {
                String cityKey = game.nextCityOfCibola();
                if (cityKey != null) {
                    int treasureAmount = RandomUtils.randomInt(logger, "Base treasure amount", random, dx * 600) + dx * 300;
                    UnitType unitType = RandomUtils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                    newUnit.setTreasureAmount(treasureAmount);
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.cibola", serverPlayer, newUnit).add("%city%", cityKey).addAmount("%money%", treasureAmount));
                    cs.addGlobalHistory(game, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.CITY_OF_GOLD, serverPlayer).addStringTemplate("%nation%", serverPlayer.getNationName()).add("%city%", cityKey).addAmount("%treasure%", treasureAmount));
                    break;
                }
            }
            case RUINS: {
                int ruinsAmount = RandomUtils.randomInt(logger, "Base ruins amount", random, dx * 2) * 300 + 50;
                if (ruinsAmount < 500) {
                    serverPlayer.modifyGold(ruinsAmount);
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", "score");
                } else {
                    UnitType unitType = RandomUtils.getRandomMember(logger, "Choose train", treasureUnitTypes, random);
                    newUnit = new ServerUnit(game, tile, serverPlayer, unitType);
                    newUnit.setTreasureAmount(ruinsAmount);
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, mounds ? "lostCityRumour.moundsTreasure" : "lostCityRumour.ruins", serverPlayer, newUnit != null ? newUnit : this).addAmount("%money%", ruinsAmount));
                break;
            }
            case FOUNTAIN_OF_YOUTH: {
                ServerEurope europe = (ServerEurope)serverPlayer.getEurope();
                if (europe == null) {
                    cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.fountainOfYouthWithoutEurope", serverPlayer, this));
                    break;
                }
                if (serverPlayer.isAI()) {
                    europe.generateFountainRecruits(dx, random);
                    cs.add(ChangeSet.See.only(serverPlayer), europe);
                } else {
                    serverPlayer.setRemainingEmigrants(dx);
                    cs.addTrivial(ChangeSet.See.only(serverPlayer), "fountainOfYouth", ChangeSet.ChangePriority.CHANGE_LATE, "migrants", Integer.toString(dx));
                }
                cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.LOST_CITY_RUMOUR, "lostCityRumour.fountainOfYouth", serverPlayer, this));
                cs.addAttribute(ChangeSet.See.only(serverPlayer), "sound", "sound.event.fountainOfYouth");
                break;
            }
            default: {
                logger.warning("Bogus rumour type: " + (Object)((Object)rumour));
            }
        }
        tile.cacheUnseen();
        tile.removeLostCityRumour();
        return result;
    }

    private void csActivateSentries(Tile tile, ChangeSet cs) {
        for (Unit u : tile.getUnitList()) {
            if (u.getState() != Unit.UnitState.SENTRY) continue;
            u.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps(), u);
        }
    }

    public List<Tile> collectNewTiles(Tile tile) {
        ArrayList<Tile> newTiles = new ArrayList<Tile>();
        int los = this.getLineOfSight();
        for (Tile t : tile.getSurroundingTiles(0, los)) {
            if (this.getOwner().canSee(t)) continue;
            newTiles.add(t);
        }
        return newTiles;
    }

    public void csMove(Tile newTile, Random random, ChangeSet cs) {
        Unit slowedBy;
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Location oldLocation = this.getLocation();
        List oldTiles = oldLocation.getTile() == null ? Collections.emptyList() : oldLocation.getTile().getSurroundingTiles(1, this.getLineOfSight());
        List<Tile> newTiles = this.collectNewTiles(newTile);
        this.setState(Unit.UnitState.ACTIVE);
        this.setStateToAllChildren(Unit.UnitState.SENTRY);
        if (!(oldLocation instanceof HighSeas)) {
            if (oldLocation instanceof Unit) {
                this.setMovesLeft(0);
            } else {
                if (this.getMoveCost(newTile) <= 0) {
                    logger.warning("Move of unit: " + this.getId() + " from: " + (oldLocation == null ? "null" : oldLocation.getTile().getId()) + " to: " + newTile.getId() + " has bogus cost: " + this.getMoveCost(newTile));
                    this.setMovesLeft(0);
                }
                this.setMovesLeft(this.getMovesLeft() - this.getMoveCost(newTile));
            }
        }
        if (oldLocation instanceof WorkLocation) {
            oldLocation.getTile().cacheUnseen();
        }
        this.setLocation(newTile);
        if (newTile.hasLostCityRumour() && serverPlayer.isEuropean() && !this.csExploreLostCityRumour(random, cs)) {
            cs.addDispose(ChangeSet.See.perhaps().always(serverPlayer), oldLocation, this);
        }
        serverPlayer.invalidateCanSeeTiles();
        Iterator it = oldTiles.iterator();
        while (it.hasNext()) {
            if (!serverPlayer.canSee((Tile)it.next())) continue;
            it.remove();
        }
        if (!oldTiles.isEmpty()) {
            cs.add(ChangeSet.See.only(serverPlayer), oldTiles);
        }
        if (oldLocation instanceof Tile) {
            cs.addMove(ChangeSet.See.perhaps().always(serverPlayer), this, oldLocation, newTile);
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)oldLocation));
        } else {
            cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)oldLocation));
        }
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), newTile);
        if (this.isDisposed()) {
            return;
        }
        serverPlayer.csSeeNewTiles(newTiles, cs);
        if (newTile.isLand()) {
            boolean firstLanding;
            int d;
            Settlement settlement;
            Unit unit = null;
            if ((newTile.getOwner() == null || newTile.getOwner().isEuropean() && newTile.getOwningSettlement() == null) && serverPlayer.isIndian() && (settlement = this.getHomeIndianSettlement()) != null && (d = newTile.getDistanceTo(settlement.getTile())) < settlement.getRadius() + settlement.getType().getExtraClaimableRadius() && RandomUtils.randomInt(logger, "Claim tribal land", random, d + 1) == 0) {
                newTile.cacheUnseen();
                newTile.changeOwnership(serverPlayer, settlement);
            }
            String newLand = null;
            boolean bl = firstLanding = !serverPlayer.isNewLandNamed();
            if (serverPlayer.isEuropean() && firstLanding) {
                newLand = Messages.getNewLandName(serverPlayer);
                serverPlayer.setNewLandName(newLand);
                cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new NewLandNameMessage(this, newLand));
                logger.finest("First landing for " + serverPlayer + " at " + newTile + " with " + this);
            }
            ArrayList<ServerPlayer> pending = new ArrayList<ServerPlayer>();
            for (Tile t : newTile.getSurroundingTiles(1, 1)) {
                IndianSettlement is;
                ServerPlayer other;
                if (t == null || !t.isLand() || (other = (settlement = t.getSettlement()) != null ? (ServerPlayer)settlement.getOwner() : ((unit = t.getFirstUnit()) != null ? (ServerPlayer)unit.getOwner() : null)) == null || other == serverPlayer || pending.contains(other)) continue;
                if (serverPlayer.csContact(other, cs)) {
                    pending.add(other);
                    if (serverPlayer.isEuropean()) {
                        if (other.isIndian()) {
                            Tile offer = firstLanding && other.owns(newTile) ? newTile : null;
                            serverPlayer.csNativeFirstContact(other, offer, cs);
                        } else {
                            serverPlayer.csEuropeanFirstContact(this, settlement, unit, cs);
                        }
                    } else if (!other.isIndian()) {
                        other.csNativeFirstContact(serverPlayer, null, cs);
                    }
                }
                ServerPlayer contactPlayer = serverPlayer;
                IndianSettlement indianSettlement = is = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
                if (is != null || unit != null && (is = unit.getHomeIndianSettlement()) != null || unit != null && (contactPlayer = (ServerPlayer)unit.getOwner()).isEuropean() && (is = this.getHomeIndianSettlement()) != null && is.getTile() != null) {
                    Tile copied = is.getTile().getTileToCache();
                    if (contactPlayer.hasExplored(is.getTile()) && is.setContacted(contactPlayer)) {
                        is.getTile().cacheUnseen(copied);
                        cs.add(ChangeSet.See.only(contactPlayer), is);
                        StringTemplate nation = is.getOwner().getNationName();
                        cs.addMessage(ChangeSet.See.only(contactPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.nativeSettlementContact", this, is).addStringTemplate("%nation%", nation).addName("%settlement%", is.getName()));
                        logger.finest("First contact between " + contactPlayer.getId() + " and " + is + " at " + newTile);
                    }
                }
                this.csActivateSentries(t, cs);
            }
        } else {
            for (Tile t : newTile.getSurroundingTiles(1, 1)) {
                if (t == null || t.isLand() || t.getFirstUnit() == null || (ServerPlayer)t.getFirstUnit().getOwner() == serverPlayer) continue;
                this.csActivateSentries(t, cs);
            }
        }
        if ((slowedBy = this.getSlowedBy(newTile, random)) != null) {
            StringTemplate enemy = slowedBy.getApparentOwnerName();
            cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.unit.slowed", this, slowedBy).addStringTemplate("%unit%", this.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%enemyUnit%", slowedBy.getLabel(Unit.UnitLabelType.NATIONAL)).addStringTemplate("%enemyNation%", enemy));
        }
        Region region = newTile.getDiscoverableRegion();
        if (serverPlayer.isEuropean() && region != null && region.getDiscoverer() == null) {
            cs.add(ChangeSet.See.only(serverPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new NewRegionNameMessage(region, newTile, this, Messages.getDefaultRegionName(serverPlayer, region)));
            region.setDiscoverer(this.getId());
        }
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverUnit";
    }
}

