/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Effect;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.DiplomacySession;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerUnit;

public class ServerPlayer
extends Player
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerPlayer.class.getName());
    public static final int ALARM_RADIUS = 2;
    public static final int ALARM_TILE_IN_USE = 2;
    public static final int ALARM_MISSIONARY_PRESENT = -10;
    public static final int IS_DEAD = -1;
    public static final int IS_ALIVE = 0;
    public static final int AUTORECRUIT = 1;
    public static final int SCORE_SETTLEMENT_DESTROYED = -5;
    public static final int SCORE_NATION_DESTROYED = -50;
    public static final double SCORE_GOLD = 0.001;
    public static final int SCORE_FOUNDING_FATHER = 5;
    public static final int SCORE_INDEPENDENCE_BONUS_FIRST = 100;
    public static final int SCORE_INDEPENDENCE_BONUS_SECOND = 50;
    public static final int SCORE_INDEPENDENCE_BONUS_THIRD = 25;
    private Socket socket;
    private Connection connection;
    private boolean connected = false;
    private int remainingEmigrants = 0;
    private List<ServerPlayer> stanceDirty = new ArrayList<ServerPlayer>();
    private final List<AbstractGoods> extraTrades = new ArrayList<AbstractGoods>();

    public ServerPlayer(Game game, String id) {
        super(game, id);
    }

    public ServerPlayer(Game game, boolean admin, Nation nation, Socket socket, Connection connection) {
        super(game);
        if (nation == null) {
            throw new IllegalArgumentException("Null nation");
        }
        Specification spec = this.getSpecification();
        this.name = nation.getRulerName();
        this.admin = admin;
        this.nationId = nation.getId();
        this.immigration = 0;
        if (nation.isUnknownEnemy()) {
            this.nationType = null;
            this.playerType = Player.PlayerType.COLONIAL;
            this.europe = null;
            this.monarch = null;
            this.gold = 0;
            this.setAI(true);
        } else if (nation.getType() != null) {
            this.nationType = nation.getType();
            try {
                this.addFeatures(this.nationType);
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
            if (this.nationType.isEuropean()) {
                this.playerType = this.nationType.isREF() ? Player.PlayerType.ROYAL : Player.PlayerType.COLONIAL;
                this.europe = new ServerEurope(game, this);
                this.initializeHighSeas();
                if (this.playerType == Player.PlayerType.COLONIAL) {
                    this.monarch = new Monarch(game, this, nation.getRulerNameKey());
                    this.immigration = spec.getInteger("model.option.playerImmigrationBonus");
                }
                this.gold = 0;
            } else {
                this.playerType = Player.PlayerType.NATIVE;
                this.gold = Integer.MIN_VALUE;
            }
        } else {
            throw new IllegalArgumentException("Bogus nation: " + nation);
        }
        this.market = new Market(this.getGame(), this);
        this.liberty = 0;
        this.currentFather = null;
        this.socket = socket;
        this.connection = connection;
        this.connected = connection != null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.connected = connection != null;
    }

    public void updateCurrentFather(FoundingFather ff) {
        this.setCurrentFather(ff);
        this.clearOfferedFathers();
        if (ff != null) {
            logger.finest(this.getId() + " is recruiting " + ff.getId() + " in " + this.getGame().getTurn());
        }
    }

    public void addExtraTrade(AbstractGoods ag) {
        this.extraTrades.add(ag);
    }

    public void flushExtraTrades(Random random) {
        while (!this.extraTrades.isEmpty()) {
            AbstractGoods ag = this.extraTrades.remove(0);
            this.propagateToEuropeanMarkets(ag.getType(), ag.getAmount(), random);
        }
    }

    public void randomizeGame(Random random) {
        if (!this.isEuropean() || this.isREF() || this.isUnknownEnemy()) {
            return;
        }
        Specification spec = this.getGame().getSpecification();
        int i0 = spec.getInteger("model.option.initialImmigration");
        this.immigrationRequired = (int)this.applyModifiers(i0, null, "model.modifier.religiousUnrestBonus");
        this.modifyGold(spec.getInteger("model.option.startingMoney"));
        ((ServerEurope)this.getEurope()).initializeMigration(random);
        Market market = this.getMarket();
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (GoodsType type : spec.getGoodsTypeList()) {
            int add;
            String prefix = "model.option." + type.getSuffix("model.goods.");
            if (!spec.hasOption(prefix + ".minimumPrice") || !spec.hasOption(prefix + ".maximumPrice")) continue;
            int min = spec.getInteger(prefix + ".minimumPrice");
            int max = spec.getInteger(prefix + ".maximumPrice");
            if (max < min) {
                int bad = min;
                min = max;
                max = bad;
            } else if (max == min) continue;
            if ((add = RandomUtils.randomInt(null, null, random, max - min)) <= 0) continue;
            market.setInitialPrice(type, min + add);
            market.update(type);
            market.flushPriceChange(type);
            sb.append(", ").append(type.getId()).append(" -> ").append(min + add);
            changed = true;
        }
        if (changed) {
            logger.finest("randomizeGame(" + this.getId() + ") initial prices: " + sb.toString().substring(2));
        }
    }

    public int checkForDeath() {
        if (this.isUnknownEnemy()) {
            return 0;
        }
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case NATIVE: {
                return this.getUnits().isEmpty() ? -1 : 0;
            }
            case COLONIAL: {
                break;
            }
            case REBEL: 
            case INDEPENDENT: {
                return this.getNumberOfPorts() > 0 ? 0 : -1;
            }
            case ROYAL: {
                return this.getRebels().isEmpty() ? -1 : 0;
            }
            case UNDEAD: {
                return this.getUnits().isEmpty() ? -1 : 0;
            }
            default: {
                throw new IllegalStateException("Bogus player type");
            }
        }
        if (!this.getColonies().isEmpty()) {
            return 0;
        }
        if (!this.isAI() && FreeColDebugger.getDebugRunTurns() >= 0) {
            return 0;
        }
        if (this.isUnknownEnemy()) {
            return 0;
        }
        boolean hasCarrier = false;
        boolean hasColonist = false;
        boolean hasEmbarked = false;
        boolean hasGoods = false;
        for (Unit unit : this.getUnits()) {
            if (unit.isCarrier()) {
                if (unit.hasGoodsCargo()) {
                    hasGoods = true;
                }
                hasCarrier = true;
                continue;
            }
            if (!unit.isColonist() && !unit.isOffensiveUnit()) continue;
            hasColonist = true;
            Unit carrier = unit.getCarrier();
            if (carrier != null) {
                if (carrier.hasTile()) {
                    logger.info(this.getName() + " alive, unit " + unit.getId() + " (embarked) on map.");
                    return 0;
                }
                hasEmbarked = true;
            }
            if (!unit.hasTile() || unit.isInMission()) continue;
            logger.info(this.getName() + " alive, unit " + unit.getId() + " on map.");
            return 0;
        }
        int mandatory = spec.getInteger("model.option.mandatoryColonyYear");
        if (this.getGame().getTurn().getYear() >= mandatory) {
            logger.info(this.getName() + " dead, no presence >= " + mandatory);
            return -1;
        }
        if (hasEmbarked) {
            logger.info(this.getName() + " alive, has embarked unit.");
            return 0;
        }
        if (hasGoods) {
            logger.info(this.getName() + " alive, has cargo.");
            return 0;
        }
        Europe europe = this.getEurope();
        int goldNeeded = 0;
        if (!hasCarrier) {
            int price = Integer.MAX_VALUE;
            if (europe != null) {
                for (UnitType type : spec.getUnitTypesWithAbility("model.ability.navalUnit")) {
                    int p = europe.getUnitPrice(type);
                    if (p == Integer.MIN_VALUE || p >= price) continue;
                    price = p;
                }
            }
            if (price == Integer.MAX_VALUE || !this.checkGold(price)) {
                logger.info(this.getName() + " dead, can not buy carrier.");
                return -1;
            }
            goldNeeded += price;
        }
        if (hasColonist) {
            logger.info(this.getName() + " alive, has waiting colonist.");
            return 0;
        }
        if (europe == null) {
            logger.info(this.getName() + " dead, can not recruit.");
            return -1;
        }
        Object unitType = null;
        int price = europe.getRecruitPrice();
        for (UnitType type : spec.getUnitTypesWithAbility("model.ability.foundColony")) {
            int p = europe.getUnitPrice(type);
            if (p == Integer.MIN_VALUE || p >= price) continue;
            price = p;
        }
        if (this.checkGold(goldNeeded += price)) {
            logger.info(this.getName() + " alive, can buy colonist.");
            return 0;
        }
        logger.info(this.getName() + " survives by autorecruit.");
        return 1;
    }

    public boolean checkForREFDefeat() {
        if (!this.isREF()) {
            throw new IllegalStateException("Checking for REF player defeat when player not REF.");
        }
        if (this.getRebels().isEmpty()) {
            return false;
        }
        if (!this.getSettlements().isEmpty()) {
            return false;
        }
        int landREFUnitsRequired = 7;
        CombatModel cm = this.getGame().getCombatModel();
        boolean naval = false;
        int land = 0;
        int power = 0;
        for (Unit u : this.getUnits()) {
            if (u.isNaval()) {
                naval = true;
                continue;
            }
            if (!u.hasAbility("model.ability.refUnit")) continue;
            ++land;
            power = (int)((float)power + cm.getOffencePower(u, null));
        }
        if (naval && land >= 7) {
            return false;
        }
        int rebelPower = 0;
        for (Player rebel : this.getRebels()) {
            for (Unit r : rebel.getUnits()) {
                if (r.isNaval()) continue;
                rebelPower = (int)((float)rebelPower + cm.getOffencePower(r, null));
            }
        }
        return power <= rebelPower;
    }

    public void csKill(ChangeSet cs) {
        this.setDead(true);
        cs.addPartial(ChangeSet.See.all(), this, "dead");
        cs.addDead(this);
        for (Player other : this.getGame().getLivePlayers(this)) {
            if (this.isEuropean() && other.isIndian()) {
                for (IndianSettlement s : other.getIndianSettlements()) {
                    if (s.hasMissionary(this)) {
                        ((ServerIndianSettlement)s).csKillMissionary(null, cs);
                    }
                    s.getTile().cacheUnseen();
                    ((ServerIndianSettlement)s).removeAlarm(this);
                }
                other.removeTension(this);
            }
            other.setStance(this, null);
        }
        List<Settlement> settlements = this.getSettlements();
        while (!settlements.isEmpty()) {
            this.csDisposeSettlement(settlements.remove(0), cs);
        }
        for (Tile tile : this.getGame().getMap().getAllTiles()) {
            if (tile.getOwner() != this) continue;
            tile.cacheUnseen();
            tile.changeOwnership(null, null);
            cs.add(ChangeSet.See.perhaps().always(this), tile);
        }
        List<Unit> units = this.getUnits();
        while (!units.isEmpty()) {
            Unit u = units.remove(0);
            if (u.hasTile()) {
                cs.add(ChangeSet.See.perhaps(), u.getTile());
            }
            cs.addDispose(ChangeSet.See.perhaps().always(this), u.getLocation(), u);
        }
        if (this.market != null) {
            this.market.dispose();
            this.market = null;
        }
        if (this.monarch != null) {
            this.monarch.dispose();
            this.monarch = null;
        }
        if (this.europe != null) {
            this.europe.dispose();
            this.europe = null;
        }
        this.currentFather = null;
        if (this.foundingFathers != null) {
            this.foundingFathers.clear();
        }
        if (this.offeredFathers != null) {
            this.offeredFathers.clear();
        }
        if (this.tradeRoutes != null) {
            this.tradeRoutes.clear();
        }
        if (this.lastSales != null) {
            this.lastSales = null;
        }
        this.featureContainer.clear();
        this.invalidateCanSeeTiles();
    }

    public void csWithdraw(ChangeSet cs) {
        cs.addMessage(ChangeSet.See.all(), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, this.isEuropean() && this.getPlayerType() == Player.PlayerType.COLONIAL ? "model.diplomacy.dead.european" : "model.diplomacy.dead.native", this).addStringTemplate("%nation%", this.getNationName()));
        Game game = this.getGame();
        cs.addGlobalHistory(game, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.NATION_DESTROYED, null).addStringTemplate("%nation%", this.getNationName()));
        this.csKill(cs);
    }

    public int getRemainingEmigrants() {
        return this.remainingEmigrants;
    }

    public void setRemainingEmigrants(int emigrants) {
        this.remainingEmigrants = emigrants;
    }

    public FoundingFather checkFoundingFather() {
        int extraLiberty;
        FoundingFather father = null;
        if (this.currentFather != null && (extraLiberty = this.getRemainingFoundingFatherCost()) <= 0) {
            boolean overflow = this.getSpecification().getBoolean("model.option.saveProductionOverflow");
            this.setLiberty(overflow ? -extraLiberty : 0);
            father = this.currentFather;
            this.currentFather = null;
        }
        return father;
    }

    public boolean canRecruitFoundingFather() {
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case COLONIAL: {
                break;
            }
            case REBEL: 
            case INDEPENDENT: {
                if (spec.getBoolean("model.option.continueFoundingFatherRecruitment")) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return this.canHaveFoundingFathers() && this.currentFather == null && !this.getSettlements().isEmpty() && this.getFatherCount() < spec.getFoundingFathers().size();
    }

    public List<FoundingFather> getRandomFoundingFathers(Random random) {
        Specification spec = this.getGame().getSpecification();
        int age = this.getGame().getTurn().getAge();
        EnumMap choices = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather father : spec.getFoundingFathers()) {
            if (this.hasFather(father) || !father.isAvailableTo(this)) continue;
            FoundingFather.FoundingFatherType type = father.getType();
            ArrayList<RandomChoice<FoundingFather>> rc = (ArrayList<RandomChoice<FoundingFather>>)choices.get((Object)type);
            if (rc == null) {
                rc = new ArrayList<RandomChoice<FoundingFather>>();
            }
            int weight = father.getWeight(age);
            rc.add(new RandomChoice<FoundingFather>(father, weight));
            choices.put(father.getType(), rc);
        }
        ArrayList<FoundingFather> randomFathers = new ArrayList<FoundingFather>();
        String logMessage = "Random fathers";
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            FoundingFather f;
            List rc = (List)choices.get((Object)type);
            if (rc == null || (f = (FoundingFather)RandomChoice.getWeightedRandom(logger, "Choose founding father", rc, random)) == null) continue;
            randomFathers.add(f);
            logMessage = logMessage + ":" + f.getNameKey();
        }
        logger.info(logMessage);
        return randomFathers;
    }

    @Override
    public void addHistory(HistoryEvent event) {
        this.history.add(event);
    }

    public boolean updateScore() {
        int oldScore = this.score;
        this.score = 0;
        for (Unit u : this.getUnits()) {
            this.score += u.getType().getScoreValue();
        }
        for (Colony c : this.getColonies()) {
            this.score += c.getLiberty();
        }
        this.score += 5 * this.getFathers().size();
        int gold = this.getGold();
        if (gold != Integer.MIN_VALUE) {
            this.score += (int)Math.floor(0.001 * (double)gold);
        }
        int bonus = 0;
        block10: for (HistoryEvent h : this.getHistory()) {
            if (!this.getId().equals(h.getPlayerId())) continue;
            switch (h.getEventType()) {
                case INDEPENDENCE: {
                    switch (h.getScore()) {
                        case 0: {
                            bonus = 100;
                            continue block10;
                        }
                        case 1: {
                            bonus = 50;
                            continue block10;
                        }
                        case 2: {
                            bonus = 25;
                            continue block10;
                        }
                    }
                    bonus = 0;
                    continue block10;
                }
            }
            this.score += h.getScore();
        }
        this.score += this.score * bonus / 100;
        return this.score != oldScore;
    }

    @Override
    public boolean hasExplored(Tile tile) {
        return tile.isExploredBy(this);
    }

    public boolean exploreTile(Tile tile) {
        boolean ret;
        boolean bl = ret = !this.hasExplored(tile);
        if (ret) {
            tile.setExplored(this, true);
        }
        return ret;
    }

    public Set<Tile> exploreTiles(Collection<? extends Tile> tiles) {
        HashSet<Tile> result = new HashSet<Tile>();
        for (Tile tile : tiles) {
            if (!this.exploreTile(tile)) continue;
            result.add(tile);
        }
        return result;
    }

    public Set<Tile> exploreForSettlement(Settlement settlement) {
        HashSet<Tile> tiles = new HashSet<Tile>(settlement.getOwnedTiles());
        tiles.addAll(settlement.getTile().getSurroundingTiles(1, settlement.getLineOfSight()));
        return this.exploreTiles(tiles);
    }

    public Set<Tile> exploreForUnit(Unit unit) {
        return this.getGame() == null || this.getGame().getMap() == null || unit == null || !(unit.getLocation() instanceof Tile) ? Collections.emptySet() : this.exploreTiles(unit.getTile().getSurroundingTiles(0, unit.getLineOfSight()));
    }

    public Set<Tile> exploreMap(boolean reveal) {
        HashSet<Tile> result = new HashSet<Tile>();
        for (Tile tile : this.getGame().getMap().getAllTiles()) {
            if (this.hasExplored(tile) == reveal) continue;
            tile.setExplored(this, reveal);
            result.add(tile);
        }
        this.invalidateCanSeeTiles();
        if (!reveal) {
            for (Settlement s : this.getSettlements()) {
                this.exploreForSettlement(s);
            }
            for (Unit u : this.getUnits()) {
                this.exploreForUnit(u);
            }
        }
        return result;
    }

    public List<Unit> createUnits(List<AbstractUnit> abstractUnits, Location location) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (location == null) {
            return units;
        }
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        for (AbstractUnit au : abstractUnits) {
            Role role;
            UnitType type;
            block6: {
                block5: {
                    block7: {
                        type = au.getType(spec);
                        role = au.getRole(spec);
                        if (!this.isREF()) break block5;
                        if (role.isAvailableTo(this, type)) break block6;
                        if (!"model.role.soldier".equals(role.getId())) break block7;
                        role = spec.getRole("model.role.infantry");
                        break block6;
                    }
                    if (!"model.role.dragoon".equals(role.getId())) break block6;
                    role = spec.getRole("model.role.cavalry");
                    break block6;
                }
                if (!type.isAvailableTo(this)) {
                    logger.warning("Ignoring abstract unit " + au + " unavailable to: " + this.getId());
                    continue;
                }
                if (!role.isAvailableTo(this, type)) {
                    logger.warning("Ignoring abstract unit " + au + " with role " + role + " unavailable to: " + this.getId());
                    continue;
                }
            }
            for (int i = 0; i < au.getNumber(); ++i) {
                ServerUnit su = new ServerUnit(game, location, this, type, role);
                units.add(su);
            }
        }
        return units;
    }

    public List<Unit> loadShips(List<Unit> landUnits, List<Unit> navalUnits, Random random) {
        ArrayList<Unit> leftOver = new ArrayList<Unit>();
        RandomUtils.randomShuffle(logger, "Naval load", navalUnits, random);
        RandomUtils.randomShuffle(logger, "Land load", landUnits, random);
        LogBuilder lb = new LogBuilder(256);
        lb.mark();
        block0: for (Unit unit : landUnits) {
            for (Unit carrier : navalUnits) {
                if (!carrier.canAdd(unit)) continue;
                unit.setLocation(carrier);
                lb.add(unit, " -> ", carrier, ", ");
                continue block0;
            }
            leftOver.add(unit);
        }
        if (lb.grew("Load ships: ")) {
            lb.shrink(", ");
            lb.log(logger, Level.FINEST);
        }
        return leftOver;
    }

    public int priceMercenaries(List<AbstractUnit> mercenaries) {
        int mercPrice = 0;
        for (AbstractUnit au : mercenaries) {
            mercPrice += this.getPrice(au);
        }
        if (!this.checkGold(mercPrice)) {
            mercPrice = this.getGold();
        }
        return mercPrice;
    }

    public boolean csFlushMarket(ChangeSet cs) {
        Market market = this.getMarket();
        if (market == null) {
            return false;
        }
        boolean ret = false;
        StringBuilder sb = new StringBuilder(32);
        sb.append("Flush market for ").append(this.getId()).append(":");
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            if (!this.csFlushMarket(type, cs)) continue;
            sb.append(" ").append(type.getId());
            ret = true;
        }
        if (ret) {
            logger.finest(sb.toString());
        }
        return ret;
    }

    public boolean csFlushMarket(GoodsType type, ChangeSet cs) {
        Market market = this.getMarket();
        boolean ret = market.hasPriceChanged(type);
        if (ret) {
            cs.addMessage(ChangeSet.See.only(this), market.makePriceChangeMessage(type));
            market.flushPriceChange(type);
            cs.add(ChangeSet.See.only(this), market.getMarketData(type));
        }
        return ret;
    }

    public int buy(GoodsContainer container, GoodsType type, int amount) {
        Market market = this.getMarket();
        int price = market.getBidPrice(type, amount);
        if (!this.checkGold(price)) {
            return -1;
        }
        logger.finest(this.getName() + " buys " + amount + " " + type + " for " + price);
        this.modifyGold(-price);
        market.modifySales(type, -amount);
        if (container != null) {
            container.addGoods(type, amount);
        }
        market.modifyIncomeBeforeTaxes(type, -price);
        market.modifyIncomeAfterTaxes(type, -price);
        int marketAmount = (int)this.applyModifiers(amount, this.getGame().getTurn(), "model.modifier.tradeBonus", type);
        market.addGoodsToMarket(type, -marketAmount);
        return marketAmount;
    }

    public int sell(GoodsContainer container, GoodsType type, int amount) {
        Market market = this.getMarket();
        int price = market.getSalePrice(type, amount);
        logger.finest(this.getName() + " sells " + amount + " " + type + " for " + price);
        int tax = this.getTax();
        int incomeBeforeTaxes = price;
        int incomeAfterTaxes = (100 - tax) * incomeBeforeTaxes / 100;
        this.modifyGold(incomeAfterTaxes);
        market.modifySales(type, amount);
        if (container != null) {
            container.addGoods(type, -amount);
        }
        market.modifyIncomeBeforeTaxes(type, incomeBeforeTaxes);
        market.modifyIncomeAfterTaxes(type, incomeAfterTaxes);
        int marketAmount = (int)this.applyModifiers(amount, this.getGame().getTurn(), "model.modifier.tradeBonus", type);
        market.addGoodsToMarket(type, marketAmount);
        return marketAmount;
    }

    public void addStanceChange(ServerPlayer other) {
        if (!this.stanceDirty.contains(other)) {
            this.stanceDirty.add(other);
        }
    }

    public boolean csChangeStance(Player.Stance stance, ServerPlayer otherPlayer, boolean symmetric, ChangeSet cs) {
        int modifier;
        ServerPlayer other = otherPlayer;
        boolean change = false;
        Player.Stance old = this.getStance(otherPlayer);
        if (old != stance) {
            modifier = old.getTensionModifier(stance);
            this.setStance(otherPlayer, stance);
            if (modifier != 0) {
                this.csModifyTension(otherPlayer, modifier, cs);
            }
            cs.addHistory(this, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.getEventTypeFromStance(stance), otherPlayer).addStringTemplate("%nation%", otherPlayer.getNationName()));
            logger.info("Stance modification " + this.getName() + " " + (Object)((Object)old) + " -> " + (Object)((Object)stance) + " wrt " + otherPlayer.getName());
            this.addStanceChange(other);
            if (old != Player.Stance.UNCONTACTED) {
                cs.addMessage(ChangeSet.See.only(other), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)stance) + ".declared", this).addStringTemplate("%nation%", this.getNationName()));
            }
            cs.addStance(ChangeSet.See.only(this), this, stance, otherPlayer);
            cs.addStance(ChangeSet.See.only(other), this, stance, otherPlayer);
            change = true;
        }
        if (symmetric && (old = otherPlayer.getStance(this)) != stance) {
            modifier = old.getTensionModifier(stance);
            otherPlayer.setStance(this, stance);
            if (modifier != 0) {
                other.csModifyTension(this, modifier, cs);
            }
            cs.addHistory(otherPlayer, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.getEventTypeFromStance(stance), this).addStringTemplate("%nation%", this.getNationName()));
            logger.info("Stance modification " + otherPlayer.getName() + " " + (Object)((Object)old) + " -> " + (Object)((Object)stance) + " wrt " + this.getName() + " (symmetric)");
            other.addStanceChange(this);
            if (old != Player.Stance.UNCONTACTED) {
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)stance) + ".declared", otherPlayer).addStringTemplate("%nation%", otherPlayer.getNationName()));
            }
            cs.addStance(ChangeSet.See.only(this), otherPlayer, stance, this);
            cs.addStance(ChangeSet.See.only(other), otherPlayer, stance, this);
            change = true;
        }
        return change;
    }

    public void csModifyTension(Player player, int add, ChangeSet cs) {
        this.csModifyTension(player, add, null, cs);
    }

    public void csModifyTension(Player player, int add, Settlement origin, ChangeSet cs) {
        Tension.Level oldLevel = this.getTension(player).getLevel();
        this.getTension(player).modify(add);
        if (oldLevel != this.getTension(player).getLevel()) {
            cs.add(ChangeSet.See.only((ServerPlayer)player), this);
        }
        if (this.isIndian()) {
            for (IndianSettlement is : this.getIndianSettlements()) {
                if (is == origin || !is.hasContacted(player)) continue;
                ((ServerIndianSettlement)is).csModifyAlarm(player, add, false, cs);
            }
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("PLAYER ", this.getName(), ": ");
        ArrayList<Settlement> settlements = new ArrayList<Settlement>(this.getSettlements());
        int newSoL = 0;
        int newImmigration = this.getImmigration();
        for (Settlement settlement : settlements) {
            ((ServerModelObject)((Object)settlement)).csNewTurn(random, lb, cs);
            newSoL += settlement.getSoL();
        }
        newImmigration = this.getImmigration() - newImmigration;
        int numberOfColonies = settlements.size();
        if (numberOfColonies > 0) {
            if (this.oldSoL / 10 != (newSoL /= numberOfColonies) / 10) {
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, newSoL > this.oldSoL ? "model.player.SoLIncrease" : "model.player.SoLDecrease", this).addAmount("%oldSoL%", this.oldSoL).addAmount("%newSoL%", newSoL));
            }
            this.oldSoL = newSoL;
        }
        if (this.europe != null) {
            ((ServerModelObject)((Object)this.europe)).csNewTurn(random, lb, cs);
            this.modifyImmigration(this.europe.getImmigration(newImmigration));
        }
        for (Unit unit : new ArrayList<Unit>(this.getUnits())) {
            try {
                ((ServerModelObject)((Object)unit)).csNewTurn(random, lb, cs);
            }
            catch (ClassCastException e) {
                logger.log(Level.SEVERE, "Not a ServerUnit: " + unit.getId(), e);
            }
        }
        if (this.isEuropean()) {
            int probability;
            if (this.checkEmigrate() && !this.hasAbility("model.ability.selectRecruit")) {
                this.csEmigrate(Europe.MigrationType.getUnspecificSlot(), Europe.MigrationType.NORMAL, random, cs);
            } else {
                cs.addPartial(ChangeSet.See.only(this), this, "immigration");
            }
            cs.addPartial(ChangeSet.See.only(this), this, "liberty");
            if (this.getSpecification().getBoolean("model.option.enableUpkeep")) {
                this.csPayUpkeep(random, cs);
            }
            if ((probability = this.getSpecification().getInteger("model.option.naturalDisasters")) > 0) {
                this.csNaturalDisasters(random, cs, probability);
            }
            if (this.isRebel() && this.interventionBells >= this.getSpecification().getInteger("model.option.interventionBells")) {
                this.interventionBells = Integer.MIN_VALUE;
                ArrayList<Colony> ports = new ArrayList<Colony>();
                for (Colony c : this.getColonies()) {
                    if (!c.isConnectedPort()) continue;
                    ports.add(c);
                }
                Colony port = (Colony)RandomUtils.getRandomMember(logger, "Intervention port", ports, random);
                Tile portTile = port.getTile();
                Tile entry = this.getGame().getMap().searchCircle(portTile, GoalDeciders.getSimpleHighSeasGoalDecider(), portTile.getHighSeasCount() + 1).getSafeTile(this, random);
                Monarch.Force ivf = null;
                if (this.getMonarch() != null && (ivf = this.getMonarch().getInterventionForce()) != null) {
                    List<Unit> landUnits = this.createUnits(ivf.getLandUnits(), entry);
                    List<Unit> navalUnits = this.createUnits(ivf.getNavalUnits(), entry);
                    List<Unit> leftOver = this.loadShips(landUnits, navalUnits, random);
                    for (Unit unit : leftOver) {
                        logger.warning("Disposing of left over unit " + unit);
                        unit.setLocationNoUpdate(null);
                        unit.disposeList();
                    }
                    Set<Tile> tiles = this.exploreForUnit(navalUnits.get(0));
                    if (!tiles.contains(entry)) {
                        tiles.add(entry);
                    }
                    this.invalidateCanSeeTiles();
                    cs.add(ChangeSet.See.perhaps(), tiles);
                    cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.DEFAULT, "declareIndependence.interventionForceArrives", this));
                    logger.info("Intervention force (" + navalUnits.size() + " naval, " + landUnits.size() + " land, " + leftOver.size() + " left over) arrives at " + entry + "(for " + port.getName() + ")");
                }
            }
        }
        while (!this.stanceDirty.isEmpty()) {
            boolean war;
            ServerPlayer s = this.stanceDirty.remove(0);
            Player.Stance sta = this.getStance(s);
            boolean bl = war = sta == Player.Stance.WAR;
            if (sta == Player.Stance.UNCONTACTED) continue;
            for (Player p : this.getGame().getLiveEuropeanPlayers(this)) {
                ServerPlayer sp = (ServerPlayer)p;
                if (p == s || !p.hasContacted(this) || !p.hasContacted(s) || !p.hasAbility("model.ability.betterForeignAffairsReport") && !war) continue;
                cs.addStance(ChangeSet.See.only(sp), this, sta, s);
                cs.addMessage(ChangeSet.See.only(sp), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)sta) + ".others", this).addStringTemplate("%attacker%", this.getNationName()).addStringTemplate("%defender%", s.getNationName()));
            }
        }
    }

    public void csPayUpkeep(Random random, ChangeSet cs) {
        Specification spec = this.getSpecification();
        Disaster bankruptcy = spec.getDisaster("model.disaster.bankruptcy");
        boolean changed = false;
        int upkeep = 0;
        for (Settlement settlement : this.getSettlements()) {
            upkeep += settlement.getUpkeep();
        }
        if (this.checkGold(upkeep)) {
            this.modifyGold(-upkeep);
            if (this.getBankrupt()) {
                this.setBankrupt(false);
                changed = true;
                for (RandomChoice randomChoice : bankruptcy.getEffects()) {
                    for (Modifier modifier : ((Effect)randomChoice.getObject()).getModifiers()) {
                        cs.addFeatureChange(this, (FreeColGameObject)this, modifier, false);
                    }
                }
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.disaster.bankruptcy.stop", this));
            }
        } else {
            this.modifyGold(-this.getGold());
            if (!this.getBankrupt()) {
                this.setBankrupt(true);
                changed = true;
                this.csApplyDisaster(random, null, bankruptcy, cs);
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.disaster.bankruptcy.start", this));
            }
        }
        if (upkeep > 0) {
            cs.addPartial(ChangeSet.See.only(this), this, "gold");
        }
        if (changed) {
            cs.addPartial(ChangeSet.See.only(this), this, "bankrupt");
        }
    }

    public void csNaturalDisasters(Random random, ChangeSet cs, int probability) {
        if (RandomUtils.randomInt(logger, "Natural disaster", random, 100) < probability) {
            int size = this.getNumberOfSettlements();
            if (size < 1) {
                return;
            }
            int start = RandomUtils.randomInt(logger, "select colony", random, size);
            for (int index = 0; index < size; ++index) {
                Disaster disaster;
                List<ModelMessage> messages;
                Colony colony = this.getColonies().get((start + index) % size);
                List disasters = colony.getDisasters();
                if (disasters.isEmpty() || (messages = this.csApplyDisaster(random, colony, disaster = (Disaster)RandomChoice.getWeightedRandom(logger, "select disaster", disasters, random), cs)).isEmpty()) continue;
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.strikes", colony).addName("%colony%", colony.getName()).addName("%disaster%", disaster));
                for (ModelMessage message : messages) {
                    cs.addMessage(ChangeSet.See.only(this), message);
                }
                return;
            }
        }
    }

    public List<ModelMessage> csApplyDisaster(Random random, Colony colony, Disaster disaster, ChangeSet cs) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Applying ").append((Object)disaster.getNumberOfEffects()).append(" effect/s of disaster ").append(Messages.getName(disaster));
        if (colony != null) {
            sb.append(" to ").append(colony.getName());
        }
        sb.append(":");
        ArrayList<Object> effects = new ArrayList<Object>();
        switch (disaster.getNumberOfEffects()) {
            case ONE: {
                effects.add(RandomChoice.getWeightedRandom(logger, "Get effect of disaster", disaster.getEffects(), random));
                sb.append(" ").append(Messages.getName((Named)effects.get(0)));
                break;
            }
            case SEVERAL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    if (RandomUtils.randomInt(logger, "Get effects of disaster", random, 100) >= effect.getProbability()) continue;
                    effects.add(effect.getObject());
                    sb.append(" ").append(Messages.getName(effect.getObject()));
                }
                break;
            }
            case ALL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    effects.add(effect.getObject());
                    sb.append(" ").append(Messages.getName(effect.getObject()));
                }
                break;
            }
        }
        if (effects.isEmpty()) {
            sb.append(" All avoided");
        }
        logger.fine(sb.toString());
        boolean colonyDirty = false;
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (Effect effect : effects) {
            Unit unit;
            Modifier timedModifier;
            if (colony == null) {
                for (Modifier modifier : effect.getModifiers()) {
                    if (modifier.getDuration() > 0) {
                        timedModifier = Modifier.makeTimedModifier(modifier.getId(), modifier, this.getGame().getTurn());
                        modifier.setModifierIndex(100);
                        cs.addFeatureChange(this, (FreeColGameObject)this, timedModifier, true);
                        continue;
                    }
                    cs.addFeatureChange(this, (FreeColGameObject)this, modifier, true);
                }
                continue;
            }
            if ("model.disaster.effect.lossOfMoney".equals(effect.getId())) {
                int plunder = Math.max(1, colony.getPlunder(null, random) / 5);
                this.modifyGold(-plunder);
                cs.addPartial(ChangeSet.See.only(this), this, "gold");
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this).addAmount("%amount%", plunder));
                continue;
            }
            if ("model.disaster.effect.lossOfBuilding".equals(effect.getId())) {
                Building building = this.getBuildingForEffect(colony, effect, random);
                if (building == null) continue;
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), colony).add("%building%", building.getType().getNameKey()));
                this.csDamageBuilding(building, cs);
                colonyDirty = true;
                continue;
            }
            if ("model.disaster.effect.lossOfGoods".equals(effect.getId())) {
                Goods goods = RandomUtils.getRandomMember(logger, "select goods", colony.getLootableGoodsList(), random);
                if (goods == null) continue;
                goods.setAmount(Math.min(goods.getAmount() / 2, 50));
                colony.removeGoods(goods);
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), colony).addStringTemplate("%goods%", goods.getLabel(true)));
                colonyDirty = true;
                continue;
            }
            if ("model.disaster.effect.lossOfUnit".equals(effect.getId())) {
                unit = this.getUnitForEffect(colony, effect, random);
                if (unit == null) continue;
                if (colony.getUnitCount() == 1) {
                    messages.clear();
                    messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.effect.colonyDestroyed", this).addName("%colony%", colony.getName()));
                    this.csDisposeSettlement(colony, cs);
                    colonyDirty = false;
                    break;
                }
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), colony).addStringTemplate("%unit%", unit.getLabel()));
                cs.addDispose(ChangeSet.See.only(this), null, unit);
                colonyDirty = true;
                continue;
            }
            if ("model.disaster.effect.damagedUnit".equals(effect.getId())) {
                unit = this.getUnitForEffect(colony, effect, random);
                if (unit == null || !unit.isNaval()) continue;
                Location repairLocation = unit.getRepairLocation();
                if (repairLocation == null) {
                    messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.effect.lossOfUnit", colony).addStringTemplate("%unit%", unit.getLabel()));
                    this.csSinkShip(unit, null, cs);
                } else {
                    messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), colony).addStringTemplate("%unit%", unit.getLabel()));
                    this.csDamageShip(unit, repairLocation, cs);
                }
                colonyDirty = true;
                continue;
            }
            messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), colony));
            for (Modifier modifier : effect.getModifiers()) {
                if (modifier.getDuration() > 0) {
                    timedModifier = Modifier.makeTimedModifier(modifier.getId(), modifier, this.getGame().getTurn());
                    timedModifier.setModifierIndex(100);
                    cs.addFeatureChange(this, (FreeColGameObject)colony, timedModifier, true);
                } else {
                    cs.addFeatureChange(this, (FreeColGameObject)colony, modifier, true);
                }
                colonyDirty = true;
            }
        }
        if (colonyDirty) {
            cs.add(ChangeSet.See.perhaps(), colony);
        }
        return messages;
    }

    public Building getBuildingForEffect(Colony colony, Effect effect, Random random) {
        List<Building> buildings = colony.getBurnableBuildings();
        if (buildings.isEmpty()) {
            return null;
        }
        return RandomUtils.getRandomMember(logger, "Select building for effect", buildings, random);
    }

    public Unit getUnitForEffect(Colony colony, Effect effect, Random random) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit unit : colony.getUnitList()) {
            if (!effect.appliesTo(unit.getType())) continue;
            units.add(unit);
        }
        for (Unit unit : colony.getTile().getUnitList()) {
            if (!effect.appliesTo(unit.getType())) continue;
            units.add(unit);
        }
        if (units.isEmpty()) {
            return null;
        }
        return (Unit)RandomUtils.getRandomMember(logger, "Select unit for effect", units, random);
    }

    public void propagateToEuropeanMarkets(GoodsType type, int amount, Random random) {
        if (!type.isStorable()) {
            return;
        }
        int lowerBound = 5;
        int upperBound = 30;
        amount *= RandomUtils.randomInt(logger, "Propagate goods", random, 26) + 5;
        if ((amount /= 100) == 0) {
            return;
        }
        for (Player p : this.getGame().getLiveEuropeanPlayers(this)) {
            Market market = p.getMarket();
            if (market == null) continue;
            market.addGoodsToMarket(type, amount);
        }
    }

    public void csYearlyGoodsAdjust(Random random, ChangeSet cs) {
        GoodsType extraType;
        Game game = this.getGame();
        List<GoodsType> goodsTypes = game.getSpecification().getGoodsTypeList();
        Market market = this.getMarket();
        while (!(extraType = RandomUtils.getRandomMember(logger, "Choose goods type", goodsTypes, random)).isStorable()) {
        }
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable() || !market.hasBeenTraded(type)) continue;
            boolean add = market.getAmountInMarket(type) < type.getInitialAmount();
            int amount = game.getTurn().getNumber() / 10;
            if (type == extraType) {
                amount = 2 * amount + 1;
            }
            if (amount <= 0) continue;
            amount = RandomUtils.randomInt(logger, "Market adjust " + type, random, amount);
            if (!add) {
                amount = -amount;
            }
            market.addGoodsToMarket(type, amount);
            logger.finest(this.getName() + " adjust of " + amount + " " + type + ", total: " + market.getAmountInMarket(type) + ", initial: " + type.getInitialAmount());
            this.addExtraTrade(new AbstractGoods(type, amount));
        }
        this.flushExtraTrades(random);
        this.csFlushMarket(cs);
    }

    public void csStartTurn(Random random, ChangeSet cs) {
        Game game = this.getGame();
        if (this.isEuropean()) {
            this.csBombardEnemyShips(random, cs);
            this.csYearlyGoodsAdjust(random, cs);
            FoundingFather father = this.checkFoundingFather();
            if (father != null) {
                this.csAddFoundingFather(father, random, cs);
                this.clearOfferedFathers();
            }
            List<FoundingFather> ffs = this.getOfferedFathers();
            if (this.canRecruitFoundingFather() && ffs.isEmpty()) {
                ffs = this.getRandomFoundingFathers(random);
                this.setOfferedFathers(ffs);
            }
            if (!ffs.isEmpty()) {
                cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_EARLY, new ChooseFoundingFatherMessage(ffs, null));
            }
            if (this.updateScore()) {
                cs.addPartial(ChangeSet.See.only(this), this, "score");
            }
        } else if (this.isIndian()) {
            List<IndianSettlement> allSettlements = this.getIndianSettlements();
            HashMap oldLevels = new HashMap();
            for (IndianSettlement settlement : allSettlements) {
                HashMap<Player, Tension.Level> oldLevel = new HashMap<Player, Tension.Level>();
                oldLevels.put(settlement, oldLevel);
                Iterator<Player> i$ = game.getLiveEuropeanPlayers(this).iterator();
                while (i$.hasNext()) {
                    Player enemy;
                    Tension tension = settlement.getAlarm(enemy = i$.next());
                    oldLevel.put(enemy, tension == null ? null : tension.getLevel());
                }
            }
            for (IndianSettlement settlement : allSettlements) {
                HashMap<Player, Integer> extra = new HashMap<Player, Integer>();
                for (Player enemy : game.getLiveEuropeanPlayers(this)) {
                    extra.put(enemy, 0);
                }
                int alarmRadius = settlement.getRadius() + 2;
                for (Tile tile : settlement.getTile().getSurroundingTiles(alarmRadius)) {
                    Player enemy;
                    Colony colony = tile.getColony();
                    if (tile.getFirstUnit() != null) {
                        Integer alarm;
                        enemy = tile.getFirstUnit().getOwner();
                        if (!enemy.isEuropean() || (alarm = (Integer)extra.get(enemy)) == null) continue;
                        for (Unit unit : tile.getUnitList()) {
                            if (!unit.isOffensiveUnit() || unit.isNaval()) continue;
                            alarm = alarm + (int)unit.getType().getOffence();
                        }
                        extra.put(enemy, alarm);
                        continue;
                    }
                    if (colony != null) {
                        enemy = colony.getOwner();
                        extra.put(enemy, (Integer)extra.get(enemy) + 2 + colony.getUnitCount());
                        continue;
                    }
                    if (tile.getOwningSettlement() == null || (enemy = tile.getOwningSettlement().getOwner()) == null || !enemy.isEuropean()) continue;
                    extra.put(enemy, (Integer)extra.get(enemy) + 2);
                }
                if (settlement.hasMissionary()) {
                    int n;
                    Unit missionary = settlement.getMissionary();
                    int n2 = -10;
                    if (missionary.hasAbility("model.ability.expertMissionary")) {
                        n = n2 * 2;
                    }
                    Player enemy = missionary.getOwner();
                    extra.put(enemy, (Integer)extra.get(enemy) + n);
                }
                for (Map.Entry entry : extra.entrySet()) {
                    Player player = (Player)entry.getKey();
                    int change = (Integer)entry.getValue();
                    if (change == 0) continue;
                    change = (int)player.applyModifiers(change, game.getTurn(), "model.modifier.nativeAlarmModifier");
                    ServerIndianSettlement sis = (ServerIndianSettlement)settlement;
                    sis.csModifyAlarm((ServerPlayer)player, change, true, cs);
                }
            }
            for (Player enemy : game.getLiveEuropeanPlayers(this)) {
                if (this.getTension(enemy).getValue() <= 0) continue;
                int change = -this.getTension(enemy).getValue() / 100 - 4;
                this.csModifyTension(enemy, change, cs);
            }
            for (IndianSettlement settlement : allSettlements) {
                Map oldLevel = (Map)oldLevels.get(settlement);
                for (Map.Entry entry : oldLevel.entrySet()) {
                    String key;
                    Tension.Level newLevel;
                    Player player = (Player)entry.getKey();
                    Tension newTension = settlement.getAlarm(player);
                    Tension.Level level = newLevel = newTension == null ? null : newTension.getLevel();
                    if (entry.getValue() == null || entry.getValue() == newLevel || !settlement.hasContacted(player) || !player.hasExplored(settlement.getTile())) continue;
                    cs.add(ChangeSet.See.only(null).perhaps((ServerPlayer)player), settlement);
                    if (newLevel == null || entry.getValue() != null && ((Tension.Level)((Object)entry.getValue())).getLimit() > newLevel.getLimit() || !Messages.containsKey(key = "indianSettlement.alarmIncrease." + settlement.getAlarm(player).getKey())) continue;
                    cs.addMessage(ChangeSet.See.only((ServerPlayer)player), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, key, settlement).addStringTemplate("%nation%", this.getNationName()).addStringTemplate("%enemy%", player.getNationName()).addName("%settlement%", settlement.getName()));
                }
            }
            for (IndianSettlement settlement : allSettlements) {
                ((ServerIndianSettlement)settlement).csStartTurn(random, cs);
            }
        }
    }

    private void csBombardEnemyShips(Random random, ChangeSet cs) {
        for (Colony colony : this.getColonies()) {
            if (!colony.canBombardEnemyShip()) continue;
            for (Tile tile : colony.getTile().getSurroundingTiles(1)) {
                if (tile.isLand() || tile.getFirstUnit() == null || tile.getFirstUnit().getOwner() == this) continue;
                for (Unit unit : tile.getUnitList()) {
                    if (!this.atWarWith(unit.getOwner()) && !unit.hasAbility("model.ability.piracy")) continue;
                    this.csCombat(colony, unit, null, random, cs);
                }
            }
        }
    }

    public void csAddFoundingFather(FoundingFather father, Random random, ChangeSet cs) {
        Map<UnitType, UnitType> upgrades;
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        ServerEurope europe = (ServerEurope)this.getEurope();
        boolean europeDirty = false;
        boolean visibilityChange = false;
        cs.addFather(this, father);
        cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, "model.player.foundingFatherJoinedCongress", this).add("%foundingFather%", father.getNameKey()).add("%description%", father.getDescriptionKey()));
        cs.addHistory(this, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.FOUNDING_FATHER, this).add("%father%", father.getNameKey()));
        List<AbstractUnit> units = father.getUnits();
        if (units != null && !units.isEmpty() && europe != null) {
            this.createUnits(father.getUnits(), europe);
            europeDirty = true;
        }
        if ((upgrades = father.getUpgrades()) != null) {
            for (Unit u : this.getUnits()) {
                UnitType newType = upgrades.get(u.getType());
                if (newType == null) continue;
                u.changeType(newType);
                visibilityChange = true;
                cs.add(ChangeSet.See.perhaps(), u);
            }
        }
        if (!father.getModifiers().isEmpty()) {
            cs.add(ChangeSet.See.only(this), this);
            if (father.hasModifier("model.modifier.lineOfSightBonus")) {
                ArrayList<Tile> tiles = new ArrayList<Tile>();
                for (Colony c : this.getColonies()) {
                    tiles.addAll(this.exploreForSettlement(c));
                }
                for (Unit u : this.getUnits()) {
                    tiles.addAll(this.exploreForUnit(u));
                }
                if (this.hasAbility("model.ability.seeAllColonies")) {
                    for (Player other : this.getGame().getLiveEuropeanPlayers(this)) {
                        for (Colony c : other.getColonies()) {
                            tiles.addAll(this.exploreForSettlement(c));
                        }
                    }
                }
                cs.add(ChangeSet.See.only(this), tiles);
                visibilityChange = true;
            } else if (father.hasModifier("model.modifier.SoL")) {
                for (Colony c : this.getColonies()) {
                    c.addLiberty(0);
                    c.invalidateCache();
                }
            } else {
                boolean recache = false;
                for (Modifier m : father.getModifiers()) {
                    recache |= m.getId().startsWith("model.goods.");
                }
                for (Colony c : this.getColonies()) {
                    c.invalidateCache();
                }
            }
        }
        for (Event event : father.getEvents()) {
            String eventId = event.getId();
            if ("model.event.resetBannedMissions".equals(eventId)) {
                for (Player p : game.getLiveNativePlayers(null)) {
                    if (!p.missionsBanned(this)) continue;
                    p.removeMissionBan(this);
                    cs.add(ChangeSet.See.only(this), p);
                }
                continue;
            }
            if ("model.event.resetNativeAlarm".equals(eventId)) {
                for (Player p : game.getLiveNativePlayers(null)) {
                    if (!p.hasContacted(this)) continue;
                    p.setTension(this, new Tension(0));
                    for (IndianSettlement is : p.getIndianSettlements()) {
                        if (!is.hasContacted(this)) continue;
                        is.getTile().cacheUnseen();
                        is.setAlarm(this, new Tension(0));
                        cs.add(ChangeSet.See.only(this), is);
                    }
                    this.csChangeStance(Player.Stance.PEACE, (ServerPlayer)p, true, cs);
                }
                continue;
            }
            if ("model.event.boycottsLifted".equals(eventId)) {
                Market market = this.getMarket();
                for (GoodsType goodsType : spec.getGoodsTypeList()) {
                    if (market.getArrears(goodsType) <= 0) continue;
                    market.setArrears(goodsType, 0);
                    cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
                }
                continue;
            }
            if ("model.event.freeBuilding".equals(eventId)) {
                BuildingType type = spec.getBuildingType(event.getValue());
                for (Colony colony : this.getColonies()) {
                    ((ServerColony)colony).csFreeBuilding(type, cs);
                }
                continue;
            }
            if ("model.event.seeAllColonies".equals(eventId)) {
                visibilityChange = true;
                for (Tile t : game.getMap().getAllTiles()) {
                    Colony colony;
                    colony = t.getColony();
                    HashSet<Tile> tiles = new HashSet<Tile>();
                    if (colony != null && !this.owns(colony)) {
                        tiles.addAll(this.exploreForSettlement(colony));
                    }
                    cs.add(ChangeSet.See.only(this), tiles);
                }
                continue;
            }
            if ("model.event.newRecruits".equals(eventId) && europe != null) {
                europeDirty = europe.replaceRecruits(random);
                continue;
            }
            if (!"model.event.movementChange".equals(eventId)) continue;
            for (Unit u : this.getUnits()) {
                if (u.getMovesLeft() <= 0) continue;
                u.setMovesLeft(u.getInitialMovesLeft());
                cs.addPartial(ChangeSet.See.only(this), u, "movesLeft");
            }
        }
        if (europeDirty) {
            cs.add(ChangeSet.See.only(this), europe);
        }
        if (visibilityChange) {
            this.invalidateCanSeeTiles();
        }
    }

    public List<BuildingType> getFreeBuildingTypes() {
        Specification spec = this.getGame().getSpecification();
        ArrayList<BuildingType> result = new ArrayList<BuildingType>();
        for (FoundingFather ff : this.getFathers()) {
            for (Event event : ff.getEvents()) {
                String eventId = event.getId();
                if (!"model.event.freeBuilding".equals(eventId)) continue;
                result.add(spec.getBuildingType(event.getValue()));
            }
        }
        return result;
    }

    public void csClaimLand(Tile tile, Settlement settlement, int price, ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        tile.cacheUnseen();
        tile.changeOwnership(this, settlement);
        cs.add(ChangeSet.See.perhaps(), tile);
        if (price > 0) {
            this.modifyGold(-price);
            owner.modifyGold(price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold");
        } else if (price < 0 && owner.isIndian()) {
            ServerIndianSettlement is = (ServerIndianSettlement)ownerSettlement;
            if (is == null) {
                owner.csModifyTension(this, 200, cs);
            } else {
                is.csModifyAlarm(this, 200, true, cs);
            }
        }
        logger.finest(this.getName() + " claimed " + tile + " from " + (owner == null ? "no-one" : owner.getName()) + ", price: " + (price == 0 ? "free" : (price < 0 ? "stolen" : Integer.valueOf(price))));
    }

    public void csEmigrate(int slot, Europe.MigrationType type, Random random, ChangeSet cs) {
        ServerEurope europe = (ServerEurope)this.getEurope();
        UnitType recruitType = europe.extractRecruitable(slot, random);
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        Role role = spec.getBoolean("model.option.equipEuropeanRecruits") ? recruitType.getDefaultRole() : spec.getDefaultRole();
        ServerUnit unit = new ServerUnit(game, europe, this, recruitType, role);
        switch (type) {
            case FOUNTAIN: {
                this.setRemainingEmigrants(this.getRemainingEmigrants() - 1);
                break;
            }
            case RECRUIT: {
                this.modifyGold(-europe.getRecruitPrice());
                cs.addPartial(ChangeSet.See.only(this), this, "gold");
                europe.increaseRecruitmentDifficulty();
            }
            case NORMAL: {
                this.updateImmigrationRequired();
                this.reduceImmigration();
                cs.addPartial(ChangeSet.See.only(this), this, "immigration", "immigrationRequired");
                if (Europe.MigrationType.specificMigrantSlot(slot)) break;
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.europe.emigrate", this, unit).add("%europe%", europe.getNameKey()).addStringTemplate("%unit%", unit.getLabel()));
                break;
            }
            case SURVIVAL: {
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.europe.autoRecruit", this, unit).add("%europe%", europe.getNameKey()).addStringTemplate("%unit%", unit.getLabel()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Bogus migration type");
            }
        }
        cs.add(ChangeSet.See.only(this), europe);
    }

    public void csCombat(FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs, Random random, ChangeSet cs) throws IllegalStateException {
        ChangeSet.See vis;
        CombatModel combatModel = this.getGame().getCombatModel();
        boolean isAttack = combatModel.combatIsAttack(attacker, defender);
        boolean isBombard = combatModel.combatIsBombard(attacker, defender);
        Unit attackerUnit = null;
        Settlement attackerSettlement = null;
        Tile attackerTile = null;
        Unit defenderUnit = null;
        ServerPlayer defenderPlayer = null;
        Tile defenderTile = null;
        if (isAttack) {
            attackerUnit = (Unit)attacker;
            attackerTile = attackerUnit.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = (ServerPlayer)defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            boolean bombard = attackerUnit.hasAbility("model.ability.bombard");
            cs.addAttribute(ChangeSet.See.only(this), "sound", attackerUnit.isNaval() ? "sound.attack.naval" : (bombard ? "sound.attack.artillery" : (attackerUnit.isMounted() ? "sound.attack.mounted" : "sound.attack.foot")));
            if (attackerUnit.getOwner().isIndian() && defenderPlayer.isEuropean() && defenderUnit.getLocation().getColony() != null && !defenderPlayer.atWarWith(attackerUnit.getOwner())) {
                StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
                Colony colony = defenderUnit.getLocation().getColony();
                cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianSurprise", colony).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
            }
        } else if (isBombard) {
            attackerSettlement = (Settlement)attacker;
            attackerTile = attackerSettlement.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = (ServerPlayer)defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            cs.addAttribute(ChangeSet.See.only(this), "sound", "sound.attack.bombard");
        } else {
            throw new IllegalStateException("Bogus combat");
        }
        assert (defenderTile != null);
        if (crs == null) {
            crs = combatModel.generateAttackResult(random, attacker, defender);
        }
        if (crs.isEmpty()) {
            throw new IllegalStateException("empty attack result");
        }
        CombatModel.CombatResult result = crs.remove(0);
        switch (result) {
            case NO_RESULT: {
                vis = ChangeSet.See.perhaps();
                break;
            }
            case WIN: {
                vis = ChangeSet.See.perhaps().always(defenderPlayer);
                if (!isAttack) break;
                if (attackerTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile + "\n" + FreeColDebugger.stackTraceToString());
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, attackerTile, defenderTile, true);
                break;
            }
            case LOSE: {
                vis = ChangeSet.See.perhaps().always(this);
                if (!isAttack) break;
                if (attackerTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile + "\n" + FreeColDebugger.stackTraceToString());
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, attackerTile, defenderTile, false);
                break;
            }
            default: {
                throw new IllegalStateException("generateAttackResult returned: " + (Object)((Object)result));
            }
        }
        boolean attackerTileDirty = false;
        boolean defenderTileDirty = false;
        boolean moveAttacker = false;
        boolean burnedNativeCapital = false;
        Settlement settlement = defenderTile.getSettlement();
        Colony colony = defenderTile.getColony();
        IndianSettlement natives = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
        int attackerTension = 0;
        int defenderTension = 0;
        for (CombatModel.CombatResult cr : crs) {
            boolean ok;
            switch (cr) {
                case AUTOEQUIP_UNIT: {
                    boolean bl = ok = isAttack && settlement != null;
                    if (!ok) break;
                    this.csAutoequipUnit(defenderUnit, settlement, cs);
                    break;
                }
                case BURN_MISSIONS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    defenderTileDirty |= natives.hasMissionary(this);
                    this.csBurnMissions(attackerUnit, natives, cs);
                    break;
                }
                case CAPTURE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null;
                    if (!ok) break;
                    this.csCaptureAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isEuropean() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csCaptureColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = false;
                    attackerTileDirty = false;
                    moveAttacker = true;
                    defenderTension += 300;
                    break;
                }
                case CAPTURE_CONVERT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    this.csCaptureConvert(attackerUnit, natives, random, cs);
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureEquip(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureEquip(defenderUnit, attackerUnit, cs);
                    }
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureUnit(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureUnit(defenderUnit, attackerUnit, cs);
                    }
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case DAMAGE_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csDamageColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDamageShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDamageShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csDamageShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DEMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDemoteUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDemoteUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DESTROY_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csDestroyColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    defenderTension += 300;
                    break;
                }
                case DESTROY_SETTLEMENT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && defenderPlayer.isIndian();
                    if (!ok) break;
                    burnedNativeCapital = settlement.isCapital();
                    this.csDestroySettlement(attackerUnit, natives, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    if (burnedNativeCapital) break;
                    defenderTension += 300;
                    break;
                }
                case EVADE_ATTACK: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeAttack(attackerUnit, defenderUnit, cs);
                    break;
                }
                case EVADE_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeBombard(attackerSettlement, defenderUnit, cs);
                    break;
                }
                case LOOT_SHIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT && attackerUnit.isNaval() && defenderUnit.isNaval();
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLootShip(attackerUnit, defenderUnit, cs);
                        break;
                    }
                    this.csLootShip(defenderUnit, attackerUnit, cs);
                    break;
                }
                case LOSE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null;
                    if (!ok) break;
                    this.csLoseAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case LOSE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLoseEquip(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csLoseEquip(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case PILLAGE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csPillageColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTension -= 200;
                    break;
                }
                case PROMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csPromoteUnit(attackerUnit, cs);
                        attackerTileDirty = true;
                        break;
                    }
                    this.csPromoteUnit(defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csSinkColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSinkShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csSinkShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case SINK_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csSinkShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SLAUGHTER_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSlaughterUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        attackerTension -= 200;
                        defenderTension += this.getSlaughterTension(defenderUnit);
                        break;
                    }
                    this.csSlaughterUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    attackerTension += this.getSlaughterTension(attackerUnit);
                    defenderTension -= 200;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (ok) continue;
            throw new IllegalStateException("Attack (result=" + (Object)((Object)result) + ") has bogus subresult: " + (Object)((Object)cr));
        }
        if (attacker.hasAbility("model.ability.piracy")) {
            if (!defenderPlayer.getAttackedByPrivateers()) {
                defenderPlayer.setAttackedByPrivateers(true);
                cs.addPartial(ChangeSet.See.only(defenderPlayer), defenderPlayer, "attackedByPrivateers");
            }
        } else if (!defender.hasAbility("model.ability.piracy")) {
            if (burnedNativeCapital) {
                defenderPlayer.getTension(this).setValue(Tension.SURRENDERED);
                cs.add(ChangeSet.See.perhaps().always(this), defenderPlayer);
                this.csChangeStance(Player.Stance.PEACE, defenderPlayer, true, cs);
                for (IndianSettlement is : defenderPlayer.getIndianSettlements()) {
                    if (!is.hasContacted(this)) continue;
                    is.getAlarm(this).setValue(Tension.SURRENDERED);
                    if (this.hasExplored(is.getTile())) {
                        cs.add(ChangeSet.See.perhaps().always(this), is);
                        continue;
                    }
                    cs.add(ChangeSet.See.only(defenderPlayer), is);
                }
            } else if (this.isEuropean() && defenderPlayer.isEuropean()) {
                this.csChangeStance(Player.Stance.WAR, defenderPlayer, true, cs);
            } else {
                if (this.isEuropean()) {
                    this.csChangeStance(Player.Stance.WAR, defenderPlayer, true, cs);
                } else if (this.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        attackerTension -= 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        attackerTension += 100;
                    }
                }
                if (defenderPlayer.isEuropean()) {
                    defenderPlayer.csChangeStance(Player.Stance.WAR, this, true, cs);
                } else if (defenderPlayer.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        defenderTension += 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        defenderTension -= 100;
                    }
                }
                if (attackerTension != 0) {
                    this.csModifyTension(defenderPlayer, attackerTension, cs);
                }
                if (defenderTension != 0) {
                    defenderPlayer.csModifyTension(this, defenderTension, cs);
                }
            }
        }
        if (moveAttacker) {
            attackerUnit.setMovesLeft(attackerUnit.getInitialMovesLeft());
            ((ServerUnit)attackerUnit).csMove(defenderTile, random, cs);
            attackerUnit.setMovesLeft(0);
            defenderTileDirty = false;
            attackerTileDirty = false;
            cs.add(ChangeSet.See.only(defenderPlayer), defenderTile);
        } else if (isAttack) {
            if (attacker.hasAbility("model.ability.multipleAttacks")) {
                int movecost = attackerUnit.getMoveCost(defenderTile);
                attackerUnit.setMovesLeft(attackerUnit.getMovesLeft() - movecost);
            } else {
                attackerUnit.setMovesLeft(0);
            }
            if (!attackerTileDirty) {
                cs.addPartial(ChangeSet.See.only(this), attacker, "movesLeft");
            }
        }
        if (attackerTileDirty) {
            if (attackerSettlement != null) {
                cs.remove(attackerSettlement);
            }
            cs.add(vis, attackerTile);
        }
        if (defenderTileDirty) {
            if (settlement != null) {
                cs.remove(settlement);
            }
            cs.add(vis, defenderTile);
        }
    }

    private int getSlaughterTension(Unit loser) {
        Settlement settlement = loser.getSettlement();
        if (settlement != null) {
            if (settlement instanceof IndianSettlement) {
                return ((IndianSettlement)settlement).isCapital() ? 600 : 500;
            }
            return 200;
        }
        return loser.getHomeIndianSettlement() != null ? 400 : 100;
    }

    private void csAutoequipUnit(Unit unit, Settlement settlement, ChangeSet cs) {
        ServerPlayer player = (ServerPlayer)unit.getOwner();
        cs.addMessage(ChangeSet.See.only(player), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.automaticDefence", unit).addStringTemplate("%unit%", unit.getLabel()).addName("%colony%", settlement.getName()));
    }

    private void csBurnMissions(Unit attacker, IndianSettlement settlement, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        ServerPlayer nativePlayer = (ServerPlayer)settlement.getOwner();
        StringTemplate nativeNation = nativePlayer.getNationName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.burnMissions", attacker, settlement).addStringTemplate("%nation%", attackerNation).addStringTemplate("%enemyNation%", nativeNation));
        boolean here = settlement.hasMissionary(attackerPlayer);
        for (IndianSettlement s : nativePlayer.getIndianSettlements()) {
            if (!s.hasMissionary(attackerPlayer)) continue;
            ((ServerIndianSettlement)s).csKillMissionary(null, cs);
        }
        if (here) {
            cs.remove(settlement.getTile());
        }
    }

    private void csCaptureAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        Role role = defender.getAutomaticRole();
        this.csLoseAutoEquip(attacker, defender, cs);
        this.csCaptureEquipment(attacker, defender, role, cs);
    }

    private void csCaptureColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        Tile tile = colony.getTile();
        ArrayList<Unit> units = new ArrayList<Unit>();
        units.addAll(colony.getUnitList());
        units.addAll(tile.getUnitList());
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(attackerPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.CONQUER_COLONY, attackerPlayer).addStringTemplate("%nation%", colonyNation).addName("%colony%", colony.getName()));
        cs.addHistory(colonyPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.COLONY_CONQUERED, attackerPlayer).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCaptured", colony).addName("%colony%", colony.getName()).addAmount("%amount%", plunder));
        cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCapturedBy", colony.getTile()).addName("%colony%", colony.getName()).addAmount("%amount%", plunder).addStringTemplate("%player%", attackerNation));
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold");
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
        }
        for (Modifier m : colony.getModifiers()) {
            if (Specification.COLONY_GOODS_PARTY_SOURCE != m.getSource()) continue;
            colony.removeModifier(m);
        }
        Set<Tile> explored = attackerPlayer.exploreForSettlement(colony);
        Set<Tile> tiles = colony.getOwnedTiles();
        for (Tile t : tiles) {
            t.cacheUnseen(attackerPlayer);
            if (explored.contains(t)) continue;
            explored.add(t);
        }
        ((ServerColony)colony).csChangeOwner(attackerPlayer, cs);
        tiles.remove(tile);
        explored.remove(tile);
        cs.add(ChangeSet.See.only(attackerPlayer), explored);
        cs.add(ChangeSet.See.perhaps().always(colonyPlayer).except(attackerPlayer), tiles);
        cs.addRemoves(ChangeSet.See.only(colonyPlayer), null, units);
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.captureColony");
        attackerPlayer.invalidateCanSeeTiles();
        colonyPlayer.invalidateCanSeeTiles();
    }

    private void csCaptureConvert(Unit attacker, IndianSettlement is, Random random, ChangeSet cs) {
        ServerUnit convert;
        Specification spec = this.getGame().getSpecification();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        ServerPlayer nativePlayer = (ServerPlayer)is.getOwner();
        StringTemplate convertNation = nativePlayer.getNationName();
        List<Unit> units = is.getTile().getUnitList();
        if (units.isEmpty()) {
            units.addAll(is.getUnitList());
        }
        if (nativePlayer.csChangeOwner(convert = (ServerUnit)RandomUtils.getRandomMember(logger, "Choose convert", units, random), attackerPlayer, UnitTypeChange.ChangeType.CONVERSION, attacker.getTile(), cs)) {
            convert.changeRole(spec.getDefaultRole(), 0);
            convert.setMovesLeft(0);
            convert.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.only(nativePlayer), is.getTile());
            cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.newConvertFromAttack", convert).addStringTemplate("%nation%", convertNation).addStringTemplate("%unit%", convert.getLabel()));
            attackerPlayer.invalidateCanSeeTiles();
        }
    }

    private void csCaptureEquip(Unit winner, Unit loser, ChangeSet cs) {
        Role role = loser.getRole();
        this.csLoseEquip(winner, loser, cs);
        this.csCaptureEquipment(winner, loser, role, cs);
    }

    private void csCaptureEquipment(Unit winner, Unit loser, Role role, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        Role newRole = winner.canCaptureEquipment(role);
        if (newRole != null) {
            List<AbstractGoods> newGoods = winner.getGoodsDifference(newRole, 1);
            GoodsType goodsType = newGoods.get(0).getType();
            winner.changeRole(newRole, 1);
            if (winnerPlayer.isIndian()) {
                StringTemplate winnerNation = winnerPlayer.getNationName();
                cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.equipmentCaptured", winnerPlayer).addStringTemplate("%nation%", winnerNation).add("%equipment%", goodsType.getNameKey()));
                IndianSettlement settlement = winner.getHomeIndianSettlement();
                if (settlement != null) {
                    for (AbstractGoods ag : newGoods) {
                        settlement.addGoods(ag);
                        winnerPlayer.logCheat("teleported " + ag + " back to " + settlement.getName());
                    }
                    cs.add(ChangeSet.See.only(winnerPlayer), settlement);
                }
            }
        }
    }

    private void csCaptureUnit(Unit winner, Unit loser, ChangeSet cs) {
        UnitTypeChange.ChangeType change;
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationName();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        String messageId = loser.getType().getId() + ".captured";
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winnerPlayer.getNationName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        Tile oldTile = loser.getTile();
        UnitTypeChange.ChangeType changeType = change = winnerPlayer.isUndead() ? UnitTypeChange.ChangeType.UNDEAD : UnitTypeChange.ChangeType.CAPTURE;
        if (loserPlayer.csChangeOwner(loser, winnerPlayer, change, winner.getTile(), cs)) {
            loser.setMovesLeft(0);
            loser.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps().always(loserPlayer), oldTile);
            cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitCaptured").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", oldName).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        }
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser.getTile()).setDefaultId("model.unit.unitCaptured").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", oldName).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
        winnerPlayer.invalidateCanSeeTiles();
        loserPlayer.invalidateCanSeeTiles();
    }

    private void csDamageColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        boolean captureRepairing = this.getSpecification().getBoolean("model.option.captureUnitsUnderRepair");
        List<Unit> units = colony.getTile().getUnitList();
        while (!units.isEmpty()) {
            Unit unit = units.remove(0);
            if (!unit.isNaval() || captureRepairing && unit.isDamaged()) continue;
            this.csDamageShipAttack(attacker, unit, cs);
        }
    }

    private void csDamageShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationLabelFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamaged", attacker).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%enemyNation%", shipNation).addStringTemplate("%enemyUnit%", ship.getLabel()));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamaged", ship).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%enemyUnit%", attacker.getLabel()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationLabelFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamagedByBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%nation%", shipNation).addStringTemplate("%unit%", ship.getLabel()));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamagedByBombardment", ship).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShip(Unit ship, Location repair, ChangeSet cs) {
        ServerPlayer player = (ServerPlayer)ship.getOwner();
        for (Goods g : ship.getGoodsContainer().getCompactGoods()) {
            ship.remove(g);
        }
        for (Unit u : ship.getUnitList()) {
            ship.remove(u);
            cs.addDispose(ChangeSet.See.only(player), null, u);
        }
        Location shipLoc = repair instanceof Colony ? repair.getTile() : repair;
        ship.setHitPoints(1);
        ship.setDestination(null);
        ship.setLocation(shipLoc);
        ship.setState(Unit.UnitState.ACTIVE);
        ship.setMovesLeft(0);
        cs.add(ChangeSet.See.only(player), (FreeColGameObject)((Object)shipLoc));
        player.invalidateCanSeeTiles();
    }

    private void csDemoteUnit(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        String messageId = loser.getType().getId() + ".demoted";
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        UnitType type = loser.getTypeChange(UnitTypeChange.ChangeType.DEMOTION, loserPlayer);
        if (type == null || type == loser.getType()) {
            logger.warning("Demotion failed, type=" + (type == null ? "null" : "same type: " + type));
            return;
        }
        loser.changeType(type);
        loserPlayer.invalidateCanSeeTiles();
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserPlayer.getNationName()).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
    }

    private void csDestroyColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(colonyPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.COLONY_DESTROYED, attackerPlayer).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
        cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyBurning", colony.getTile()).addName("%colony%", colony.getName()).addAmount("%amount%", plunder).addStringTemplate("%nation%", attackerNation).addStringTemplate("%unit%", attacker.getLabel()));
        cs.addMessage(ChangeSet.See.all().except(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyBurning.other", colonyPlayer).addName("%colony%", colony.getName()).addStringTemplate("%nation%", colonyNation).addStringTemplate("%attackerNation%", attackerNation));
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold");
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
        }
        this.csDisposeSettlement(colony, cs);
    }

    private void csDestroySettlement(Unit attacker, IndianSettlement settlement, Random random, ChangeSet cs) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        Tile tile = settlement.getTile();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        ServerPlayer nativePlayer = (ServerPlayer)settlement.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        StringTemplate nativeNation = nativePlayer.getNationName();
        String settlementName = settlement.getName();
        boolean capital = settlement.isCapital();
        int plunder = settlement.getPlunder(attacker, random);
        for (Unit u : settlement.getOwnedUnits()) {
            u.setHomeIndianSettlement(null);
            cs.add(ChangeSet.See.only(nativePlayer), u);
        }
        this.csDisposeSettlement(settlement, cs);
        if (plunder > 0) {
            List<UnitType> unitTypes = spec.getUnitTypesWithAbility("model.ability.carryTreasure");
            UnitType type = RandomUtils.getRandomMember(logger, "Choose train", unitTypes, random);
            ServerUnit train = new ServerUnit(game, tile, attackerPlayer, type);
            train.setTreasureAmount(plunder);
        }
        int score = spec.getInteger("model.option.destroySettlementScore");
        HistoryEvent h = new HistoryEvent(game.getTurn(), HistoryEvent.EventType.DESTROY_SETTLEMENT, this).addStringTemplate("%nation%", nativeNation).addName("%settlement%", settlementName);
        h.setScore(score);
        cs.addHistory(attackerPlayer, h);
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianTreasure", attacker).addName("%settlement%", settlementName).addAmount("%amount%", plunder));
        if (capital) {
            cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.capitalBurned", attacker).addName("%name%", settlementName).addStringTemplate("%nation%", nativeNation));
        }
        if (nativePlayer.checkForDeath() == -1) {
            h = new HistoryEvent(game.getTurn(), HistoryEvent.EventType.DESTROY_NATION, this).addStringTemplate("%nation%", attackerNation).addStringTemplate("%nativeNation%", nativeNation);
            h.setScore(-50);
            cs.addGlobalHistory(game, h);
        }
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.destroySettlement");
    }

    public void csDisposeSettlement(Settlement settlement, ChangeSet cs) {
        Settlement claimant;
        ServerIndianSettlement sis;
        logger.finest("Disposing of " + settlement.getName());
        ServerPlayer owner = (ServerPlayer)settlement.getOwner();
        Set<Tile> owned = settlement.getOwnedTiles();
        for (Tile t : owned) {
            t.cacheUnseen();
        }
        Tile centerTile = settlement.getTile();
        ServerPlayer missionaryOwner = null;
        int radius = 0;
        if (settlement instanceof ServerIndianSettlement && (sis = (ServerIndianSettlement)settlement).hasMissionary()) {
            missionaryOwner = (ServerPlayer)sis.getMissionary().getOwner();
            radius = sis.getMissionaryLineOfSight();
            sis.csKillMissionary("indianSettlement.mission.destroyed", cs);
        }
        settlement.exciseSettlement();
        owner.removeSettlement(settlement);
        if (owner.hasSettlement(settlement)) {
            throw new IllegalStateException("Still has settlement: " + settlement);
        }
        Object centerClaimant = null;
        HashMap<Settlement, Integer> votes = new HashMap<Settlement, Integer>();
        HashMap<Tile, Settlement> claims = new HashMap<Tile, Settlement>();
        for (Tile tile : owned) {
            votes.clear();
            for (Tile t : tile.getSurroundingTiles(1)) {
                int value;
                claimant = t.getOwningSettlement();
                if (claimant == null || claimant.isDisposed() || claimant.getOwner() == null || !claimant.getOwner().canOwnTile(tile) || !claimant.getOwner().isIndian() && claimant.getTile().getDistanceTo(tile) > claimant.getRadius()) continue;
                int n = claimant.getOwner() == owner ? 3 : (value = claimant.getOwner().isEuropean() == owner.isEuropean() ? 2 : 1);
                if (votes.get(claimant) != null) {
                    value += ((Integer)votes.get(claimant)).intValue();
                }
                votes.put(claimant, value);
            }
            claimant = null;
            if (!votes.isEmpty()) {
                int bestValue = 0;
                for (Map.Entry entry : votes.entrySet()) {
                    int value = (Integer)entry.getValue();
                    if (bestValue >= value) continue;
                    bestValue = value;
                    claimant = (Settlement)entry.getKey();
                }
            }
            claims.put(tile, claimant);
        }
        for (Map.Entry entry : claims.entrySet()) {
            Tile t = (Tile)entry.getKey();
            claimant = (Settlement)entry.getValue();
            if (claimant == null) {
                t.changeOwnership(null, null);
                continue;
            }
            ServerPlayer newOwner = (ServerPlayer)claimant.getOwner();
            t.changeOwnership(newOwner, claimant);
        }
        ChangeSet.See vis = ChangeSet.See.perhaps().always(owner);
        if (missionaryOwner != null) {
            vis.except(missionaryOwner);
        }
        cs.add(vis, owned);
        cs.addDispose(vis, centerTile, settlement);
        owner.invalidateCanSeeTiles();
        if (missionaryOwner != null) {
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (Tile t : centerTile.getSurroundingTiles(1, radius)) {
                if (owned.contains(t)) continue;
                arrayList.add(t);
            }
            cs.add(ChangeSet.See.only(missionaryOwner), owned);
            cs.add(ChangeSet.See.only(missionaryOwner), arrayList);
            cs.addDispose(ChangeSet.See.only(missionaryOwner), centerTile, settlement);
            missionaryOwner.invalidateCanSeeTiles();
            for (Tile t : arrayList) {
                t.cacheUnseen(missionaryOwner);
            }
        }
        for (Tile t : owned) {
            t.cacheUnseen();
        }
        if (settlement instanceof IndianSettlement) {
            centerTile.seeTile();
        }
        if (missionaryOwner != null) {
            centerTile.seeTile(missionaryOwner);
        }
    }

    private void csEvadeAttack(Unit attacker, Unit defender, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipEvaded", attacker).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%enemyUnit%", defender.getLabel()).addStringTemplate("%enemyNation%", defenderNation));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvaded", defender).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%enemyUnit%", attacker.getLabel()).addStringTemplate("%enemyNation%", attackerNation));
    }

    private void csEvadeBombard(Settlement settlement, Unit defender, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%nation%", defenderNation));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", defender).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%nation%", defenderNation));
    }

    private void csLootShip(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        List<Goods> capture = loser.getGoodsList();
        if (!capture.isEmpty() && winner.hasSpaceLeft()) {
            for (Goods g : capture) {
                g.setLocation(null);
            }
            new LootSession(winner, loser, capture);
            cs.add(ChangeSet.See.only(winnerPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new LootCargoMessage(winner, loser.getId(), capture));
        }
        loser.getGoodsContainer().removeAll();
        loser.setState(Unit.UnitState.ACTIVE);
    }

    private void csLoseAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defenderPlayer.getNationName();
        Settlement settlement = defender.getSettlement();
        StringTemplate defenderLocation = defender.getLocation().getLocationLabelFor(defenderPlayer);
        Role role = defender.getAutomaticRole();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerLocation = attacker.getLocation().getLocationLabelFor(attackerPlayer);
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        for (AbstractGoods ag : role.getRequiredGoods()) {
            settlement.removeGoods(ag);
        }
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitWinColony", attacker).addStringTemplate("%location%", attackerLocation).addStringTemplate("%nation%", attackerPlayer.getNationName()).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%settlement%", settlement.getLocationLabelFor(attackerPlayer)).addStringTemplate("%enemyNation%", defenderNation).addStringTemplate("%enemyUnit%", defender.getLabel()));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitLoseAutoEquip", defender).addStringTemplate("%location%", defenderLocation).addStringTemplate("%nation%", defenderNation).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%settlement%", settlement.getLocationLabelFor(defenderPlayer)).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
    }

    private void csLoseEquip(Unit winner, Unit loser, ChangeSet cs) {
        String messageId;
        Specification spec = this.getSpecification();
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationName();
        StringTemplate loserLocation = loser.getLocation().getLocationLabelFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationLabelFor(winnerPlayer);
        Role role = loser.getRole();
        Role downgrade = role.getDowngrade();
        if (downgrade != null) {
            loser.changeRole(downgrade, 1);
        } else {
            loser.changeRole(spec.getDefaultRole(), 0);
        }
        loser.setMovesLeft(Math.min(loser.getMovesLeft(), loser.getInitialMovesLeft()));
        if (!loser.isArmed()) {
            messageId = "model.unit.unitDemotedToUnarmed";
            loser.setState(Unit.UnitState.ACTIVE);
        } else {
            messageId = loser.getType().getId() + ".demoted";
        }
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
    }

    private void csPillageColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        List<Building> buildingList = colony.getBurnableBuildings();
        List<Unit> shipList = colony.getTile().getNavalUnits();
        List<Goods> goodsList = colony.getLootableGoodsList();
        int pillage = RandomUtils.randomInt(logger, "Pillage choice", random, buildingList.size() + shipList.size() + goodsList.size() + (colony.canBePlundered() ? 1 : 0));
        if (pillage < buildingList.size()) {
            Building building = buildingList.get(pillage);
            this.csDamageBuilding(building, cs);
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.buildingDamaged", colony).add("%building%", building.getNameKey()).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else if (pillage < buildingList.size() + shipList.size()) {
            Unit ship = shipList.get(pillage - buildingList.size());
            if (ship.getRepairLocation() == null) {
                this.csSinkShipAttack(attacker, ship, cs);
            } else {
                this.csDamageShipAttack(attacker, ship, cs);
            }
        } else if (pillage < buildingList.size() + shipList.size() + goodsList.size()) {
            Goods goods = goodsList.get(pillage - buildingList.size() - shipList.size());
            goods.setAmount(Math.min(goods.getAmount() / 2, 50));
            colony.removeGoods(goods);
            if (attacker.canAdd(goods)) {
                attacker.add(goods);
            }
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.goodsStolen", colony, goods).addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getType().getNameKey()).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else {
            int plunder = Math.max(1, colony.getPlunder(attacker, random) / 5);
            colonyPlayer.modifyGold(-plunder);
            attackerPlayer.modifyGold(plunder);
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianPlunder", colony).addAmount("%amount%", plunder).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        }
        cs.addMessage(ChangeSet.See.all().except(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianRaid", colonyPlayer).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()).addStringTemplate("%colonyNation%", colonyNation));
    }

    private void csDamageBuilding(Building building, ChangeSet cs) {
        ServerColony colony = (ServerColony)building.getColony();
        Tile copied = colony.getTile().getTileToCache();
        boolean changed = false;
        BuildingType type = building.getType();
        if (type.getUpgradesFrom() == null) {
            changed = colony.ejectUnits(building, building.getUnitList());
            colony.removeBuilding(building);
            changed |= building.getType().isDefenceType();
            cs.addDispose(ChangeSet.See.only((ServerPlayer)colony.getOwner()), colony, building);
            for (WorkLocation wl : colony.getAllWorkLocations()) {
                if (wl.isEmpty() || wl.canBeWorked()) continue;
                changed |= colony.ejectUnits(wl, wl.getUnitList());
                logger.info("Units ejected from workLocation " + wl.getId() + " on loss of " + building.getType().getSuffix());
            }
        } else if (building.canBeDamaged()) {
            changed = colony.ejectUnits(building, building.downgrade());
            changed |= building.getType().isDefenceType();
        } else {
            return;
        }
        if (changed) {
            colony.getTile().cacheUnseen(copied);
        }
        if (this.isAI()) {
            colony.firePropertyChange("rearrangeWorkers", true, false);
        }
    }

    private void csPromoteUnit(Unit winner, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winnerPlayer.getNationName();
        StringTemplate oldName = winner.getLabel();
        UnitType type = winner.getTypeChange(UnitTypeChange.ChangeType.PROMOTION, winnerPlayer);
        if (type == null || type == winner.getType()) {
            logger.warning("Promotion failed, type=" + (type == null ? "null" : "same type: " + type));
            return;
        }
        winner.changeType(type);
        winnerPlayer.invalidateCanSeeTiles();
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitPromoted", winner).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", winner.getLabel()).addStringTemplate("%nation%", winnerNation));
    }

    private void csSinkColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        boolean captureRepairing = this.getSpecification().getBoolean("model.option.captureUnitsUnderRepair");
        List<Unit> units = colony.getTile().getUnitList();
        while (!units.isEmpty()) {
            Unit unit = units.remove(0);
            if (!unit.isNaval() || captureRepairing && unit.isDamaged()) continue;
            this.csSinkShipAttack(attacker, unit, cs);
        }
    }

    private void csSinkShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        Unit attackerUnit = attacker;
        ServerPlayer attackerPlayer = (ServerPlayer)attackerUnit.getOwner();
        StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipSunk", attackerUnit).addStringTemplate("%unit%", attackerUnit.getLabel()).addStringTemplate("%enemyUnit%", ship.getLabel()).addStringTemplate("%enemyNation%", shipNation));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunk", ship.getTile()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%enemyUnit%", attackerUnit.getLabel()).addStringTemplate("%enemyNation%", attackerNation));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%nation%", shipNation));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", ship.getTile()).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShip(Unit ship, ServerPlayer attackerPlayer, ChangeSet cs) {
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        cs.addDispose(ChangeSet.See.perhaps().always(shipPlayer), ship.getLocation(), ship);
        shipPlayer.invalidateCanSeeTiles();
        if (attackerPlayer != null) {
            cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.shipSunk");
        }
    }

    private void csSlaughterUnit(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        Location winnerLoc = winner.isInColony() ? winner.getColony() : winner.getLocation();
        StringTemplate winnerLocation = winnerLoc.getLocationLabelFor(winnerPlayer);
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        Location loserLoc = loser.isInColony() ? loser.getColony() : loser.getLocation();
        StringTemplate loserLocation = loserLoc.getLocationLabelFor(loserPlayer);
        String messageId = loser.getType().getId() + ".destroyed";
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitSlaughtered").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser.getTile()).setDefaultId("model.unit.unitSlaughtered").addStringTemplate("%nation%", loserPlayer.getNationName()).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
        if (loserPlayer.isIndian() && loserPlayer.checkForDeath() == -1) {
            StringTemplate nativeNation = loserPlayer.getNationName();
            cs.addGlobalHistory(this.getGame(), new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.DESTROY_NATION, winnerPlayer).addStringTemplate("%nation%", winnerNation).addStringTemplate("%nativeNation%", nativeNation));
        }
        cs.addDispose(loserLoc.getSettlement() != null ? ChangeSet.See.only(loserPlayer) : ChangeSet.See.perhaps().always(loserPlayer), loserLoc, loser);
        loserPlayer.invalidateCanSeeTiles();
    }

    public void csSeeNewTiles(Collection<? extends Tile> newTiles, ChangeSet cs) {
        this.exploreTiles(newTiles);
        cs.add(ChangeSet.See.only(this), newTiles);
    }

    public Modifier makeTeaPartyModifier() {
        Specification spec = this.getGame().getSpecification();
        Turn turn = this.getGame().getTurn();
        Iterator<Modifier> i$ = spec.getModifiers("model.modifier.colonyGoodsParty").iterator();
        if (i$.hasNext()) {
            Modifier modifier = i$.next();
            Modifier m = Modifier.makeTimedModifier("model.goods.bells", modifier, turn);
            m.setModifierIndex(90);
            return m;
        }
        return null;
    }

    public void csRaiseTax(int tax, Goods goods, boolean accepted, ChangeSet cs) {
        GoodsType goodsType = goods.getType();
        Colony colony = (Colony)goods.getLocation();
        int amount = Math.min(goods.getAmount(), 100);
        String monarchKey = this.getMonarchKey();
        if (accepted) {
            this.csSetTax(tax, cs);
            logger.info("Accepted tax raise to: " + tax);
        } else if (colony.getGoodsCount(goodsType) < amount) {
            int extraTax = 3;
            this.csSetTax(tax + 3, cs);
            cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(Monarch.MonarchAction.FORCE_TAX, StringTemplate.template("model.monarch.action.FORCE_TAX").addAmount("%amount%", tax + 3), monarchKey));
            logger.info("Forced tax raise to: " + (tax + 3));
        } else {
            Specification spec = this.getGame().getSpecification();
            colony.getGoodsContainer().saveState();
            colony.removeGoods(goodsType, amount);
            int arrears = this.market.getPaidForSale(goodsType) * spec.getInteger("model.option.arrearsFactor");
            Market market = this.getMarket();
            market.setArrears(goodsType, arrears);
            Modifier tpm = this.makeTeaPartyModifier();
            cs.addFeatureChange(this, (FreeColGameObject)colony, tpm, true);
            cs.add(ChangeSet.See.only(this), colony.getGoodsContainer());
            cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
            String messageId = goodsType.getId() + ".destroyed";
            if (!Messages.containsKey(messageId)) {
                messageId = colony.isLandLocked() ? "model.monarch.colonyGoodsParty.landLocked" : "model.monarch.colonyGoodsParty.harbour";
            }
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, this).addName("%colony%", colony.getName()).addAmount("%amount%", amount).add("%goods%", goodsType.getNameKey()));
            cs.addAttribute(ChangeSet.See.only(this), "flush", Boolean.TRUE.toString());
            logger.info("Goods party at " + colony.getName() + " with: " + goods + " arrears: " + arrears);
            if (this.isAI()) {
                colony.firePropertyChange("rearrangeWorkers", goodsType, null);
            }
        }
    }

    public void csSetTax(int tax, ChangeSet cs) {
        this.setTax(tax);
        if (this.recalculateBellsBonus()) {
            cs.add(ChangeSet.See.only(this), this);
        } else {
            cs.addPartial(ChangeSet.See.only(this), this, "tax");
        }
    }

    public void csAddMercenaries(List<AbstractUnit> mercs, int price, ChangeSet cs) {
        if (this.checkGold(price)) {
            this.createUnits(mercs, this.getEurope());
            cs.add(ChangeSet.See.only(this), this.getEurope());
            this.modifyGold(-price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold");
        } else {
            this.getMonarch().setDispleasure(true);
            cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(Monarch.MonarchAction.DISPLEASURE, StringTemplate.template("model.monarch.action.DISPLEASURE"), this.getMonarchKey()));
        }
    }

    public boolean csContact(ServerPlayer other, ChangeSet cs) {
        if (this.hasContacted(other)) {
            return false;
        }
        Game game = this.getGame();
        Turn turn = game.getTurn();
        if (this.isIndian()) {
            if (other.isIndian()) {
                return false;
            }
            cs.addHistory(other, new HistoryEvent(turn, HistoryEvent.EventType.MEET_NATION, other).addStringTemplate("%nation%", this.getNationName()));
        } else {
            cs.addHistory(this, new HistoryEvent(turn, HistoryEvent.EventType.MEET_NATION, other).addStringTemplate("%nation%", other.getNationName()));
        }
        logger.finest("First contact between " + this.getId() + " and " + other.getId());
        return true;
    }

    public void csNativeFirstContact(ServerPlayer other, Tile tile, ChangeSet cs) {
        cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_EARLY, new FirstContactMessage(this, other, tile));
        this.csChangeStance(Player.Stance.PEACE, other, true, cs);
        if (tile != null) {
            new DiplomacySession(tile.getFirstUnit(), tile.getOwningSettlement());
        }
    }

    public void csEuropeanFirstContact(Unit unit, Settlement settlement, Unit otherUnit, ChangeSet cs) {
        ServerPlayer other;
        Game game = this.getGame();
        if (settlement != null) {
            other = (ServerPlayer)settlement.getOwner();
        } else if (otherUnit != null) {
            other = (ServerPlayer)otherUnit.getOwner();
        } else {
            throw new IllegalArgumentException("Non-null settlement or otherUnit required.");
        }
        DiplomaticTrade agreement = new DiplomaticTrade(game, DiplomaticTrade.TradeContext.CONTACT, this, other, null, 0);
        agreement.add(new StanceTradeItem(game, this, (Player)other, Player.Stance.PEACE));
        DiplomacySession session = settlement == null ? new DiplomacySession(unit, otherUnit) : new DiplomacySession(unit, settlement);
        session.setAgreement(agreement);
        cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_LATE, settlement == null ? new DiplomacyMessage(unit, otherUnit, agreement) : new DiplomacyMessage((FreeColGameObject)unit, settlement, agreement));
    }

    public boolean csChangeOwner(Unit unit, ServerPlayer newOwner, UnitTypeChange.ChangeType change, Location loc, ChangeSet cs) {
        if (newOwner == this) {
            return true;
        }
        Tile oldTile = unit.getTile();
        UnitType mainType = unit.getTypeChange(change, newOwner);
        if (mainType == null) {
            mainType = unit.getType();
        }
        if (!mainType.isAvailableTo(newOwner)) {
            cs.addDispose(ChangeSet.See.perhaps().always(this), oldTile, unit);
            return false;
        }
        for (Unit u : unit.getUnitList()) {
            UnitType type = u.getTypeChange(change, newOwner);
            if (type == null) {
                type = u.getType();
            }
            if (!type.isAvailableTo(newOwner)) {
                cs.addDispose(ChangeSet.See.only(this), unit, u);
                continue;
            }
            if (u.changeType(type)) continue;
            throw new IllegalStateException("Type change failure: " + u + " -> " + type);
        }
        if (mainType != unit.getType() && !unit.changeType(mainType)) {
            throw new IllegalStateException("Type change failure: " + unit + " -> " + mainType);
        }
        unit.changeOwner(newOwner);
        if (loc != null) {
            unit.setLocation(loc);
        }
        if (unit.isCarrier()) {
            cs.addRemoves(ChangeSet.See.only(this), unit, unit.getUnitList());
        }
        cs.add(ChangeSet.See.only(newOwner), newOwner.exploreForUnit(unit));
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[ServerPlayer ").append(this.getId()).append(" ").append(this.getName()).append(" ").append(this.connection).append("]");
        return sb.toString();
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverPlayer";
    }
}

