/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;

public class ServerColonyTile
extends ColonyTile
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerColonyTile.class.getName());

    public ServerColonyTile(Game game, String id) {
        super(game, id);
    }

    public ServerColonyTile(Game game, Colony colony, Tile workTile) {
        super(game, colony, workTile);
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        Colony colony = this.getColony();
        ServerPlayer owner = (ServerPlayer)colony.getOwner();
        Tile workTile = this.getWorkTile();
        if (!this.isColonyCenterTile() && !this.isEmpty() && this.canBeWorked()) {
            for (Unit unit : this.getUnitList()) {
                Resource resource = this.expendResource(workTile, unit.getWorkType(), unit.getType());
                if (resource == null) continue;
                lb.add(" ", this.getId(), " exhausted resource ", resource.getType().getSuffix());
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.tile.resourceExhausted", colony).add("%resource%", resource.getNameKey()).addName("%colony%", colony.getName()));
                cs.add(ChangeSet.See.perhaps(), workTile);
                break;
            }
        }
    }

    private Resource expendResource(Tile tile, GoodsType goodsType, UnitType unitType) {
        if (!tile.hasResource()) {
            return null;
        }
        Resource resource = tile.getResource();
        if (resource.isUnlimited()) {
            return null;
        }
        if (resource.useQuantity(goodsType, unitType, tile.getPotentialProduction(goodsType, unitType)) == 0) {
            tile.cacheUnseen();
            tile.removeResource();
            return resource;
        }
        return null;
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverColonyTile";
    }
}

