/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.logging.Logger;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;

public class DiplomacySession
extends TransactionSession {
    private static final Logger logger = Logger.getLogger(DiplomacySession.class.getName());
    private DiplomaticTrade agreement = null;
    private Unit unit;
    private Settlement settlement;
    private Unit otherUnit;

    public DiplomacySession(Unit unit, Settlement settlement) {
        super(DiplomacySession.makeSessionKey(DiplomacySession.class, unit, settlement));
        this.unit = unit;
        this.settlement = settlement;
        this.otherUnit = null;
    }

    public DiplomacySession(Unit unit, Unit otherUnit) {
        super(DiplomacySession.makeSessionKey(DiplomacySession.class, unit, otherUnit));
        this.unit = unit;
        this.settlement = null;
        this.otherUnit = otherUnit;
    }

    @Override
    public void complete(ChangeSet cs) {
        this.unit.setMovesLeft(0);
        cs.add(ChangeSet.See.only((ServerPlayer)this.unit.getOwner()), this.unit);
        super.complete(cs);
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public void setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public Unit getOtherUnit() {
        return this.otherUnit;
    }
}

