/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LandMap;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

public class SimpleMapGenerator
implements MapGenerator {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;
    private final Game game;
    private final Random random;
    private OptionGroup mapOptions;
    private Specification spec;
    private Game importGame;

    public SimpleMapGenerator(Game game, Random random) {
        this.game = game;
        this.random = random;
    }

    private void recache(boolean checkImport) {
        this.mapOptions = this.game.getMapGeneratorOptions();
        this.spec = this.game.getSpecification();
        File importFile = checkImport ? ((FileOption)this.mapOptions.getOption("model.option.importFile")).getValue() : null;
        this.importGame = importFile == null ? null : FreeColServer.readGame(importFile, this.spec, null);
    }

    private int getApproximateLandCount() {
        return this.mapOptions.getInteger("model.option.mapWidth") * this.mapOptions.getInteger("model.option.mapHeight") * this.mapOptions.getInteger("model.option.landMass") / 100;
    }

    private void makeLostCityRumours(Map map) {
        boolean importRumours = this.mapOptions.getBoolean("model.option.importRumours");
        if (this.importGame != null && importRumours) {
            int nLCRs = 0;
            for (Tile importTile : this.importGame.getMap().getAllTiles()) {
                int y;
                int x;
                LostCityRumour rumour = importTile.getLostCityRumour();
                if (rumour == null || !map.isValid(x = importTile.getX(), y = importTile.getY())) continue;
                Tile t = map.getTile(x, y);
                rumour.setLocation(t);
                t.addLostCityRumour(rumour);
                ++nLCRs;
            }
            if (nLCRs > 0) {
                logger.info("Imported " + nLCRs + " lost city rumours.");
                return;
            }
        }
        int rumourNumber = this.mapOptions.getInteger("model.option.rumourNumber");
        int number = this.getApproximateLandCount() / rumourNumber;
        int counter = 0;
        if (this.importGame != null) {
            number = map.getWidth() * map.getHeight() * 25 / 3500;
        }
        block1: for (int i = 0; i < number; ++i) {
            for (int tries = 0; tries < 100; ++tries) {
                Tile t = map.getRandomLandTile(this.random);
                if (t.isPolar() || !t.isLand() || t.hasLostCityRumour() || t.hasSettlement() || t.getUnitCount() != 0) continue;
                LostCityRumour r = new LostCityRumour(t.getGame(), t);
                if (r.chooseType(null, this.random) == LostCityRumour.RumourType.MOUNDS && t.getOwningSettlement() != null) {
                    r.setType(LostCityRumour.RumourType.MOUNDS);
                }
                t.addLostCityRumour(r);
                ++counter;
                continue block1;
            }
        }
        logger.info("Created " + counter + " lost city rumours of maximum " + number + ".");
    }

    private boolean importIndianSettlements(Map map) {
        int nSettlements = 0;
        for (Player player : this.importGame.getLiveNativePlayers(null)) {
            Player indian = this.game.getPlayer(player.getNationId());
            if (indian == null) {
                Nation nation = this.spec.getNation(player.getNationId());
                if (nation == null) {
                    logger.warning("Native nation " + player.getNationId() + " not found in spec.");
                    continue;
                }
                indian = new ServerPlayer(this.game, false, nation, null, null);
                logger.info("Imported new native nation " + player.getNationId() + ": " + indian.getId());
                this.game.addPlayer(indian);
            } else {
                logger.info("Found native nation " + player.getNationId() + " for import: " + indian.getId());
            }
            for (IndianSettlement is : player.getIndianSettlements()) {
                int y;
                int x = is.getTile().getX();
                Tile tile = map.getTile(x, y = is.getTile().getY());
                if (tile == null) continue;
                UnitType skill = is.getLearnableSkill();
                ServerIndianSettlement settlement = new ServerIndianSettlement(this.game, indian, is.getName(), tile, is.isCapital(), skill, null);
                settlement.placeSettlement(false);
                List<Unit> units = is.getUnitList();
                if (units.isEmpty()) {
                    settlement.addUnits(this.random);
                } else {
                    for (Unit u : units) {
                        UnitType t = this.spec.getUnitType(u.getType().getId());
                        if (t == null) continue;
                        ServerUnit unit = new ServerUnit(this.game, settlement, indian, t);
                        settlement.add(unit);
                        settlement.addOwnedUnit(unit);
                    }
                }
                List<Goods> goods = is.getCompactGoods();
                if (goods.isEmpty()) {
                    settlement.addRandomGoods(this.random);
                } else {
                    for (Goods g : goods) {
                        GoodsType t = this.spec.getGoodsType(g.getType().getId());
                        if (t == null) continue;
                        settlement.addGoods(t, g.getAmount());
                    }
                }
                settlement.setWantedGoods(is.getWantedGoods());
                ++nSettlements;
            }
        }
        if (nSettlements > 0) {
            for (Tile t : this.importGame.getMap().getAllTiles()) {
                Tile tile;
                String nationId;
                Player owner;
                if (t.getOwner() == null || (owner = this.game.getPlayer(nationId = t.getOwner().getNationId())) == null || (tile = map.getTile(t.getX(), t.getY())) == null) continue;
                tile.setOwner(owner);
                if (tile.getOwningSettlement() == null) continue;
                String name = tile.getOwningSettlement().getName();
                Settlement is = this.game.getSettlement(name);
                tile.setOwningSettlement(is);
            }
        }
        logger.info("Imported " + nSettlements + " native settlements.");
        return nSettlements > 0;
    }

    private void makeNativeSettlements(final Map map) {
        boolean importSettlements = this.mapOptions.getBoolean("model.option.importSettlements");
        if (importSettlements && this.importGame != null && this.importIndianSettlements(map)) {
            return;
        }
        Game game = map.getGame();
        float shares = 0.0f;
        ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>();
        ArrayList<Player> indians = new ArrayList<Player>();
        HashMap<String, Territory> territoryMap = new HashMap<String, Territory>();
        for (Player player : game.getLiveNativePlayers(null)) {
            switch (((IndianNationType)player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    shares += 4.0f;
                    break;
                }
                case AVERAGE: {
                    shares += 3.0f;
                    break;
                }
                case LOW: {
                    shares += 2.0f;
                }
            }
            indians.add(player);
            List<String> regionNames = ((IndianNationType)player.getNationType()).getRegionNames();
            Territory territory = null;
            if (regionNames == null || regionNames.isEmpty()) {
                territory = new Territory(player, map.getRandomLandTile(this.random));
                territoryMap.put(player.getId(), territory);
                continue;
            }
            for (String name : regionNames) {
                if (territoryMap.get(name) != null) continue;
                ServerRegion region = (ServerRegion)map.getRegion(name);
                territory = region == null ? new Territory(player, map.getRandomLandTile(this.random)) : new Territory(player, region);
                territoryMap.put(name, territory);
                logger.fine("Allocated region " + name + " for " + player + ".");
                break;
            }
            if (territory != null) continue;
            logger.warning("Failed to allocate preferred region " + regionNames.get(0) + " for " + player.getNation());
            block12: for (String name : regionNames) {
                Territory otherTerritory = (Territory)territoryMap.get(name);
                for (String otherName : ((IndianNationType)otherTerritory.player.getNationType()).getRegionNames()) {
                    if (territoryMap.get(otherName) != null) continue;
                    ServerRegion foundRegion = otherTerritory.region;
                    otherTerritory.region = (ServerRegion)map.getRegion(otherName);
                    territoryMap.put(otherName, otherTerritory);
                    territory = new Territory(player, foundRegion);
                    territoryMap.put(name, territory);
                    break block12;
                }
            }
            if (territory != null) continue;
            logger.warning("Unable to find free region for " + player.getName());
            territory = new Territory(player, map.getRandomLandTile(this.random));
            territoryMap.put(player.getId(), territory);
        }
        if (indians.isEmpty()) {
            return;
        }
        int minSettlementDistance = this.spec.getRangeOption("model.option.settlementNumber").getValue();
        ArrayList<Tile> settlementTiles = new ArrayList<Tile>();
        block14: for (Tile tile : map.getAllTiles()) {
            if (tile.isPolar() || !this.suitableForNativeSettlement(tile)) continue;
            for (Tile t : settlementTiles) {
                if (tile.getDistanceTo(t) >= minSettlementDistance) continue;
                continue block14;
            }
            settlementTiles.add(tile);
        }
        RandomUtils.randomShuffle(logger, "Settlement tiles", settlementTiles, this.random);
        int settlementsToPlace = settlementTiles.size();
        float share = (float)settlementsToPlace / shares;
        if (settlementTiles.size() < indians.size()) {
            logger.warning("There are only " + settlementTiles.size() + " settlement sites." + " This is smaller than " + indians.size() + " the number of tribes.");
        }
        ArrayList<Territory> territories = new ArrayList<Territory>(territoryMap.values());
        int settlementsPlaced = 0;
        for (Territory territory : territories) {
            int radius;
            IndianSettlement is;
            switch (((IndianNationType)territory.player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    territory.numberOfSettlements = Math.round(4.0f * share);
                    break;
                }
                case AVERAGE: {
                    territory.numberOfSettlements = Math.round(3.0f * share);
                    break;
                }
                case LOW: {
                    territory.numberOfSettlements = Math.round(2.0f * share);
                }
            }
            if ((is = this.placeCapital(map, territory, radius = territory.player.getNationType().getCapitalType().getClaimableRadius(), new ArrayList<Tile>(settlementTiles))) == null) continue;
            settlements.add(is);
            ++settlementsPlaced;
            settlementTiles.remove(is.getTile());
        }
        Collections.sort(settlementTiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile tile1, Tile tile2) {
                int distance1 = Math.min(Math.min(tile1.getX(), map.getWidth() - tile1.getX()), Math.min(tile1.getY(), map.getHeight() - tile1.getY()));
                int distance2 = Math.min(Math.min(tile2.getX(), map.getWidth() - tile2.getX()), Math.min(tile2.getY(), map.getHeight() - tile2.getY()));
                return distance1 - distance2;
            }
        });
        while (!settlementTiles.isEmpty() && !territories.isEmpty()) {
            Territory territory;
            Tile tile = (Tile)settlementTiles.remove(0);
            if (tile.getOwner() != null) continue;
            territory = this.getClosestTerritory(map, tile, territories);
            int radius = territory.player.getNationType().getSettlementType(false).getClaimableRadius();
            if (territory.player.getClaimableTiles(tile, radius).size() <= 2 * radius + 1) continue;
            String name = territory.region == null ? "default region" : territory.region.getNameKey();
            logger.fine("Placing a " + territory.player + " camp in region: " + name + " at tile: " + tile);
            settlements.add(this.placeIndianSettlement(territory.player, false, tile, map));
            ++settlementsPlaced;
            --territory.numberOfSettlements;
            if (territory.numberOfSettlements > 0) continue;
            territories.remove(territory);
        }
        HashMap<UnitType, ArrayList<IndianSettlement>> skills = new HashMap<UnitType, ArrayList<IndianSettlement>>();
        RandomUtils.randomShuffle(logger, "Settlements", settlements, this.random);
        for (IndianSettlement is : settlements) {
            UnitType skill;
            ArrayList<IndianSettlement> isList;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            block19: for (Tile tile : is.getOwnedTiles()) {
                for (Tile t : tile.getSurroundingTiles(1)) {
                    if (t.getOwningSettlement() != null) continue;
                    tiles.add(tile);
                    continue block19;
                }
            }
            RandomUtils.randomShuffle(logger, "Settlement tiles", tiles, this.random);
            int minGrow = is.getType().getMinimumGrowth();
            int maxGrow = is.getType().getMaximumGrowth();
            if (maxGrow > minGrow) {
                Tile tile;
                for (int i = RandomUtils.randomInt(logger, "Gdiff", this.random, maxGrow - minGrow) + minGrow; i > 0 && (tile = this.findFreeNeighbouringTile(is, tiles)) != null; --i) {
                    tile.changeOwnership(is.getOwner(), is);
                    tiles.add(tile);
                }
            }
            if ((isList = (ArrayList<IndianSettlement>)skills.get(skill = is.getLearnableSkill())) == null) {
                isList = new ArrayList<IndianSettlement>();
                isList.add(is);
                skills.put(skill, isList);
                continue;
            }
            isList.add(is);
        }
        ArrayList<UnitType> expertsNeeded = new ArrayList<UnitType>();
        for (GoodsType goodsType : this.spec.getNewWorldGoodsTypeList()) {
            UnitType expert = this.spec.getExpertForProducing(goodsType);
            if (skills.containsKey(expert)) continue;
            expertsNeeded.add(expert);
        }
        ArrayList isList = new ArrayList(skills.values());
        Comparator<List<IndianSettlement>> listComparator = new Comparator<List<IndianSettlement>>(){

            @Override
            public int compare(List<IndianSettlement> l1, List<IndianSettlement> l2) {
                return l2.size() - l1.size();
            }
        };
        while (!expertsNeeded.isEmpty()) {
            UnitType neededSkill = (UnitType)expertsNeeded.remove(0);
            Collections.sort(isList, listComparator);
            List extras = (List)isList.remove(0);
            UnitType extraSkill = ((IndianSettlement)extras.get(0)).getLearnableSkill();
            ArrayList choices = new ArrayList();
            for (IndianSettlement is : extras) {
                IndianNationType nation = (IndianNationType)is.getOwner().getNationType();
                int cm = is.isCapital() ? 2 : 1;
                RandomChoice<IndianSettlement> rc = null;
                for (RandomChoice<UnitType> c : nation.generateSkillsForTile(is.getTile())) {
                    if (c.getObject() != neededSkill) continue;
                    rc = new RandomChoice<IndianSettlement>(is, c.getProbability() * cm);
                    break;
                }
                choices.add(rc != null ? rc : new RandomChoice<IndianSettlement>(is, 1));
            }
            if (!choices.isEmpty()) {
                IndianSettlement chose = (IndianSettlement)RandomChoice.getWeightedRandom(logger, "expert", choices, this.random);
                logger.finest("At " + chose.getName() + " replaced " + extraSkill + " (one of " + extras.size() + ")" + " by missing " + neededSkill);
                chose.setLearnableSkill(neededSkill);
                extras.remove(chose);
                isList.add(0, extras);
                ArrayList<IndianSettlement> neededList = new ArrayList<IndianSettlement>();
                neededList.add(chose);
                isList.add(neededList);
                continue;
            }
            logger.finest("Game is missing skill: " + neededSkill);
        }
        String msg = "Settlement skills:";
        for (List iss : isList) {
            if (iss.isEmpty()) {
                msg = msg + "  0 x <none>";
                continue;
            }
            msg = msg + "  " + iss.size() + " x " + ((IndianSettlement)iss.get(0)).getLearnableSkill();
        }
        logger.info(msg);
        logger.info("Created " + settlementsPlaced + " Indian settlements of maximum " + settlementsToPlace);
    }

    private boolean suitableForNativeSettlement(Tile tile) {
        if (!tile.getType().canSettle()) {
            return false;
        }
        int good = 0;
        int n = 0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType().canSettle()) {
                ++good;
            }
            ++n;
        }
        return good >= n / 2;
    }

    private Tile findFreeNeighbouringTile(IndianSettlement is, List<Tile> tiles) {
        for (Tile tile : tiles) {
            for (Map.Direction d : Map.Direction.getRandomDirections("freeTile", this.random)) {
                Tile t = tile.getNeighbourOrNull(d);
                if (t == null || t.getOwningSettlement() != null || !is.getOwner().canClaimForSettlement(t)) continue;
                return t;
            }
        }
        return null;
    }

    private Territory getClosestTerritory(Map map, Tile tile, List<Territory> territories) {
        Territory result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Territory territory : territories) {
            int distance = map.getDistance(tile, territory.getCenterTile(map));
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = territory;
        }
        return result;
    }

    private IndianSettlement placeCapital(Map map, Territory territory, int radius, List<Tile> tiles) {
        final Tile center = territory.getCenterTile(map);
        Collections.sort(tiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile t1, Tile t2) {
                return t1.getDistanceTo(center) - t2.getDistanceTo(center);
            }
        });
        for (Tile t : tiles) {
            if (territory.player.getClaimableTiles(t, radius).size() < (2 * radius + 1) * (2 * radius + 1) / 2) continue;
            String name = territory.region == null ? "default region" : territory.region.getNameKey();
            logger.fine("Placing the " + territory.player + " capital in region: " + name + " at tile: " + t);
            IndianSettlement is = this.placeIndianSettlement(territory.player, true, t, map);
            --territory.numberOfSettlements;
            territory.tile = t;
            return is;
        }
        return null;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Tile tile, Map map) {
        String name = capital ? player.getCapitalName(this.random) : player.getSettlementName(this.random);
        UnitType skill = this.generateSkillForLocation(map, tile, player.getNationType());
        ServerIndianSettlement settlement = new ServerIndianSettlement(map.getGame(), player, name, tile, capital, skill, null);
        player.addSettlement(settlement);
        logger.fine("Generated skill: " + settlement.getLearnableSkill());
        settlement.placeSettlement(true);
        settlement.addRandomGoods(this.random);
        settlement.addUnits(this.random);
        return settlement;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> randomChoice : skills) {
            scale.put(randomChoice.getObject().getExpertProduction(), 1);
        }
        for (Tile tile2 : tile.getSurroundingTiles(1)) {
            for (Map.Entry entry : scale.entrySet()) {
                GoodsType goodsType = (GoodsType)entry.getKey();
                scale.put(goodsType, (Integer)entry.getValue() + tile2.getPotentialProduction(goodsType, null));
            }
        }
        ArrayList scaledSkills = new ArrayList();
        for (RandomChoice<UnitType> skill3 : skills) {
            UnitType unitType = skill3.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill3.getProbability() * scaleValue));
        }
        UnitType unitType = (UnitType)RandomChoice.getWeightedRandom(null, null, scaledSkills, this.random);
        if (unitType == null) {
            List<UnitType> unitList = map.getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            return RandomUtils.getRandomMember(logger, "Scout", unitList, this.random);
        }
        return unitType;
    }

    /*
     * WARNING - void declaration
     */
    private void createEuropeanUnits(Map map, List<Player> players) {
        int width = map.getWidth();
        int height = map.getHeight();
        int poleDistance = (int)(0.3f * (float)height / 2.0f);
        ArrayList<Player> europeanPlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (player.isREF()) {
                int x = width - 2;
                int y = RandomUtils.randomInt(logger, "Pole", this.random, height - 2 * poleDistance) + poleDistance;
                player.setEntryLocation(map.getTile(x, y));
                continue;
            }
            if (!player.isEuropean()) continue;
            europeanPlayers.add(player);
            logger.finest("found European player " + player);
        }
        List<Map.Position> positions = this.generateStartingPositions(map, europeanPlayers);
        ArrayList<Tile> startingTiles = new ArrayList<Tile>();
        ArrayList<ServerUnit> carriers = new ArrayList<ServerUnit>();
        ArrayList<ServerUnit> passengers = new ArrayList<ServerUnit>();
        for (int index = 0; index < europeanPlayers.size(); ++index) {
            Player player = (Player)europeanPlayers.get(index);
            Map.Position position = positions.get(index);
            logger.fine("generating units for player " + player);
            carriers.clear();
            passengers.clear();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                UnitType type = startingUnit.getType(this.spec);
                Role role = startingUnit.getRole(this.spec);
                ServerUnit newUnit = new ServerUnit(this.game, null, player, type, role);
                newUnit.setName(player.getNameForUnit(type, this.random));
                if (newUnit.isNaval()) {
                    if (!newUnit.canCarryUnits()) continue;
                    newUnit.setState(Unit.UnitState.ACTIVE);
                    carriers.add(newUnit);
                    continue;
                }
                newUnit.setState(Unit.UnitState.SENTRY);
                passengers.add(newUnit);
            }
            boolean startAtSea = true;
            if (carriers.isEmpty()) {
                logger.warning("No carriers defined for player " + player);
                startAtSea = false;
            }
            Tile startTile = null;
            int x = position.getX();
            int y = position.getY();
            for (int i = 0; i < 2 * map.getHeight(); ++i) {
                int n = i % 2 == 0 ? i / 2 : -(1 + i / 2);
                int row = y + n;
                if (row < 0 || row >= map.getHeight() || (startTile = this.findTileFor(map, row, x, startAtSea)) == null) continue;
                if (startingTiles.contains(startTile)) {
                    startTile = null;
                    continue;
                }
                startingTiles.add(startTile);
                break;
            }
            if (startTile == null) {
                void var20_30;
                String err = "Failed to find start tile " + (startAtSea ? "at sea" : "on land") + " for player " + player + " from (" + x + "," + y + ")" + " avoiding:";
                for (Tile t : startingTiles) {
                    err = err + " " + t;
                }
                err = err + " with map: ";
                boolean bl = false;
                while (var20_30 < map.getWidth()) {
                    err = err + map.getTile((int)var20_30, y);
                    ++var20_30;
                }
                throw new RuntimeException(err);
            }
            player.setEntryLocation(startTile);
            if (startAtSea) {
                for (Unit unit : carriers) {
                    unit.setLocation(startTile);
                    ((ServerPlayer)player).exploreForUnit(unit);
                }
                block7: for (Unit unit : passengers) {
                    for (Unit unit2 : carriers) {
                        if (!unit2.canAdd(unit)) continue;
                        unit.setLocation(unit2);
                        continue block7;
                    }
                    unit.setLocation(player.getEurope());
                }
            } else {
                for (Unit unit : passengers) {
                    unit.setLocation(startTile);
                    ((ServerPlayer)player).exploreForUnit(unit);
                }
            }
            if (!FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.INIT)) continue;
            this.createDebugUnits(map, player, startTile);
            IntegerOption op = this.spec.getIntegerOption("model.option.startingMoney");
            if (op == null) continue;
            op.setValue(10000);
        }
    }

    private Tile findTileFor(Map map, int row, int start, boolean startAtSea) {
        Tile tile = null;
        Tile seas = null;
        int offset = start == 0 ? 1 : -1;
        for (int x = start; 0 <= x && x < map.getWidth(); x += offset) {
            tile = map.getTile(x, row);
            if (tile.isDirectlyHighSeasConnected()) {
                seas = tile;
                continue;
            }
            if (!tile.isLand()) continue;
            return startAtSea ? seas : tile;
        }
        logger.warning("No land in row " + row);
        return null;
    }

    private void createDebugUnits(Map map, Player player, Tile startTile) {
        UnitType unitType = this.spec.getUnitType("model.unit.galleon");
        ServerUnit unit4 = new ServerUnit(this.game, startTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.privateer");
        ServerUnit privateer = new ServerUnit(this.game, startTile, player, unitType);
        ((ServerPlayer)player).exploreForUnit(privateer);
        unitType = this.spec.getUnitType("model.unit.freeColonist");
        ServerUnit unit5 = new ServerUnit(this.game, unit4, player, unitType);
        unitType = this.spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit6 = new ServerUnit(this.game, unit4, player, unitType);
        unitType = this.spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit7 = new ServerUnit(this.game, unit4, player, unitType);
        Tile colonyTile = null;
        for (Tile tempTile : map.getCircleTiles(startTile, true, Integer.MAX_VALUE)) {
            if (tempTile.isPolar() || !player.canClaimToFoundSettlement(tempTile)) continue;
            colonyTile = tempTile;
            break;
        }
        if (colonyTile == null) {
            logger.warning("Could not find a debug colony site.");
            return;
        }
        for (TileType t : this.spec.getTileTypeList()) {
            if (t.isWater()) continue;
            colonyTile.setType(t);
            break;
        }
        unitType = this.spec.getUnitType("model.unit.expertFarmer");
        ServerUnit buildColonyUnit = new ServerUnit(this.game, colonyTile, player, unitType);
        String colonyName = Messages.message(player.getNationName()) + " Colony";
        ServerColony colony = new ServerColony(this.game, player, colonyName, colonyTile);
        player.addSettlement(colony);
        colony.placeSettlement(true);
        for (Tile tile : colonyTile.getSurroundingTiles(1)) {
            if (tile.hasSettlement() || tile.getOwner() != null && tile.getOwner().isEuropean()) continue;
            tile.changeOwnership(player, colony);
            if (!tile.hasLostCityRumour()) continue;
            tile.removeLostCityRumour();
        }
        buildColonyUnit.setLocation(colony);
        if (buildColonyUnit.getLocation() instanceof ColonyTile) {
            Tile ct = ((ColonyTile)buildColonyUnit.getLocation()).getWorkTile();
            for (TileType t : this.spec.getTileTypeList()) {
                if (t.isWater()) continue;
                ct.setType(t);
                TileImprovementType plowType = map.getSpecification().getTileImprovementType("model.improvement.plow");
                TileImprovement plow = new TileImprovement(this.game, ct, plowType);
                plow.setTurnsToComplete(0);
                ct.add(plow);
                break;
            }
        }
        BuildingType schoolType = this.spec.getBuildingType("model.building.schoolhouse");
        ServerBuilding schoolhouse = new ServerBuilding(this.game, colony, schoolType);
        colony.addBuilding(schoolhouse);
        unitType = this.spec.getUnitType("model.unit.masterCarpenter");
        ServerUnit carpenter = new ServerUnit(this.game, colonyTile, player, unitType);
        carpenter.setLocation(colony.getWorkLocationFor(carpenter, carpenter.getType().getExpertProduction()));
        unitType = this.spec.getUnitType("model.unit.elderStatesman");
        ServerUnit statesman = new ServerUnit(this.game, colonyTile, player, unitType);
        statesman.setLocation(colony.getWorkLocationFor(statesman, statesman.getType().getExpertProduction()));
        unitType = this.spec.getUnitType("model.unit.expertLumberJack");
        ServerUnit lumberjack = new ServerUnit(this.game, colony, player, unitType);
        if (lumberjack.getLocation() instanceof ColonyTile) {
            Tile lt = ((ColonyTile)lumberjack.getLocation()).getWorkTile();
            for (TileType t : this.spec.getTileTypeList()) {
                if (!t.isForested()) continue;
                lt.setType(t);
                break;
            }
            lumberjack.changeWorkType(lumberjack.getType().getExpertProduction());
        }
        unitType = this.spec.getUnitType("model.unit.seasonedScout");
        ServerUnit scout = new ServerUnit(this.game, colonyTile, player, unitType);
        ((ServerPlayer)player).exploreForUnit(scout);
        unitType = this.spec.getUnitType("model.unit.veteranSoldier");
        ServerUnit unit8 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit9 = new ServerUnit(this.game, colonyTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.artillery");
        ServerUnit unit10 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit11 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit12 = new ServerUnit(this.game, colonyTile, player, unitType);
        unitType = this.spec.getUnitType("model.unit.treasureTrain");
        ServerUnit unit13 = new ServerUnit(this.game, colonyTile, player, unitType);
        unit13.setTreasureAmount(10000);
        unitType = this.spec.getUnitType("model.unit.wagonTrain");
        ServerUnit unit14 = new ServerUnit(this.game, colonyTile, player, unitType);
        GoodsType cigarsType = this.spec.getGoodsType("model.goods.cigars");
        Goods cigards = new Goods(this.game, unit14, cigarsType, 5);
        unit14.add(cigards);
        unitType = this.spec.getUnitType("model.unit.jesuitMissionary");
        ServerUnit unit15 = new ServerUnit(this.game, colonyTile, player, unitType);
        ServerUnit unit16 = new ServerUnit(this.game, colonyTile, player, unitType);
        ((ServerPlayer)player).exploreForSettlement(colony);
    }

    private List<Map.Position> generateStartingPositions(Map map, List<Player> players) {
        int number = players.size();
        ArrayList<Map.Position> positions = new ArrayList<Map.Position>(number);
        if (number > 0) {
            int west = 0;
            int east = map.getWidth() - 1;
            switch (this.spec.getInteger("model.option.startingPositions")) {
                case 0: {
                    int distance = map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        positions.add(new Map.Position(east, row));
                        row += distance;
                    }
                    RandomUtils.randomShuffle(logger, "Classic starting positions", positions, this.random);
                    break;
                }
                case 1: {
                    int distance = 2 * map.getHeight() / number;
                    int row = distance / 2;
                    for (int index = 0; index < number; ++index) {
                        if (index % 2 == 0) {
                            positions.add(new Map.Position(east, row));
                            continue;
                        }
                        positions.add(new Map.Position(west, row));
                        row += distance;
                    }
                    RandomUtils.randomShuffle(logger, "Random starting positions", positions, this.random);
                    break;
                }
                case 2: {
                    for (Player player : players) {
                        Nation nation = player.getNation();
                        positions.add(new Map.Position(nation.startsOnEastCoast() ? east : west, map.getRow(nation.getPreferredLatitude())));
                    }
                    break;
                }
            }
        }
        return positions;
    }

    @Override
    public Map createEmptyMap(int width, int height) {
        this.recache(false);
        return new TerrainGenerator(this.game, null, this.random).createMap(new LandMap(width, height));
    }

    @Override
    public Map createMap() {
        this.recache(true);
        LandMap landMap = this.importGame != null ? new LandMap(this.importGame) : new LandMap(this.mapOptions, this.random);
        Map map = new TerrainGenerator(this.game, this.importGame, this.random).createMap(landMap);
        this.makeNativeSettlements(map);
        this.makeLostCityRumours(map);
        this.createEuropeanUnits(map, this.game.getLiveEuropeanPlayers(null));
        return map;
    }

    private static class Territory {
        public ServerRegion region;
        public Tile tile;
        public Player player;
        public int numberOfSettlements;

        public Territory(Player player, Tile tile) {
            this.player = player;
            this.tile = tile;
        }

        public Territory(Player player, ServerRegion region) {
            this.player = player;
            this.region = region;
        }

        public Tile getCenterTile(Map map) {
            if (this.tile != null) {
                return this.tile;
            }
            int[] xy = this.region.getCenter();
            return map.getTile(xy[0], xy[1]);
        }

        public String toString() {
            return this.player + " territory at " + this.region;
        }
    }
}

