/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.generator.RiverSection;
import net.sf.freecol.server.generator.SimpleMapGenerator;
import net.sf.freecol.server.model.ServerRegion;

public class River {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private TileImprovementType riverType;
    private Map.Direction direction;
    private net.sf.freecol.common.model.Map map;
    private List<RiverSection> sections = new ArrayList<RiverSection>();
    private River nextRiver = null;
    private ServerRegion region;
    private final Random random;
    private Map<Tile, River> riverMap;
    private boolean connected = false;

    public River(net.sf.freecol.common.model.Map map, Map<Tile, River> riverMap, ServerRegion region, Random random) {
        this.map = map;
        this.riverMap = riverMap;
        this.region = region;
        this.random = random;
        this.riverType = map.getSpecification().getTileImprovementType("model.improvement.river");
        this.direction = RandomUtils.getRandomMember(logger, "River", Map.Direction.longSides, random);
        logger.fine("Starting new river flowing " + (Object)((Object)this.direction));
    }

    public List<RiverSection> getSections() {
        return this.sections;
    }

    public int getLength() {
        return this.sections.size();
    }

    public RiverSection getLastSection() {
        return this.sections.get(this.sections.size() - 1);
    }

    public final ServerRegion getRegion() {
        return this.region;
    }

    public final void setRegion(ServerRegion newServerRegion) {
        this.region = newServerRegion;
    }

    public void add(Tile tile, Map.Direction direction) {
        this.sections.add(new RiverSection(tile, direction));
    }

    public void grow(RiverSection lastSection, Tile tile) {
        boolean found = false;
        for (RiverSection section : this.sections) {
            if (found) {
                section.grow();
                continue;
            }
            if (!section.getTile().equals(tile)) continue;
            section.setBranch(lastSection.direction.getReverseDirection(), lastSection.getSize());
            section.grow();
            found = true;
        }
        this.drawToMap(this.sections);
        if (this.nextRiver != null) {
            RiverSection section = this.sections.get(this.sections.size() - 1);
            Tile neighbor = section.getTile().getNeighbourOrNull(section.direction);
            this.nextRiver.grow(section, neighbor);
        }
    }

    public boolean isNextToSelf(Tile tile) {
        for (Map.Direction direction : Map.Direction.longSides) {
            Tile t = tile.getNeighbourOrNull(direction);
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isNextToWater(Tile tile) {
        for (Map.Direction direction : Map.Direction.longSides) {
            Tile t = tile.getNeighbourOrNull(direction);
            if (t == null || t.isLand() && !t.hasRiver()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Tile tile) {
        for (RiverSection rs : this.getSections()) {
            if (tile != rs.getTile()) continue;
            return true;
        }
        return false;
    }

    public boolean flowFromSource(Tile tile) {
        TileImprovementType riverType = this.map.getSpecification().getTileImprovementType("model.improvement.river");
        if (!riverType.isTileTypeAllowed(tile.getType())) {
            logger.fine("Tile (" + tile + ") can not have a river.");
            return false;
        }
        if (this.isNextToWater(tile)) {
            logger.fine("Tile (" + tile + ") is next to water.");
            return false;
        }
        logger.fine("Tile (" + tile + ") is suitable source.");
        return this.flow(tile);
    }

    private boolean flow(Tile source) {
        if (this.sections.size() % 2 == 0) {
            int length = DirectionChange.values().length;
            int index = RandomUtils.randomInt(logger, "Flow", this.random, length);
            DirectionChange change = DirectionChange.values()[index];
            this.direction = change.getNewDirection(this.direction);
            logger.fine("Direction is now " + (Object)((Object)this.direction));
        }
        for (DirectionChange change : DirectionChange.values()) {
            Map.Direction dir = change.getNewDirection(this.direction);
            Tile nextTile = source.getNeighbourOrNull(dir);
            if (nextTile == null) continue;
            if (!this.riverType.isTileTypeAllowed(nextTile.getType())) {
                logger.fine("Tile (" + nextTile + ") can not have a river.");
                continue;
            }
            if (this.contains(nextTile)) {
                logger.fine("Tile (" + nextTile + ") is already in river.");
                continue;
            }
            if (this.isNextToSelf(nextTile)) {
                logger.fine("Tile (" + nextTile + ") is next to the river.");
                continue;
            }
            for (DirectionChange change2 : DirectionChange.values()) {
                Map.Direction lastDir = change2.getNewDirection(dir);
                Tile t = nextTile.getNeighbourOrNull(lastDir);
                if (t == null || t.isLand() && !t.hasRiver()) continue;
                this.sections.add(new RiverSection(source, dir));
                RiverSection lastSection = new RiverSection(nextTile, lastDir);
                this.sections.add(lastSection);
                if (t.hasRiver() && t.isLand()) {
                    logger.fine("Tile (" + t + ") is next to another river.");
                    this.nextRiver = this.riverMap.get(t);
                    this.nextRiver.grow(lastSection, t);
                    this.connected |= this.nextRiver.connected;
                    if (this.getLength() < 10) {
                        this.region = this.nextRiver.region;
                    }
                    this.drawToMap(this.sections);
                } else {
                    logger.fine("Tile (" + t + ") is next to water.");
                    River someRiver = this.riverMap.get(t);
                    if (someRiver == null) {
                        this.sections.add(new RiverSection(t, lastDir.getReverseDirection()));
                        if (lastSection.getSize() < 3) {
                            this.createDelta(nextTile, lastDir, lastSection);
                        }
                    } else {
                        RiverSection waterSection = someRiver.getLastSection();
                        waterSection.setBranch(lastDir.getReverseDirection(), 1);
                    }
                    this.connected |= t.isHighSeasConnected();
                    this.drawToMap(this.sections);
                }
                return true;
            }
            logger.fine("Tile (" + nextTile + ") is suitable.");
            this.sections.add(new RiverSection(source, dir));
            return this.flow(nextTile);
        }
        this.sections = new ArrayList<RiverSection>();
        return false;
    }

    private void createDelta(Tile tile, Map.Direction direction, RiverSection section) {
        this.delta(tile, direction, section, DirectionChange.LEFT_TURN.getNewDirection(direction));
        this.delta(tile, direction, section, DirectionChange.RIGHT_TURN.getNewDirection(direction));
    }

    private void delta(Tile tile, Map.Direction direction, RiverSection section, Map.Direction d) {
        Tile t2;
        Tile t = tile.getNeighbourOrNull(d);
        if (!t.isLand()) {
            ArrayList<RiverSection> deltaSections = new ArrayList<RiverSection>();
            section.setBranch(d, 1);
            deltaSections.add(new RiverSection(tile, d.getReverseDirection()));
            this.drawToMap(deltaSections);
        } else if (this.riverType.isTileTypeAllowed(t.getType()) && !(t2 = t.getNeighbourOrNull(direction)).isLand() && RandomUtils.randomInt(logger, "Delta", this.random, 2) == 0) {
            ArrayList<RiverSection> deltaSections = new ArrayList<RiverSection>();
            section.setBranch(d, 1);
            RiverSection rs = new RiverSection(t, direction);
            rs.setBranch(d.getReverseDirection(), 1);
            deltaSections.add(rs);
            rs = new RiverSection(t2, direction.getReverseDirection());
            deltaSections.add(rs);
            this.drawToMap(deltaSections);
        }
    }

    private void drawToMap(List<RiverSection> sections) {
        RiverSection oldSection = null;
        for (RiverSection section : sections) {
            Tile tile;
            this.riverMap.put(section.getTile(), this);
            if (oldSection != null) {
                section.setBranch(oldSection.direction.getReverseDirection(), oldSection.getSize());
            }
            if (!(tile = section.getTile()).isLand()) continue;
            if (section.getSize() >= 3) {
                TileType greatRiver = this.map.getSpecification().getTileType("model.tile.greatRiver");
                tile.changeType(greatRiver);
                logger.fine("Added fjord (magnitude: " + section.getSize() + ") to tile: " + section.getTile());
            } else if (section.getSize() > 0) {
                String style = section.encodeStyle();
                tile.addRiver(section.getSize(), style);
                logger.fine("Added river(magnitude: " + section.getSize() + " style: " + style);
            }
            this.region.addTile(tile);
            oldSection = section;
        }
    }

    private static enum DirectionChange {
        STRAIGHT_AHEAD,
        RIGHT_TURN,
        LEFT_TURN;


        public Map.Direction getNewDirection(Map.Direction oldDirection) {
            switch (this) {
                case STRAIGHT_AHEAD: {
                    return oldDirection;
                }
                case RIGHT_TURN: {
                    switch (oldDirection) {
                        case NE: {
                            return Map.Direction.SE;
                        }
                        case SE: {
                            return Map.Direction.SW;
                        }
                        case SW: {
                            return Map.Direction.NW;
                        }
                        case NW: {
                            return Map.Direction.NE;
                        }
                    }
                    return oldDirection;
                }
                case LEFT_TURN: {
                    switch (oldDirection) {
                        case NE: {
                            return Map.Direction.NW;
                        }
                        case SE: {
                            return Map.Direction.NE;
                        }
                        case SW: {
                            return Map.Direction.SE;
                        }
                        case NW: {
                            return Map.Direction.SW;
                        }
                    }
                    return oldDirection;
                }
            }
            return oldDirection;
        }
    }
}

