/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.util.HashMap;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapLoader;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;

public class FreeColMapLoader
implements MapLoader {
    private final ServerGame importGame;

    public FreeColMapLoader(File file) throws Exception {
        this.importGame = FreeColServer.readGame(new FreeColSavegameFile(file), null, null);
    }

    @Override
    public Map.Layer loadMap(Game game, Map.Layer layer) {
        int y;
        int x;
        Map importMap = this.importGame.getMap();
        Map.Layer highestLayer = layer.compareTo(importMap.getLayer()) < 0 ? layer : importMap.getLayer();
        int width = importMap.getWidth();
        int height = importMap.getHeight();
        HashMap<String, ServerRegion> regions = new HashMap<String, ServerRegion>();
        Map map = new Map(game, width, height);
        if (highestLayer == Map.Layer.LAND) {
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    Tile t = new Tile(game, importMap.getTile(x, y).getType().isWater() ? TileType.WATER : TileType.LAND, x, y);
                    map.setTile(t, x, y);
                }
            }
        } else {
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    Tile template = importMap.getTile(x, y);
                    Tile tile = new Tile(game, null, x, y);
                    map.setTile(tile, x, y);
                    tile.setType(game.getSpecification().getTileType(template.getType().getId()));
                    tile.setMoveToEurope(template.getMoveToEurope());
                    if (highestLayer.compareTo(Map.Layer.REGIONS) < 0) continue;
                    Region region = template.getRegion();
                    if (region != null) {
                        ServerRegion ours = (ServerRegion)regions.get(region.getId());
                        if (ours == null) {
                            ours = new ServerRegion(game, region);
                            regions.put(region.getId(), ours);
                        }
                        tile.setRegion(ours);
                        ours.addTile(tile);
                    }
                    if (highestLayer.compareTo(Map.Layer.RIVERS) < 0) continue;
                    tile.setTileItemContainer(new TileItemContainer(game, tile, template.getTileItemContainer(), layer));
                    if (layer.compareTo(Map.Layer.NATIVES) < 0 || template.getOwner() == null) continue;
                    String nationId = template.getOwner().getNationId();
                    Player player = game.getPlayer(nationId);
                    if (player == null) {
                        Nation nation = game.getSpecification().getNation(nationId);
                        player = new ServerPlayer(game, false, nation, null, null);
                        game.addPlayer(player);
                    }
                    tile.setOwner(player);
                    if (template.getOwningSettlement() == null) continue;
                    IndianSettlement settlement = (IndianSettlement)template.getOwningSettlement();
                    tile.setOwningSettlement(new ServerIndianSettlement(game, player, tile, settlement));
                }
            }
        }
        for (Region region : regions.values()) {
            map.putRegion(region);
        }
        map.setLayer(highestLayer);
        game.setMap(map);
        return highestLayer;
    }

    @Override
    public Map.Layer getHighestLayer() {
        return Map.Layer.NATIVES;
    }
}

