/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.awt.Color;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NetworkRequestHandler;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameInputHandler
extends InputHandler {
    private static Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());
    private boolean launching = false;

    public PreGameInputHandler(FreeColServer freeColServer) {
        super(freeColServer);
        this.register("ready", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.ready(connection, element);
            }
        });
        this.register("requestLaunch", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                Element reply = PreGameInputHandler.this.requestLaunch(connection, element);
                if (reply != null) {
                    PreGameInputHandler.this.launching = false;
                }
                return reply;
            }
        });
        this.register("setColor", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.setColor(connection, element);
            }
        });
        this.register("setNation", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.setNation(connection, element);
            }
        });
        this.register("setNationType", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.setNationType(connection, element);
            }
        });
        this.register("setAvailable", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.setAvailable(connection, element);
            }
        });
        this.register("updateGameOptions", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateGameOptions(connection, element);
            }
        });
        this.register("updateMapGeneratorOptions", new NetworkRequestHandler(){

            @Override
            public Element handle(Connection connection, Element element) {
                return PreGameInputHandler.this.updateMapGeneratorOptions(connection, element);
            }
        });
    }

    @Override
    protected Element logout(Connection connection, Element element) {
        logger.info("Logout from: " + connection);
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        player.setConnected(false);
        this.getGame().removePlayer(player);
        this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("logout", "reason", "User has logged out.", "player", player.getId()), connection);
        try {
            this.getFreeColServer().updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        return null;
    }

    private Element ready(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            boolean ready = Boolean.parseBoolean(element.getAttribute("value"));
            player.setReady(ready);
            this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("playerReady", "player", player.getId(), "value", Boolean.toString(ready)), player.getConnection());
        } else {
            logger.warning("Ready from unknown connection.");
        }
        return null;
    }

    private Element requestLaunch(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer launchingPlayer = freeColServer.getPlayer(connection);
        if (!launchingPlayer.isAdmin()) {
            return DOMMessage.createError("server.onlyAdminCanLaunch", "Only the server admin can launch the game.");
        }
        if (this.launching) {
            return null;
        }
        this.launching = true;
        ArrayList<Nation> nations = new ArrayList<Nation>();
        for (Player player : this.getGame().getLivePlayers(null)) {
            Nation nation = this.getGame().getSpecification().getNation(player.getNationId());
            if (nations.contains(nation)) {
                return DOMMessage.createError("server.invalidPlayerNations", "All players need to pick a unique nation before the game can start.");
            }
            nations.add(nation);
        }
        if (!this.getGame().allPlayersReadyToLaunch()) {
            return DOMMessage.createError("server.notAllReady", "Not all players are ready to begin the game!");
        }
        try {
            ((PreGameController)freeColServer.getController()).startGame();
        }
        catch (FreeColException e) {
            return DOMMessage.createError("server.errorStartingGame", e.getMessage());
        }
        return null;
    }

    private Element setAvailable(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
            NationOptions.NationState state = Enum.valueOf(NationOptions.NationState.class, element.getAttribute("state"));
            this.getGame().getNationOptions().setNationState(nation, state);
            this.getFreeColServer().getServer().sendToAll(element, player.getConnection());
        } else {
            logger.warning("Available from unknown connection.");
        }
        return null;
    }

    private Element setColor(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Color color;
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
            String str = element.getAttribute("color");
            try {
                int rgb = Integer.decode(str);
                color = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                return DOMMessage.createError("server.badColor", "Invalid color: " + str);
            }
            nation.setColor(color);
            this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("updateColor", "nation", nation.getId(), "color", Integer.toString(color.getRGB())), player.getConnection());
        } else {
            logger.warning("setColor from unknown connection.");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element setNation(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("value"));
            if (this.getGame().getNationOptions().getNations().get(nation) != NationOptions.NationState.AVAILABLE) return DOMMessage.createError("server.badNation", "Selected non-selectable nation: " + nation);
            player.setNation(nation);
            this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("updateNation", "player", player.getId(), "value", nation.getId()), player.getConnection());
            return null;
        } else {
            logger.warning("setNation from unknown connection.");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element setNationType(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (player != null) {
            boolean ok;
            Specification spec = this.getGame().getSpecification();
            NationType nationType = spec.getNationType(element.getAttribute("value"));
            NationType fixedNationType = spec.getNation(player.getNationId()).getType();
            NationOptions.Advantages advantages = this.getGame().getNationOptions().getNationalAdvantages();
            switch (advantages) {
                case SELECTABLE: {
                    ok = true;
                    break;
                }
                case FIXED: {
                    ok = nationType.equals(fixedNationType);
                    break;
                }
                case NONE: {
                    ok = nationType == spec.getDefaultNationType();
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) return DOMMessage.createError("server.badNationType", "Selected non-selectable nation type: " + nationType);
            player.changeNationType(nationType);
            this.getFreeColServer().getServer().sendToAll(DOMMessage.createMessage("updateNationType", "player", player.getId(), "value", nationType.getId()), player.getConnection());
            return null;
        } else {
            logger.warning("setNationType from unknown connection.");
        }
        return null;
    }

    private Element updateGameOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
        Specification spec = this.getGame().getSpecification();
        OptionGroup gameOptions = spec.getGameOptions();
        Element child = (Element)element.getChildNodes().item(0);
        gameOptions.readFromXMLElement(child);
        spec.clean("update game options (server)");
        Element up = DOMMessage.createMessage("updateGameOptions", new String[0]);
        up.appendChild(gameOptions.toXMLElement(up.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(up, connection);
        return null;
    }

    private Element updateMapGeneratorOptions(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!player.isAdmin()) {
            throw new IllegalStateException("Not an admin");
        }
        Specification spec = this.getGame().getSpecification();
        OptionGroup mgo = spec.getMapGeneratorOptions();
        Element child = (Element)element.getChildNodes().item(0);
        mgo.readFromXMLElement(child);
        Element umge = DOMMessage.createMessage("updateMapGeneratorOptions", new String[0]);
        umge.appendChild(mgo.toXMLElement(umge.getOwnerDocument()));
        this.getFreeColServer().getServer().sendToAll(umge, connection);
        return null;
    }
}

