/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class ScoutingMission
extends Mission {
    private static final Logger logger = Logger.getLogger(ScoutingMission.class.getName());
    private static final String tag = "AI scout";
    private Location target;
    private static final String TARGET_TAG = "target";

    public ScoutingMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit, target);
    }

    public ScoutingMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private static boolean canScoutNatives(AIUnit aiUnit) {
        return aiUnit.getUnit().hasAbility("model.ability.speakWithChief");
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        return loc == null ? null : (ScoutingMission.invalidSettlementReason(aiUnit, loc.getSettlement()) == null ? loc.getSettlement() : (ScoutingMission.invalidTileReason(aiUnit, loc.getTile()) == null ? loc.getTile() : null));
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc;
        Location location = loc = path == null ? null : ScoutingMission.extractTarget(aiUnit, path);
        return loc instanceof Colony ? 12 / (path.getTotalTurns() + 1) : (loc instanceof IndianSettlement ? 2000 / (path.getTotalTurns() + 1) : (loc instanceof Tile ? (((Tile)loc).hasLostCityRumour() ? 1000 / (path.getTotalTurns() + 1) : 50 / (path.getTotalTurns() + 1)) : Integer.MIN_VALUE));
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value;
                Location loc = ScoutingMission.extractTarget(aiUnit, path);
                if ((loc instanceof IndianSettlement || loc instanceof Tile) && this.bestValue < (value = ScoutingMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(false, gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    public static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (ScoutingMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        Unit carrier = unit.getCarrier();
        GoalDecider gd = ScoutingMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidIllegal();
        return unit.search(start, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = ScoutingMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? ScoutingMission.extractTarget(aiUnit, path) : ScoutingMission.upLoc(ScoutingMission.findCircleTarget(aiUnit, ScoutingMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = ScoutingMission.invalidReason(aiUnit);
        return reason != null ? reason : (ScoutingMission.canScoutNatives(aiUnit) || aiUnit.equipForRole(aiUnit.getUnit().getSpecification().getScoutRole()) || aiUnit.getUnit().hasAbility("model.ability.expertScout") ? null : "unit-unprepared-to-SCOUT");
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = ScoutingMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!ScoutingMission.canScoutNatives(aiUnit) ? "unit-not-a-SCOUT" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return ScoutingMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidIndianSettlementReason(AIUnit aiUnit, IndianSettlement is) {
        Tension tension;
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        String reason = ScoutingMission.invalidTargetReason(is);
        return reason != null ? reason : (is.hasScouted(owner) ? "settlement-scouted" : ((tension = is.getAlarm(owner)) != null && tension.getValue() >= Tension.Level.HATEFUL.getLimit() ? "settlement-hateful" : null));
    }

    private static String invalidSettlementReason(AIUnit aiUnit, Settlement settlement) {
        return settlement instanceof Colony ? ScoutingMission.invalidColonyReason(aiUnit, (Colony)settlement) : (settlement instanceof IndianSettlement ? ScoutingMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)settlement) : "target-invalid");
    }

    private static String invalidTileReason(AIUnit aiUnit, Tile tile) {
        return tile == null ? "tile-null" : (tile.hasLostCityRumour() ? null : (!tile.isExploredBy(aiUnit.getUnit().getOwner()) ? null : "explored-tile-lacks-rumour"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return ScoutingMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = ScoutingMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Settlement ? ScoutingMission.invalidSettlementReason(aiUnit, (Settlement)loc) : (loc instanceof Tile ? ScoutingMission.invalidTileReason(aiUnit, (Tile)loc) : "target-invalid"));
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement || target instanceof Tile) {
            this.target = target;
        }
    }

    @Override
    public Location findTarget() {
        return ScoutingMission.findTarget(this.getAIUnit(), 20, true);
    }

    @Override
    public String invalidReason() {
        return ScoutingMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (ScoutingMission.isTargetReason(reason)) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: {
                return this;
            }
            case MOVE_NO_TILE: {
                this.moveRandomly(tag, null);
                return this.lbDodge(lb);
            }
            case ATTACK_UNIT: {
                this.moveRandomly(tag, unit.getTile().getDirection(this.getTarget().getTile()));
                return this.lbDodge(lb);
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                assert (d != null);
                if (AIMessage.askScoutSpeakToChief(aiUnit, d)) {
                    this.lbDone(lb, true, "speak-with-chief at ", this.getTarget());
                    break;
                }
                this.lbFail(lb, true, "unexpected failure to speak at ", this.getTarget());
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                assert (d != null);
                if (AIMessage.askMove(aiUnit, d)) {
                    this.lbDone(lb, true, "explore at ", this.getTarget());
                    break;
                }
                this.lbFail(lb, true, "unexpected failure at ", this.getTarget());
                break;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        if (unit.isDisposed()) {
            return this;
        }
        this.lbAt(lb);
        Location completed = this.getTarget();
        Location newTarget = ScoutingMission.findTarget(aiUnit, 20, false);
        if (newTarget == null || completed instanceof Colony && newTarget == completed) {
            if (completed instanceof Colony && ScoutingMission.canScoutNatives(aiUnit)) {
                aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            }
            return this.lbFail(lb, false, ", found no targets");
        }
        this.setTarget(newTarget);
        return this.lbRetarget(lb);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return ScoutingMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "scoutingMission";
    }
}

