/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class IndianDemandMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianDemandMission.class.getName());
    private static final String tag = "AI native demander";
    private Colony colony;
    private boolean demanded;
    private static final String COLONY_TAG = "colony";
    private static final String DEMANDED_TAG = "demanded";

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit, target);
        this.demanded = false;
    }

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private boolean hasTribute() {
        return IndianDemandMission.hasTribute(this.getAIUnit());
    }

    private static boolean hasTribute(AIUnit aiUnit) {
        return aiUnit.getUnit().hasGoodsCargo();
    }

    public Goods selectGoods(Colony target) {
        int goodsValue;
        int value;
        Market market;
        Specification spec = this.getSpecification();
        Tension.Level tension = this.getUnit().getOwner().getTension(target.getOwner()).getLevel();
        int dx = spec.getInteger("model.option.nativeDemands") + 1;
        GoodsType food = spec.getPrimaryFoodType();
        AbstractGoods goods = null;
        if (tension.compareTo(Tension.Level.CONTENT) <= 0 && target.getGoodsCount(food) >= 100) {
            return new Goods(this.getGame(), target, food, this.capAmount(target.getGoodsCount(food), dx));
        }
        if (tension.compareTo(Tension.Level.DISPLEASED) <= 0) {
            market = target.getOwner().getMarket();
            value = 0;
            for (Goods currentGoods : target.getCompactGoods()) {
                goodsValue = market.getSalePrice(currentGoods);
                if (currentGoods.getType().isFoodType() || currentGoods.getType().isMilitaryGoods() || goodsValue <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
            if (goods != null) {
                goods.setAmount(this.capAmount(goods.getAmount(), dx));
                return goods;
            }
        } else {
            int amount;
            for (GoodsType preferred : spec.getGoodsTypeList()) {
                if (!preferred.isMilitaryGoods() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : spec.getGoodsTypeList()) {
                if (!preferred.isBuildingMaterial() || !preferred.isStorable() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : spec.getGoodsTypeList()) {
                if (!preferred.isTradeGoods() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : spec.getGoodsTypeList()) {
                if (!preferred.isRefined() || !preferred.isStorable() || (amount = target.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
        }
        market = target.getOwner().getMarket();
        value = 0;
        for (Goods currentGoods : target.getCompactGoods()) {
            goodsValue = market.getSalePrice(currentGoods);
            if (goodsValue <= value) continue;
            value = goodsValue;
            goods = currentGoods;
        }
        if (goods != null) {
            goods.setAmount(this.capAmount(goods.getAmount(), dx));
        }
        return goods;
    }

    private int capAmount(int amount, int difficulty) {
        return Math.min(Math.max(amount * difficulty / 6, 30), 100);
    }

    private static IndianSettlement getHome(AIUnit aiUnit) {
        return aiUnit.getUnit().getHomeIndianSettlement();
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        IndianSettlement home;
        String reason = IndianDemandMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((home = IndianDemandMission.getHome(aiUnit)) == null || home.isDisposed() ? "home-destroyed" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = IndianDemandMission.invalidTargetReason(colony);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Player targetPlayer = colony.getOwner();
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case PEACE: 
            case ALLIANCE: {
                return "bad-stance";
            }
            case WAR: 
            case CEASE_FIRE: {
                Tension tension = unit.getHomeIndianSettlement().getAlarm(targetPlayer);
                if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) > 0) break;
                return "happy";
            }
        }
        return null;
    }

    public static String invalidReason(AIUnit aiUnit) {
        return IndianDemandMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = IndianDemandMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? IndianDemandMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof IndianSettlement ? IndianDemandMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : "target-invalid"));
    }

    @Override
    public Location getTransportDestination() {
        return null;
    }

    @Override
    public Location getTarget() {
        return this.demanded ? this.getUnit().getHomeIndianSettlement() : this.colony;
    }

    @Override
    public void setTarget(Location target) {
        if (target instanceof Colony) {
            this.colony = (Colony)target;
        }
    }

    @Override
    public Location findTarget() {
        return this.getTarget();
    }

    @Override
    public String invalidReason() {
        return IndianDemandMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        Unit.MoveType mt;
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        IndianSettlement is = unit.getHomeIndianSettlement();
        block11: while (!this.demanded) {
            int amount;
            Map.Direction d;
            mt = this.travelToTarget(this.getTarget(), null, lb);
            switch (mt) {
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_NO_REPAIR: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_TILE: {
                    return this;
                }
                case ATTACK_SETTLEMENT: {
                    d = unit.getTile().getDirection(this.getTarget().getTile());
                    if (d != null) break;
                }
                case ATTACK_UNIT: {
                    Location blocker = IndianDemandMission.resolveBlockage(aiUnit, this.getTarget());
                    if (blocker == null) {
                        this.moveRandomly(tag, null);
                        continue block11;
                    }
                    d = unit.getTile().getDirection(blocker.getTile());
                    if (!AIMessage.askAttack(aiUnit, d)) continue block11;
                    return this.lbAttack(lb, blocker);
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            this.lbAt(lb);
            Colony colony = (Colony)this.getTarget();
            Player enemy = colony.getOwner();
            Goods goods = this.selectGoods(colony);
            GoodsType type = goods == null ? null : goods.getType();
            int n = amount = goods == null ? 0 : goods.getAmount();
            if (goods == null) {
                if (!enemy.checkGold(1)) {
                    return this.lbDone(lb, false, "empty handed");
                }
                amount = enemy.getGold() / 20;
                if (amount == 0) {
                    amount = enemy.getGold();
                }
            }
            this.demanded = AIMessage.askIndianDemand(aiUnit, colony, type, amount);
            if (this.demanded && (goods == null || this.hasTribute())) {
                if (goods == null) {
                    return this.lbDone(lb, false, "accepted tribute ", amount, " gold");
                }
                lb.add(", accepted tribute ", goods);
                return this.lbRetarget(lb);
            }
            int unitTension = is == null ? 0 : is.getAlarm(enemy).getValue();
            int tension = Math.max(unitTension, unit.getOwner().getTension(enemy).getValue());
            d = unit.getTile().getDirection(colony.getTile());
            if (tension >= Tension.Level.CONTENT.getLimit() && d != null && AIMessage.askAttack(aiUnit, d)) {
                this.lbAttack(lb, colony);
            }
            return this.lbDone(lb, false, "refused at ", colony);
        }
        mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_TILE: {
                return this;
            }
            case MOVE: {
                break;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        GoodsContainer container = unit.getGoodsContainer();
        for (Goods goods : container.getCompactGoods()) {
            Goods tribute = container.removeGoods(goods.getType());
            is.addGoods(tribute);
        }
        return this.lbDone(lb, false, "unloaded tribute");
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.colony != null) {
            xw.writeAttribute(COLONY_TAG, this.colony.getId());
        }
        xw.writeAttribute(DEMANDED_TAG, this.demanded);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.getAttribute(this.getGame(), COLONY_TAG, Colony.class, (Colony)null);
        this.demanded = xr.getAttribute(DEMANDED_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return IndianDemandMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "indianDemandMission";
    }
}

