/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class GoodsWish
extends Wish {
    private static final Logger logger = Logger.getLogger(GoodsWish.class.getName());
    private GoodsType goodsType;
    private int amountRequested;
    private static final String AMOUNT_REQUESTED_TAG = "amountRequested";
    private static final String GOODS_TYPE_TAG = "goodsType";
    private static final String TRANSPORTABLE_TAG = "transportable";

    public GoodsWish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.goodsType = null;
        this.amountRequested = -1;
    }

    public GoodsWish(AIMain aiMain, Location destination, int value, int amountRequested, GoodsType goodsType) {
        this(aiMain, GoodsWish.getXMLElementTagName() + ":" + aiMain.getNextId());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.goodsType = goodsType;
        this.amountRequested = amountRequested;
        this.uninitialized = false;
    }

    public GoodsWish(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.goodsType == null;
    }

    public GoodsWish(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.goodsType == null;
    }

    public void update(GoodsType goodsType, int amount, int value) {
        this.goodsType = goodsType;
        this.amountRequested = amount;
        this.setValue(value);
        if (this.transportable != null) {
            this.transportable.incrementTransportPriority();
        }
    }

    @Override
    public boolean shouldBeStored() {
        return true;
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public int getGoodsAmount() {
        return this.amountRequested;
    }

    public boolean satisfiedBy(Goods goods) {
        return goods.getType() == this.goodsType && goods.getAmount() >= this.amountRequested;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.goodsType == null || this.amountRequested <= 0) {
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(GOODS_TYPE_TAG, this.goodsType);
        xw.writeAttribute(AMOUNT_REQUESTED_TAG, this.amountRequested);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Specification spec = this.getSpecification();
        this.transportable = xr.hasAttribute(TRANSPORTABLE_TAG) ? xr.makeAIObject(aiMain, TRANSPORTABLE_TAG, AIGoods.class, null, true) : null;
        this.goodsType = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
        this.amountRequested = xr.getAttribute(AMOUNT_REQUESTED_TAG, 100);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.goodsType != null && this.amountRequested > 0) {
            this.uninitialized = false;
        }
    }

    @Override
    public String toString() {
        LogBuilder lb = new LogBuilder(32);
        lb.add("[", this.getId(), " ", this.amountRequested, " ", this.goodsType == null ? "null" : this.goodsType.getSuffix(), " -> ", this.destination, " (", this.getValue(), ")]");
        return lb.toString();
    }

    @Override
    public String getXMLTagName() {
        return GoodsWish.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goodsWish";
    }
}

