/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AIInGameInputHandler
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(AIInGameInputHandler.class.getName());
    private final ServerPlayer serverPlayer;
    private final FreeColServer freeColServer;
    private final AIMain aiMain;

    public AIInGameInputHandler(FreeColServer freeColServer, ServerPlayer me, AIMain aiMain) {
        if (freeColServer == null) {
            throw new NullPointerException("freeColServer == null");
        }
        if (me == null) {
            throw new NullPointerException("me == null");
        }
        if (!me.isAI()) {
            throw new RuntimeException("Applying AIInGameInputHandler to a non-AI player!");
        }
        if (aiMain == null) {
            throw new NullPointerException("aiMain == null");
        }
        this.freeColServer = freeColServer;
        this.serverPlayer = me;
        this.aiMain = aiMain;
    }

    private AIPlayer getAIPlayer() {
        return this.aiMain.getAIPlayer(this.serverPlayer);
    }

    private AIUnit getAIUnit(Unit unit) {
        return this.aiMain.getAIUnit(unit);
    }

    @Override
    public synchronized Element handle(Connection connection, Element element) {
        if (element == null) {
            return null;
        }
        String tag = element.getTagName();
        Element reply = null;
        try {
            if ("reconnect".equals(tag)) {
                logger.warning("Reconnect on illegal operation, refer to any previous error message.");
            } else if ("chooseFoundingFather".equals(tag)) {
                reply = this.chooseFoundingFather(connection, element);
            } else if ("diplomacy".equals(tag)) {
                reply = this.diplomacy(connection, element);
            } else if ("firstContact".equals(tag)) {
                reply = this.firstContact(connection, element);
            } else if ("fountainOfYouth".equals(tag)) {
                reply = this.fountainOfYouth(connection, element);
            } else if ("indianDemand".equals(tag)) {
                reply = this.indianDemand(connection, element);
            } else if ("lootCargo".equals(tag)) {
                reply = this.lootCargo(connection, element);
            } else if ("monarchAction".equals(tag)) {
                reply = this.monarchAction(connection, element);
            } else if ("multiple".equals(tag)) {
                reply = this.multiple(connection, element);
            } else if ("newLandName".equals(tag)) {
                reply = this.newLandName(connection, element);
            } else if ("newRegionName".equals(tag)) {
                reply = this.newRegionName(connection, element);
            } else if ("setCurrentPlayer".equals(tag)) {
                reply = this.setCurrentPlayer(connection, element);
            } else if (!("addObject".equals(tag) || "addPlayer".equals(tag) || "animateMove".equals(tag) || "animateAttack".equals(tag) || "chat".equals(tag) || "disconnect".equals(tag) || "error".equals(tag) || "featureChange".equals(tag) || "gameEnded".equals(tag) || "logout".equals(tag) || "newTurn".equals(tag) || "remove".equals(tag) || "removeGoods".equals(tag) || "setAI".equals(tag) || "setDead".equals(tag) || "setStance".equals(tag) || "startGame".equals(tag) || "update".equals(tag) || "updateGame".equals(tag))) {
                logger.warning("Unknown message type: " + tag);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "AI input handler for " + this.serverPlayer + " caught error handling " + tag, e);
        }
        return reply;
    }

    private Element chooseFoundingFather(Connection connection, Element element) {
        Game game = this.aiMain.getGame();
        AIPlayer aiPlayer = this.getAIPlayer();
        ChooseFoundingFatherMessage message = new ChooseFoundingFatherMessage(game, element);
        FoundingFather ff = aiPlayer.selectFoundingFather(message.getFathers());
        logger.finest(aiPlayer.getId() + " chose founding father: " + ff);
        if (ff != null) {
            message.setFather(ff);
        }
        return message.toXMLElement();
    }

    private Element diplomacy(Connection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        DiplomacyMessage message = new DiplomacyMessage(game, element);
        DiplomaticTrade agreement = message.getAgreement();
        StringBuilder sb = new StringBuilder(256);
        sb.append("AI Diplomacy: ").append(agreement);
        DiplomaticTrade.TradeStatus status = this.getAIPlayer().acceptDiplomaticTrade(agreement);
        agreement.setStatus(status);
        sb.append(" -> ").append(agreement);
        logger.fine(sb.toString());
        return new DiplomacyMessage(message.getOurFCGO(game), message.getOtherFCGO(game), agreement).toXMLElement();
    }

    private Element firstContact(Connection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        return new FirstContactMessage(game, element).setResult(true).toXMLElement();
    }

    private Element fountainOfYouth(Connection connection, Element element) {
        int n;
        AIPlayer aiPlayer = this.getAIPlayer();
        String migrants = element.getAttribute("migrants");
        try {
            n = Integer.parseInt(migrants);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        for (int i = 0; i < n; ++i) {
            AIMessage.askEmigrate(aiPlayer, 0);
        }
        return null;
    }

    private Element indianDemand(Connection connection, Element element) {
        Game game = this.aiMain.getGame();
        AIPlayer aiPlayer = this.getAIPlayer();
        IndianDemandMessage message = new IndianDemandMessage(game, element);
        Unit unit = message.getUnit(game);
        Colony colony = message.getColony(game);
        GoodsType type = message.getType(game);
        int amount = message.getAmount();
        boolean accept = aiPlayer.indianDemand(unit, colony, type, amount);
        message.setResult(accept);
        logger.finest("AI handling native demand by " + unit + " at " + colony.getName() + " result: " + accept);
        return message.toXMLElement();
    }

    private Element lootCargo(Connection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        final Market market = this.serverPlayer.getMarket();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        List<Goods> goods = message.getGoods();
        Collections.sort(goods, new Comparator<Goods>(){

            @Override
            public int compare(Goods g1, Goods g2) {
                int p1 = market.getPaidForSale(g1.getType()) * g1.getAmount();
                int p2 = market.getPaidForSale(g2.getType()) * g2.getAmount();
                return p2 - p1;
            }
        });
        ArrayList<Goods> loot = new ArrayList<Goods>();
        int space = unit.getSpaceLeft();
        while (!goods.isEmpty()) {
            Goods g = goods.remove(0);
            if (g.getSpaceTaken() > space) continue;
            loot.add(g);
            space -= g.getSpaceTaken();
        }
        AIMessage.askLoot(this.getAIUnit(unit), message.getDefenderId(), loot);
        return null;
    }

    private Element monarchAction(Connection connection, Element element) {
        Game game = this.aiMain.getGame();
        MonarchActionMessage message = new MonarchActionMessage(game, element);
        Monarch.MonarchAction action = message.getAction();
        switch (action) {
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                boolean accept = this.getAIPlayer().acceptTax(message.getTax());
                message.setResult(accept);
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                boolean accept = this.getAIPlayer().acceptMercenaries();
                message.setResult(accept);
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            default: {
                logger.finest("AI player ignoring monarch action " + (Object)((Object)action));
                return null;
            }
        }
        return message.toXMLElement();
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                Element reply = this.handle(connection, (Element)nodes.item(i));
                if (reply == null) continue;
                results.add(reply);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Caught crash in multiple item " + i + ", continuing.", e);
            }
        }
        return DOMMessage.collapseElements(results);
    }

    private Element newLandName(Connection connection, Element element) {
        return new NewLandNameMessage(this.freeColServer.getGame(), element).toXMLElement();
    }

    private Element newRegionName(Connection connection, Element element) {
        return new NewRegionNameMessage(this.freeColServer.getGame(), element).toXMLElement();
    }

    private Element setCurrentPlayer(Connection connection, Element element) {
        String str;
        ServerGame game = this.freeColServer.getGame();
        Player currentPlayer = game.getFreeColGameObject(str = element.getAttribute("player"), Player.class);
        if (currentPlayer != null && this.serverPlayer.getId().equals(currentPlayer.getId())) {
            logger.finest("Starting new Thread for " + this.serverPlayer.getName());
            String nam = "FreeColServer:AIPlayer (" + this.serverPlayer.getName() + ")";
            new Thread(nam){

                @Override
                public void run() {
                    try {
                        AIInGameInputHandler.this.getAIPlayer().startWorking();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "AI player failed while working!", e);
                    }
                    AIMessage.askEndTurn(AIInGameInputHandler.this.getAIPlayer());
                }
            }.start();
        }
        return null;
    }
}

