/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    @SafeVarargs
    public static <T> Set<T> makeUnmodifiableSet(T ... members) {
        HashSet<T> tmp = new HashSet<T>();
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableSet(tmp);
    }

    @SafeVarargs
    public static <T> List<T> makeUnmodifiableList(T ... members) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableList(tmp);
    }

    public static <T, K> void appendToMapList(Map<K, List<T>> map, K key, T value) {
        List<T> l = map.get(key);
        if (l == null) {
            l = new ArrayList<T>();
            l.add(value);
            map.put(key, l);
        } else if (!l.contains(value)) {
            l.add(value);
        }
    }

    public static <K> int incrementMapCount(Map<K, Integer> map, K key) {
        int count = map.containsKey(key) ? map.get(key) : 0;
        map.put(key, count + 1);
        return count + 1;
    }

    public static <T> Iterable<List<T>> getPermutations(final List<T> l) {
        if (l == null) {
            return null;
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    private final List<T> original;
                    private final int n;
                    private final int np;
                    private int index;
                    {
                        this.original = new ArrayList(l);
                        this.n = l.size();
                        this.np = this.factorial(this.n);
                        this.index = 0;
                    }

                    private int factorial(int n) {
                        int total = n;
                        while (--n > 1) {
                            total *= n;
                        }
                        return total;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.np;
                    }

                    @Override
                    public List<T> next() {
                        ArrayList pick = new ArrayList(this.original);
                        ArrayList result = new ArrayList();
                        int current = this.index++;
                        int divisor = this.np;
                        for (int i = this.n; i > 0; --i) {
                            int j = current / (divisor /= i);
                            result.add(pick.remove(j));
                            current -= j * divisor;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("remove() not implemented");
                    }
                };
            }
        };
    }

    public static <T> boolean allSame(Collection<T> collection) {
        Object datum = null;
        boolean first = true;
        for (T t : collection) {
            if (first) {
                datum = t;
            } else if (t != datum) {
                return false;
            }
            first = false;
        }
        return true;
    }
}

