/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFile;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.resources.VideoResource;

public class ResourceManager {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private static ResourceMapping baseMapping;
    private static ResourceMapping tcMapping;
    private static ResourceMapping campaignMapping;
    private static ResourceMapping scenarioMapping;
    private static ResourceMapping gameMapping;
    private static List<ResourceMapping> modMappings;
    private static ResourceMapping mergedContainer;
    private static volatile Thread preloadThread;
    private static volatile boolean dirty;

    public static void setBaseMapping(ResourceMapping mapping) {
        baseMapping = mapping;
        dirty = true;
    }

    public static void setTcMapping(ResourceMapping mapping) {
        tcMapping = mapping;
        dirty = true;
    }

    public static void setModMappings(List<ResourceMapping> mappings) {
        modMappings = mappings;
        dirty = true;
    }

    public static void setCampaignMapping(ResourceMapping mapping) {
        campaignMapping = mapping;
        dirty = true;
    }

    public static void setScenarioMapping(ResourceMapping mapping) {
        scenarioMapping = mapping;
        dirty = true;
    }

    public static void setGameMapping(ResourceMapping mapping) {
        gameMapping = mapping;
        dirty = true;
    }

    public static synchronized void addGameMapping(ResourceMapping mapping) {
        if (gameMapping == null) {
            gameMapping = new ResourceMapping();
        }
        gameMapping.addAll(mapping);
        dirty = true;
    }

    public static synchronized void addGameMapping(String key, Resource resource) {
        if (gameMapping == null) {
            gameMapping = new ResourceMapping();
        }
        gameMapping.add(key, resource);
        if (!dirty) {
            mergedContainer.add(key, resource);
        }
    }

    public static void preload() {
        dirty = true;
        ResourceManager.updateIfDirty();
    }

    private static void startBackgroundPreloading() {
        if ("true".equals(System.getProperty("java.awt.headless", "false"))) {
            return;
        }
        preloadThread = new Thread("FreeColClient:-Resource loader"){

            @Override
            public void run() {
                LinkedList<Resource> resources = new LinkedList<Resource>(ResourceManager.getResources().values());
                int n = 0;
                for (Resource r : resources) {
                    if (preloadThread != this) {
                        return;
                    }
                    r.preload();
                    ++n;
                }
                logger.info("Background thread preloaded " + n + " resources.");
            }
        };
        preloadThread.setPriority(2);
        preloadThread.start();
    }

    private static void updateIfDirty() {
        if (dirty) {
            dirty = false;
            preloadThread = null;
            ResourceManager.createMergedContainer();
            ResourceManager.startBackgroundPreloading();
        }
    }

    public static synchronized boolean hasResource(String resourceId) {
        return mergedContainer.containsKey(resourceId);
    }

    private static synchronized Resource getResource(String resourceId) {
        return mergedContainer.get(resourceId);
    }

    public static synchronized Map<String, Resource> getResources() {
        return mergedContainer.getResources();
    }

    public static synchronized List<String> getKeys(String prefix) {
        return mergedContainer.getKeys(prefix);
    }

    private static synchronized void createMergedContainer() {
        ResourceMapping mc = new ResourceMapping();
        mc.addAll(baseMapping);
        mc.addAll(tcMapping);
        mc.addAll(campaignMapping);
        mc.addAll(scenarioMapping);
        for (ResourceMapping rm : modMappings) {
            mc.addAll(rm);
        }
        mc.addAll(gameMapping);
        mergedContainer = mc;
    }

    public static <T> T getResource(String resourceId, Class<T> type) {
        ResourceManager.updateIfDirty();
        Resource r = ResourceManager.getResource(resourceId);
        if (r == null) {
            if (!resourceId.startsWith("dynamic.")) {
                logger.finest("getResource(" + resourceId + ", " + type.getName() + ") failed");
            }
            return null;
        }
        if (!type.isInstance(r)) {
            logger.warning("getResource(" + resourceId + ", " + type.getName() + ") -> " + r.getClass().getName());
            return null;
        }
        return type.cast(r);
    }

    public static SimpleZippedAnimation getSimpleZippedAnimation(String resource) {
        SZAResource r = ResourceManager.getResource(resource, SZAResource.class);
        return r != null ? r.getSimpleZippedAnimation() : null;
    }

    public static Video getVideo(String resource) {
        VideoResource r = ResourceManager.getResource(resource, VideoResource.class);
        return r != null ? r.getVideo() : null;
    }

    public static SimpleZippedAnimation getSimpleZippedAnimation(String resource, double scale) {
        SZAResource r = ResourceManager.getResource(resource, SZAResource.class);
        return r != null ? r.getSimpleZippedAnimation(scale) : null;
    }

    public static Image getImage(String resource) {
        ImageResource r = ResourceManager.getResource(resource, ImageResource.class);
        return r != null ? r.getImage() : null;
    }

    public static Image getImage(String resource, double scale) {
        ImageResource r = ResourceManager.getResource(resource, ImageResource.class);
        return r != null ? r.getImage(scale) : null;
    }

    public static Image getImage(String resource, Dimension size) {
        ImageResource r = ResourceManager.getResource(resource, ImageResource.class);
        return r != null ? r.getImage(size) : null;
    }

    public static Image getGrayscaleImage(String resource, Dimension size) {
        ImageResource r = ResourceManager.getResource(resource, ImageResource.class);
        return r != null ? r.getGrayscaleImage(size) : null;
    }

    public static Image getGrayscaleImage(String resource, double scale) {
        ImageResource r = ResourceManager.getResource(resource, ImageResource.class);
        return r != null ? r.getGrayscaleImage(scale) : null;
    }

    public static ImageIcon getImageIcon(String resource) {
        Image im = ResourceManager.getImage(resource);
        return im != null ? new ImageIcon(im) : null;
    }

    public static Color getColor(String resource) {
        ColorResource r = ResourceManager.getResource(resource, ColorResource.class);
        return r != null ? r.getColor() : null;
    }

    public static Font getFont(String resource) {
        FontResource r = ResourceManager.getResource(resource, FontResource.class);
        if (r == null) {
            return FontResource.getEmergencyFont();
        }
        return r.getFont();
    }

    public static Font getFont(String resource, int style) {
        Font font = ResourceManager.getFont(resource);
        return font.deriveFont(style);
    }

    public static Font getFont(String resource, float size) {
        Font font = ResourceManager.getFont(resource);
        return font.deriveFont(size);
    }

    public static Font getFont(String resource, int style, float size) {
        Font font = ResourceManager.getFont(resource);
        return font.deriveFont(style, size);
    }

    public static FAFile getFAFile(String resource) {
        FAFileResource r = ResourceManager.getResource(resource, FAFileResource.class);
        return r == null ? null : r.getFAFile();
    }

    public static File getAudio(String resource) {
        AudioResource r = ResourceManager.getResource(resource, AudioResource.class);
        return r == null ? null : r.getAudio();
    }

    static {
        modMappings = new LinkedList<ResourceMapping>();
        preloadThread = null;
        dirty = false;
    }
}

