/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.Utils;

public class TextOption
extends AbstractOption<String> {
    private static Logger logger = Logger.getLogger(TextOption.class.getName());
    private String value;
    private static final String CHOICE_TAG = "choice";

    public TextOption(Specification specification) {
        super(specification);
    }

    public TextOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public TextOption clone() {
        TextOption result = new TextOption(this.getId(), this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.isDefined && !Utils.equals(value, oldValue)) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(valueString != null ? valueString : defaultValueString);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" value=").append(this.value);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TextOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "textOption";
    }
}

