/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.TextOption;

public class OptionGroup
extends AbstractOption<OptionGroup> {
    private static Logger logger = Logger.getLogger(OptionGroup.class.getName());
    private final List<Option> options = new ArrayList<Option>();
    private final Map<String, Option> optionMap = new HashMap<String, Option>();
    private boolean editable = true;
    private static final String EDITABLE_TAG = "editable";

    public OptionGroup(String id) {
        super(id);
    }

    public OptionGroup(Specification specification) {
        super(specification);
    }

    public OptionGroup(String id, Specification specification) {
        super(id, specification);
    }

    public OptionGroup(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getName() {
        return Messages.getName(this.getId());
    }

    public String getShortDescription() {
        return Messages.getShortDescription(this.getId());
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String id) {
        return this.optionMap.get(id);
    }

    public boolean hasOptionGroup() {
        for (Option o : this.options) {
            if (!(o instanceof OptionGroup)) continue;
            return true;
        }
        return false;
    }

    public void add(Option option) {
        String id = option.getId();
        if (this.optionMap.containsKey(id)) {
            for (int index = 0; index < this.options.size(); ++index) {
                if (!id.equals(this.options.get(index).getId())) continue;
                this.options.remove(index);
                this.options.add(index, option);
                break;
            }
        } else {
            this.options.add(option);
        }
        this.optionMap.put(id, option);
        if (option instanceof OptionGroup) {
            OptionGroup group = (OptionGroup)option;
            group.setEditable(this.editable && group.isEditable());
            this.addOptionGroup(group);
        }
    }

    private void addOptionGroup(OptionGroup group) {
        for (Option option : group.getOptions()) {
            this.optionMap.put(option.getId(), option);
            if (!(option instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)option);
        }
    }

    public Option remove(String id) {
        Option op = this.optionMap.remove(id);
        if (op != null) {
            this.options.remove(op);
        }
        return op;
    }

    public void removeAll() {
        this.options.clear();
        this.optionMap.clear();
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public OptionGroup getOptionGroup(String id) {
        try {
            return ((OptionGroup)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No option group value associated with the specified option: " + id, e);
        }
    }

    public int getInteger(String id) {
        try {
            return ((IntegerOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No integer value associated with the specified option: " + id, e);
        }
    }

    public void setInteger(String id, int value) {
        try {
            ((IntegerOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No integer value associated with the specified option: " + id, e);
        }
    }

    public boolean getBoolean(String id) {
        try {
            return ((BooleanOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option: " + id, e);
        }
    }

    public void setBoolean(String id, boolean value) {
        try {
            ((BooleanOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option: " + id, e);
        }
    }

    public String getString(String id) {
        try {
            return ((StringOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option: " + id, e);
        }
    }

    public void setString(String id, String value) {
        try {
            ((StringOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option: " + id, e);
        }
    }

    public String getText(String id) {
        try {
            return ((TextOption)this.getOption(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option: " + id, e);
        }
    }

    public void setText(String id, String value) {
        try {
            ((TextOption)this.getOption(id)).setValue(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No String value associated with the specified option: " + id, e);
        }
    }

    @Override
    public OptionGroup clone() {
        OptionGroup result = new OptionGroup(this.getId(), this.getSpecification());
        result.editable = this.editable;
        result.setValues(this);
        result.options.addAll(this.options);
        result.optionMap.putAll(this.optionMap);
        return result;
    }

    @Override
    public OptionGroup getValue() {
        return this;
    }

    @Override
    public void setValue(OptionGroup value) {
        if (value != null) {
            for (Option other : value.getOptions()) {
                Option mine = this.getOption(other.getId());
                if (mine == null) continue;
                mine.setValue(other.getValue());
            }
        }
    }

    @Override
    public void setValue(String valueString, String defaultValueString) {
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(EDITABLE_TAG, this.editable);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Option o : this.options) {
            o.toXML(xw);
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.editable = xr.getAttribute(EDITABLE_TAG, true);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String optionId = xr.readId();
        Option option = this.getOption(optionId);
        if (option == null) {
            AbstractOption abstractOption = this.readOption(xr);
            if (abstractOption != null) {
                this.add(abstractOption);
                abstractOption.setGroup(this.getId());
            }
        } else {
            option.readFromXML(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getId()).append(" <");
        for (Option o : this.getOptions()) {
            sb.append(" ").append(o.toString());
        }
        sb.append(" >]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return OptionGroup.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "optionGroup";
    }
}

