/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import org.w3c.dom.Element;

public class SetCurrentStopMessage
extends DOMMessage {
    private String unitId;
    private String index;

    public SetCurrentStopMessage(Unit unit, int index) {
        super(SetCurrentStopMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.index = String.valueOf(index);
    }

    public SetCurrentStopMessage(Game game, Element element) {
        super(SetCurrentStopMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.index = element.getAttribute("index");
    }

    public Element handle(FreeColServer server, Connection connection) {
        int count;
        ServerUnit serverUnit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            serverUnit = serverPlayer.getOurFreeColGameObject(this.unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        TradeRoute tr = serverUnit.getTradeRoute();
        if (tr == null) {
            return DOMMessage.clientError("Unit has no trade route: " + this.unitId);
        }
        try {
            count = Integer.parseInt(this.index);
        }
        catch (NumberFormatException nfe) {
            return DOMMessage.clientError("Stop index is not an integer: " + this.index);
        }
        if (count < 0 || count > tr.getStops().size()) {
            return DOMMessage.clientError("Invalid stop index: " + this.index);
        }
        return server.getInGameController().setCurrentStop(serverPlayer, serverUnit, count);
    }

    @Override
    public Element toXMLElement() {
        return SetCurrentStopMessage.createMessage(SetCurrentStopMessage.getXMLElementTagName(), "unit", this.unitId, "index", this.index);
    }

    public static String getXMLElementTagName() {
        return "setCurrentStop";
    }
}

