/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class RearrangeColonyMessage
extends DOMMessage {
    public static final Comparator<UnitChange> roleComparator = new Comparator<UnitChange>(){

        @Override
        public int compare(UnitChange uc1, UnitChange uc2) {
            int cmp = uc1.role.compareTo(uc2.role);
            if (cmp == 0) {
                cmp = uc1.roleCount - uc2.roleCount;
            }
            return cmp;
        }
    };
    private String colonyId;
    private List<UnitChange> unitChanges = null;

    public RearrangeColonyMessage(Colony colony) {
        super(RearrangeColonyMessage.getXMLElementTagName());
        this.colonyId = colony.getId();
        this.unitChanges = new ArrayList<UnitChange>();
    }

    public RearrangeColonyMessage(Game game, Element element) {
        super(RearrangeColonyMessage.getXMLElementTagName());
        int n;
        this.colonyId = element.getAttribute("colony");
        try {
            n = Integer.parseInt(element.getAttribute("xLength"));
        }
        catch (NumberFormatException nfe) {
            n = 0;
        }
        this.unitChanges = new ArrayList<UnitChange>();
        for (int i = 0; i < n; ++i) {
            this.unitChanges.add(new UnitChange().readFromElement(game, element, i));
        }
    }

    public boolean isEmpty() {
        return this.unitChanges == null || this.unitChanges.isEmpty();
    }

    public void addChange(Unit unit, Location loc, GoodsType work, Role role, int roleCount) {
        this.unitChanges.add(new UnitChange(unit, loc, work, role, roleCount));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            colony = player.getOurFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.unitChanges.isEmpty()) {
            return DOMMessage.clientError("Empty rearrangement list.");
        }
        int i = 0;
        for (UnitChange uc : this.unitChanges) {
            if (uc.unit == null) {
                return DOMMessage.clientError("Invalid unit " + i);
            }
            if (uc.loc == null) {
                return DOMMessage.clientError("Invalid location " + i);
            }
            if (uc.role == null) {
                return DOMMessage.clientError("Invalid role " + i);
            }
            if (uc.roleCount >= 0) continue;
            return DOMMessage.clientError("Invalid role count " + i);
        }
        return server.getInGameController().rearrangeColony(serverPlayer, colony, this.unitChanges);
    }

    @Override
    public Element toXMLElement() {
        Element result = RearrangeColonyMessage.createMessage(RearrangeColonyMessage.getXMLElementTagName(), "colony", this.colonyId, "xLength", Integer.toString(this.unitChanges.size()));
        int i = 0;
        for (UnitChange uc : this.unitChanges) {
            uc.writeToElement(result, i);
            ++i;
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "rearrangeColony";
    }

    public static class UnitChange {
        public Unit unit;
        public Location loc;
        public GoodsType work;
        public Role role;
        public int roleCount;

        public UnitChange() {
        }

        public UnitChange(Unit unit, Location loc, GoodsType work, Role role, int roleCount) {
            this.unit = unit;
            this.loc = loc;
            this.work = work;
            this.role = role;
            this.roleCount = roleCount;
        }

        public UnitChange(Game game, String unitId, String locId, String workId, String roleId, String roleCount) {
            this.init(game, unitId, locId, workId, roleId, roleCount);
        }

        public final void init(Game game, String unitId, String locId, String workId, String roleId, String roleCount) {
            this.unit = game.getFreeColGameObject(unitId, Unit.class);
            this.loc = game.findFreeColLocation(locId);
            this.work = workId == null || "".equals(workId) ? null : game.getSpecification().getGoodsType(workId);
            this.role = game.getSpecification().getRole(roleId);
            try {
                this.roleCount = Integer.parseInt(roleCount);
            }
            catch (NumberFormatException nfe) {
                this.roleCount = 0;
            }
        }

        public void writeToElement(Element e, int i) {
            e.setAttribute(this.unitKey(i), this.unit.getId());
            e.setAttribute(this.locKey(i), this.loc.getId());
            if (this.work != null) {
                e.setAttribute(this.workKey(i), this.work.getId());
            }
            e.setAttribute(this.roleKey(i), this.role.toString());
            e.setAttribute(this.roleCountKey(i), String.valueOf(this.roleCount));
        }

        public UnitChange readFromElement(Game game, Element e, int i) {
            this.init(game, e.getAttribute(this.unitKey(i)), e.getAttribute(this.locKey(i)), e.getAttribute(this.workKey(i)), e.getAttribute(this.roleKey(i)), e.getAttribute(this.roleCountKey(i)));
            return this;
        }

        public String unitKey(int i) {
            return "x" + i + "unit";
        }

        public String locKey(int i) {
            return "x" + i + "loc";
        }

        public String workKey(int i) {
            return "x" + i + "work";
        }

        public String roleKey(int i) {
            return "x" + i + "role";
        }

        public String roleCountKey(int i) {
            return "x" + i + "count";
        }

        public String toString() {
            return "[UnitChange " + this.unit.getId() + " at " + this.loc.getId() + " " + this.role.getRoleSuffix() + "." + this.roleCount + (this.work == null ? "" : " work " + this.work.getId()) + "]";
        }
    }
}

