/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewLandNameMessage
extends DOMMessage {
    private String unitId;
    private String newLandName;

    public NewLandNameMessage(Unit unit, String newLandName) {
        super(NewLandNameMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.newLandName = newLandName;
    }

    public NewLandNameMessage(Game game, Element element) {
        super(NewLandNameMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.newLandName = element.getAttribute("newLandName");
    }

    public Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.unitId, Unit.class);
    }

    public String getNewLandName() {
        return this.newLandName;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = this.getUnit(player);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (!tile.isLand()) {
            return DOMMessage.clientError("Unit is not in the new world: " + this.unitId);
        }
        if (this.newLandName == null || this.newLandName.isEmpty()) {
            return DOMMessage.clientError("Empty new land name");
        }
        return server.getInGameController().setNewLandName(serverPlayer, unit, this.newLandName);
    }

    @Override
    public Element toXMLElement() {
        return NewLandNameMessage.createMessage(NewLandNameMessage.getXMLElementTagName(), "unit", this.unitId, "newLandName", this.newLandName);
    }

    public static String getXMLElementTagName() {
        return "newLandName";
    }
}

