/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LootCargoMessage
extends DOMMessage {
    private String winnerId;
    private String loserId;
    private List<Goods> goods;

    public LootCargoMessage(Unit winner, String loserId, List<Goods> goods) {
        super(LootCargoMessage.getXMLElementTagName());
        this.winnerId = winner.getId();
        this.loserId = loserId;
        this.goods = goods == null ? null : new ArrayList<Goods>(goods);
    }

    public LootCargoMessage(Game game, Element element) {
        super(LootCargoMessage.getXMLElementTagName());
        this.winnerId = element.getAttribute("winner");
        this.loserId = element.getAttribute("loser");
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            this.goods = null;
        } else {
            this.goods = new ArrayList<Goods>();
            for (int i = 0; i < children.getLength(); ++i) {
                this.goods.add(new Goods(game, (Element)children.item(i)));
            }
        }
    }

    public Unit getUnit(Game game) throws ClassCastException {
        return game.getFreeColGameObject(this.winnerId, Unit.class);
    }

    public String getDefenderId() {
        return this.loserId;
    }

    public List<Goods> getGoods() {
        return this.goods;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit winner;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            winner = this.getUnit(game);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().lootCargo(serverPlayer, winner, this.loserId, this.goods);
    }

    @Override
    public Element toXMLElement() {
        Element result = LootCargoMessage.createMessage(LootCargoMessage.getXMLElementTagName(), "winner", this.winnerId, "loser", this.loserId);
        if (this.goods != null) {
            for (Goods g : this.goods) {
                result.appendChild(g.toXMLElement(result.getOwnerDocument()));
            }
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "lootCargo";
    }
}

