/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class JoinColonyMessage
extends DOMMessage {
    private String colonyId;
    private String builderId;

    public JoinColonyMessage(Colony colony, Unit builder) {
        super(JoinColonyMessage.getXMLElementTagName());
        this.colonyId = colony.getId();
        this.builderId = builder.getId();
    }

    public JoinColonyMessage(Game game, Element element) {
        super(JoinColonyMessage.getXMLElementTagName());
        this.colonyId = element.getAttribute("colony");
        this.builderId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.builderId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            colony = player.getOurFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().joinColony(serverPlayer, unit, colony);
    }

    @Override
    public Element toXMLElement() {
        return JoinColonyMessage.createMessage(JoinColonyMessage.getXMLElementTagName(), "colony", this.colonyId, "unit", this.builderId);
    }

    public static String getXMLElementTagName() {
        return "joinColony";
    }
}

