/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class InciteMessage
extends DOMMessage {
    private String unitId;
    private String directionString;
    private String enemyId;
    private String goldString;

    public InciteMessage(Unit unit, Map.Direction direction, Player enemy, int gold) {
        super(InciteMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
        this.enemyId = enemy.getId();
        this.goldString = Integer.toString(gold);
    }

    public InciteMessage(Game game, Element element) {
        super(InciteMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
        this.enemyId = element.getAttribute("enemyId");
        this.goldString = element.getAttribute("gold");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int gold;
        Tile tile;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        ServerIndianSettlement is = (ServerIndianSettlement)tile.getIndianSettlement();
        if (is == null) {
            return DOMMessage.clientError("There is no native settlement at: " + tile.getId());
        }
        ServerPlayer enemy = game.getFreeColGameObject(this.enemyId, ServerPlayer.class);
        if (enemy == null) {
            return DOMMessage.clientError("Not a player: " + this.enemyId);
        }
        if (enemy == player) {
            return DOMMessage.clientError("Inciting against oneself!");
        }
        if (!enemy.isEuropean()) {
            return DOMMessage.clientError("Inciting against non-European!");
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return DOMMessage.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        try {
            gold = Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().incite(serverPlayer, unit, is, enemy, gold);
    }

    @Override
    public Element toXMLElement() {
        return InciteMessage.createMessage(InciteMessage.getXMLElementTagName(), "unitId", this.unitId, "direction", this.directionString, "enemyId", this.enemyId, "gold", this.goldString);
    }

    public static String getXMLElementTagName() {
        return "incite";
    }
}

