/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class GetTransactionMessage
extends DOMMessage {
    private String unitId;
    private String settlementId;

    public GetTransactionMessage(Unit unit, Settlement settlement) {
        super(GetTransactionMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
    }

    public GetTransactionMessage(Game game, Element element) {
        super(GetTransactionMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Settlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = unit.getAdjacentSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().getTransaction(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        return GetTransactionMessage.createMessage(GetTransactionMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId);
    }

    public static String getXMLElementTagName() {
        return "getTransaction";
    }
}

