/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class FirstContactMessage
extends DOMMessage {
    private String playerId;
    private String otherId;
    private String tileId;
    private String settlementCount;
    private String result;

    public FirstContactMessage(Player player, Player other, Tile tile) {
        super(FirstContactMessage.getXMLElementTagName());
        this.playerId = player.getId();
        this.otherId = other.getId();
        this.tileId = tile == null ? null : tile.getId();
        this.settlementCount = other.isEuropean() ? null : Integer.toString(other.getNumberOfSettlements());
        this.result = null;
    }

    public FirstContactMessage(Game game, Element element) {
        super(FirstContactMessage.getXMLElementTagName());
        this.playerId = element.getAttribute("player");
        this.otherId = element.getAttribute("other");
        this.tileId = !element.hasAttribute("tile") ? null : element.getAttribute("tile");
        this.settlementCount = !element.hasAttribute("camps") ? null : element.getAttribute("camps");
        this.result = !element.hasAttribute("result") ? null : element.getAttribute("result");
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.playerId, Player.class);
    }

    public Player getOtherPlayer(Game game) {
        return game.getFreeColGameObject(this.otherId, Player.class);
    }

    public Tile getTile(Game game) {
        return game.getFreeColGameObject(this.tileId, Tile.class);
    }

    public int getSettlementCount() {
        try {
            return Integer.parseInt(this.settlementCount);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean getResult() {
        return Boolean.parseBoolean(this.result);
    }

    public FirstContactMessage setResult(boolean result) {
        this.result = String.valueOf(result);
        return this;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = serverPlayer.getGame();
        Player first = this.getPlayer(game);
        if (first == null) {
            return DOMMessage.clientError("Invalid player: " + this.playerId);
        }
        if (!serverPlayer.getId().equals(this.playerId)) {
            return DOMMessage.clientError("Not our player: " + this.playerId);
        }
        ServerPlayer otherPlayer = (ServerPlayer)this.getOtherPlayer(game);
        if (otherPlayer == null) {
            return DOMMessage.clientError("Invalid other player: " + this.otherId);
        }
        if (otherPlayer == serverPlayer) {
            return DOMMessage.clientError("First contact with self!?!");
        }
        return server.getInGameController().nativeFirstContact(serverPlayer, otherPlayer, this.getTile(game), this.getResult());
    }

    @Override
    public Element toXMLElement() {
        Element element = FirstContactMessage.createMessage(FirstContactMessage.getXMLElementTagName(), "player", this.playerId, "other", this.otherId);
        if (this.tileId != null) {
            element.setAttribute("tile", this.tileId);
        }
        if (this.settlementCount != null) {
            element.setAttribute("camps", this.settlementCount);
        }
        if (this.result != null) {
            element.setAttribute("result", this.result);
        }
        return element;
    }

    public static String getXMLElementTagName() {
        return "firstContact";
    }
}

