/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.BaseCostDecider;
import net.sf.freecol.common.model.pathfinding.CostDecider;

public final class CostDeciders {
    private static final CostDecider avoidIllegalCostDecider = new BaseCostDecider();
    private static final CostDecider trivialCostDecider = new CostDecider(){

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            return newLocation == null ? -1 : (newLocation instanceof Europe ? 1 : (newLocation.getTile() == null ? -1 : 1));
        }

        @Override
        public int getMovesLeft() {
            return 0;
        }

        @Override
        public int getNewTurns() {
            return 0;
        }
    };
    private static final CostDecider tileCostDecider = new CostDecider(){

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            return newLocation == null ? -1 : (newLocation instanceof Europe ? 1 : (newLocation.getTile() == null ? -1 : (unit.isTileAccessible(newLocation.getTile()) ? 1 : -1)));
        }

        @Override
        public int getMovesLeft() {
            return 0;
        }

        @Override
        public int getNewTurns() {
            return 1;
        }
    };
    private static final CostDecider serverAvoidIllegalCostDecider = new ServerBaseCostDecider();
    private static final AvoidSettlementsCostDecider avoidSettlementsCostDecider = new AvoidSettlementsCostDecider();
    private static final AvoidSettlementsAndBlockingUnitsCostDecider avoidSettlementsAndBlockingUnitsCostDecider = new AvoidSettlementsAndBlockingUnitsCostDecider();

    public static CostDecider getComposedCostDecider(final CostDecider ... cds) {
        if (cds.length < 2) {
            throw new IllegalArgumentException("Short CostDecider list");
        }
        return new CostDecider(){
            private CostDecider[] costDeciders;
            private int ret;
            private int index;
            {
                this.costDeciders = cds;
                this.ret = -1;
                this.index = -1;
            }

            @Override
            public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
                for (int i = 0; i < this.costDeciders.length; ++i) {
                    int cost = this.costDeciders[i].getCost(unit, oldLocation, newLocation, movesLeft);
                    if (cost == -1 || cost == Integer.MAX_VALUE) {
                        this.index = i;
                        return -1;
                    }
                    if (cost <= this.ret) continue;
                    this.index = i;
                    this.ret = cost;
                }
                return this.ret;
            }

            @Override
            public int getMovesLeft() {
                return this.index < 0 ? 0 : this.costDeciders[this.index].getMovesLeft();
            }

            @Override
            public int getNewTurns() {
                return this.index < 0 ? 0 : this.costDeciders[this.index].getNewTurns();
            }
        };
    }

    public static CostDecider defaultCostDeciderFor(Unit unit) {
        return unit == null ? CostDeciders.avoidIllegal() : (unit.isNaval() ? CostDeciders.avoidNavalDanger() : (unit.isOffensiveUnit() ? CostDeciders.avoidSettlements() : CostDeciders.avoidSettlementsAndBlockingUnits()));
    }

    public static CostDecider numberOfTiles() {
        return trivialCostDecider;
    }

    public static CostDecider numberOfLegalTiles() {
        return tileCostDecider;
    }

    public static CostDecider avoidIllegal() {
        return avoidIllegalCostDecider;
    }

    public static CostDecider serverAvoidIllegal() {
        return serverAvoidIllegalCostDecider;
    }

    public static CostDecider avoidSettlements() {
        return avoidSettlementsCostDecider;
    }

    public static CostDecider avoidSettlementsAndBlockingUnits() {
        return avoidSettlementsAndBlockingUnitsCostDecider;
    }

    public static CostDecider avoidNavalDanger() {
        return new AvoidNavalDangerCostDecider();
    }

    private static class AvoidNavalDangerCostDecider
    extends AvoidSettlementsAndBlockingUnitsCostDecider {
        private AvoidNavalDangerCostDecider() {
        }

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            Tile tile = newLocation.getTile();
            if (cost != -1 && cost != Integer.MAX_VALUE && tile != null) {
                if (tile.isDangerousToShip(unit)) {
                    cost = -1;
                } else {
                    Player owner = unit.getOwner();
                    block0: for (Tile t : tile.getSurroundingTiles(1)) {
                        for (Unit u : t.getUnitList()) {
                            if (u.getOwner() == owner) break;
                            if (!u.hasAbility("model.ability.piracy") && (!u.getOwner().atWarWith(owner) || !u.isOffensiveUnit())) continue;
                            this.movesLeft = 0;
                            ++this.newTurns;
                            break block0;
                        }
                    }
                }
            }
            return cost;
        }
    }

    private static class AvoidSettlementsAndBlockingUnitsCostDecider
    extends AvoidSettlementsCostDecider {
        private AvoidSettlementsAndBlockingUnitsCostDecider() {
        }

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            Tile tile = newLocation.getTile();
            if (cost != -1 && cost != Integer.MAX_VALUE && tile != null) {
                Unit defender = tile.getFirstUnit();
                if (defender != null && defender.getOwner() != unit.getOwner()) {
                    return -1;
                }
                if (unit.getTradeRoute() != null && tile.hasLostCityRumour()) {
                    return -1;
                }
            }
            return cost;
        }
    }

    private static class AvoidSettlementsCostDecider
    extends BaseCostDecider {
        private AvoidSettlementsCostDecider() {
        }

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            Settlement settlement;
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            if (cost != -1 && cost != Integer.MAX_VALUE && (settlement = newLocation.getSettlement()) != null && settlement.getOwner() != unit.getOwner()) {
                return -1;
            }
            return cost;
        }
    }

    private static class ServerBaseCostDecider
    extends BaseCostDecider {
        private ServerBaseCostDecider() {
        }

        @Override
        public int getCost(Unit unit, Location oldLocation, Location newLocation, int movesLeft) {
            int cost = super.getCost(unit, oldLocation, newLocation, movesLeft);
            if (cost != -1 && cost != Integer.MAX_VALUE && !(newLocation instanceof Europe) && !newLocation.getTile().isExploredBy(unit.getOwner())) {
                return -1;
            }
            return cost;
        }
    }
}

