/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.StringTemplate;

public class Turn {
    private int turn = 1;
    private static int startingYear = 1492;
    private static int seasonYear = 1600;
    private static int[] ages = new int[]{1492, 1600, 1700};
    public static final int NUMBER_OF_AGES = ages.length;

    public Turn(int turn) {
        this.turn = turn;
    }

    public static int yearToTurn(int year) {
        return Turn.yearToTurn(year, Season.YEAR);
    }

    public static int yearToTurn(int year, Season season) {
        int turn = 1;
        if (year >= startingYear) {
            turn += year - startingYear;
            if (year >= seasonYear) {
                turn += year - seasonYear;
                if (season == Season.AUTUMN) {
                    ++turn;
                }
            }
        }
        return turn;
    }

    public Turn next() {
        return new Turn(this.turn + 1);
    }

    public int getNumber() {
        return this.turn;
    }

    public int getAge() {
        return Turn.getAge(this.getYear());
    }

    public static int getAge(int year) {
        for (int index = 0; index < ages.length; ++index) {
            if (year >= ages[index]) continue;
            return index;
        }
        return ages.length;
    }

    public int getYear() {
        return Turn.getYear(this.turn);
    }

    public static int getYear(int turn) {
        int year = turn - 1 + startingYear;
        return year < seasonYear ? year : seasonYear + (year - seasonYear) / 2;
    }

    public static Season getSeason(int turn) {
        int year = turn - 1 + startingYear;
        return year < seasonYear ? Season.YEAR : (year % 2 == 0 ? Season.SPRING : Season.AUTUMN);
    }

    public Season getSeason() {
        return Turn.getSeason(this.turn);
    }

    public StringTemplate getLabel() {
        return Turn.getLabel(this.turn);
    }

    public static StringTemplate getLabel(int turn) {
        return StringTemplate.template("year." + (Object)((Object)Turn.getSeason(turn))).addAmount("%year%", Turn.getYear(turn));
    }

    public static final int getStartingYear() {
        return startingYear;
    }

    public static final void setStartingYear(int newStartingYear) {
        startingYear = newStartingYear;
    }

    public static final int getSeasonYear() {
        return seasonYear;
    }

    public static final void setSeasonYear(int newSeasonYear) {
        seasonYear = newSeasonYear;
    }

    public boolean isFirstTurn() {
        return this.turn == 1;
    }

    public boolean isFirstSeasonTurn() {
        return this.turn == Turn.yearToTurn(seasonYear, Season.SPRING);
    }

    public static String toString(int turn) {
        return (Object)((Object)Turn.getSeason(turn)) + " " + Integer.toString(Turn.getYear(turn));
    }

    public boolean equals(Object o) {
        if (o instanceof Turn) {
            return this.turn == ((Turn)o).turn;
        }
        return false;
    }

    public int hashCode() {
        return this.turn;
    }

    public String toString() {
        return Turn.toString(this.turn);
    }

    public static enum Season {
        YEAR,
        SPRING,
        AUTUMN;

    }
}

