/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public abstract class TradeItem
extends FreeColObject {
    protected Game game;
    private Player source;
    private Player destination;
    private static final String DESTINATION_TAG = "destination";
    private static final String SOURCE_TAG = "source";

    public TradeItem(Game game, String id, Player source, Player destination) {
        this.setId(id);
        this.game = game;
        this.source = source;
        this.destination = destination;
    }

    public TradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this.game = game;
        this.readFromXML(xr);
    }

    protected final Game getGame() {
        return this.game;
    }

    public final Player getSource() {
        return this.source;
    }

    public final void setSource(Player newSource) {
        this.source = newSource;
    }

    public final Player getDestination() {
        return this.destination;
    }

    public final void setDestination(Player newDestination) {
        this.destination = newDestination;
    }

    public abstract boolean isValid();

    public abstract boolean isUnique();

    public abstract StringTemplate getLabel();

    public Colony getColony(Game game) {
        return null;
    }

    public Goods getGoods() {
        return null;
    }

    public void setGoods(Goods goods) {
    }

    public int getGold() {
        return 0;
    }

    public void setGold(int gold) {
    }

    public Player getVictim() {
        return null;
    }

    public Player.Stance getStance() {
        return null;
    }

    public void setStance(Player.Stance stance) {
    }

    public Unit getUnit() {
        return null;
    }

    public void setUnit(Unit unit) {
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(SOURCE_TAG, this.source);
        xw.writeAttribute(DESTINATION_TAG, this.destination);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.source = xr.getAttribute(this.game, SOURCE_TAG, Player.class, (Player)null);
        this.destination = xr.getAttribute(this.game, DESTINATION_TAG, Player.class, (Player)null);
    }
}

