/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;

public class StanceTradeItem
extends TradeItem {
    private Player.Stance stance;
    private static final String STANCE_TAG = "stance";

    public StanceTradeItem(Game game, Player source, Player destination, Player.Stance stance) {
        super(game, "tradeItem.stance", source, destination);
        this.stance = stance;
    }

    public StanceTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.stance != null;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public StringTemplate getLabel() {
        return this.stance.getLabel();
    }

    @Override
    public Player.Stance getStance() {
        return this.stance;
    }

    @Override
    public void setStance(Player.Stance stance) {
        this.stance = stance;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(STANCE_TAG, this.stance);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append((Object)this.stance).append("]");
        return sb.toString();
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.stance = xr.getAttribute(STANCE_TAG, Player.Stance.class, null);
    }

    @Override
    public String getXMLTagName() {
        return StanceTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "stanceTradeItem";
    }
}

