/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.util.Utils;

public class Scope
extends FreeColObject {
    private String type = null;
    private String abilityId = null;
    private boolean abilityValue = true;
    private String methodName = null;
    private String methodValue = null;
    private boolean matchesNull = true;
    private boolean matchNegated = false;
    private static final String ABILITY_ID_TAG = "ability-id";
    private static final String ABILITY_VALUE_TAG = "ability-value";
    private static final String MATCH_NEGATED_TAG = "matchNegated";
    private static final String MATCHES_NULL_TAG = "matchesNull";
    private static final String METHOD_NAME_TAG = "method-name";
    private static final String METHOD_VALUE_TAG = "method-value";
    private static final String TYPE_TAG = "type";

    public Scope() {
    }

    public Scope(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public boolean isMatchesNull() {
        return this.matchesNull;
    }

    public void setMatchesNull(boolean newMatchesNull) {
        this.matchesNull = newMatchesNull;
    }

    public boolean isMatchNegated() {
        return this.matchNegated;
    }

    public void setMatchNegated(boolean newMatchNegated) {
        this.matchNegated = newMatchNegated;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getAbilityId() {
        return this.abilityId;
    }

    public void setAbilityId(String newAbilityId) {
        this.abilityId = newAbilityId;
    }

    public boolean getAbilityValue() {
        return this.abilityValue;
    }

    public void setAbilityValue(boolean newAbilityValue) {
        this.abilityValue = newAbilityValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public void setMethodValue(String newMethodValue) {
        this.methodValue = newMethodValue;
    }

    public boolean appliesTo(FreeColObject object) {
        Method method;
        block15: {
            if (object == null) {
                return this.matchesNull;
            }
            if (this.type != null) {
                if (object instanceof FreeColGameObjectType) {
                    if (!this.type.equals(object.getId())) {
                        return this.matchNegated;
                    }
                } else {
                    if (object instanceof FreeColGameObject) {
                        try {
                            method = object.getClass().getMethod("getType", new Class[0]);
                            if (method != null && FreeColGameObjectType.class.isAssignableFrom(method.getReturnType())) {
                                FreeColGameObjectType objectType = (FreeColGameObjectType)method.invoke((Object)object, new Object[0]);
                                if (!this.type.equals(objectType.getId())) {
                                    return this.matchNegated;
                                }
                                break block15;
                            }
                            return this.matchNegated;
                        }
                        catch (Exception e) {
                            return this.matchNegated;
                        }
                    }
                    return this.matchNegated;
                }
            }
        }
        if (this.abilityId != null && object.hasAbility(this.abilityId) != this.abilityValue) {
            return this.matchNegated;
        }
        if (this.methodName != null) {
            try {
                method = object.getClass().getMethod(this.methodName, new Class[0]);
                if (method != null && !String.valueOf(method.invoke((Object)object, new Object[0])).equals(this.methodValue)) {
                    return this.matchNegated;
                }
            }
            catch (Exception e) {
                return this.matchNegated;
            }
        }
        return !this.matchNegated;
    }

    public static Scope makeNegatedPersonScope() {
        Scope scope = new Scope();
        scope.setAbilityId("model.ability.person");
        scope.setMatchNegated(true);
        return scope;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Scope) {
            Scope otherScope = (Scope)o;
            if (this.matchNegated != otherScope.matchNegated) {
                return false;
            }
            if (this.matchesNull != otherScope.matchesNull) {
                return false;
            }
            if (this.type == null ? otherScope.getType() != this.type : !this.type.equals(otherScope.getType())) {
                return false;
            }
            if (this.abilityId == null ? !Utils.equals(otherScope.getAbilityId(), this.abilityId) : !this.abilityId.equals(otherScope.getAbilityId())) {
                return false;
            }
            if (this.abilityValue != otherScope.getAbilityValue()) {
                return false;
            }
            if (this.methodName == null ? !Utils.equals(otherScope.getMethodName(), this.methodName) : !this.methodName.equals(otherScope.getMethodName())) {
                return false;
            }
            return !(this.methodValue == null ? !Utils.equals(otherScope.getMethodValue(), this.methodValue) : !this.methodValue.equals(otherScope.getMethodValue()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.type == null ? 0 : this.type.hashCode());
        hash = 31 * hash + (this.abilityId == null ? 0 : this.abilityId.hashCode());
        hash = 31 * hash + (this.abilityValue ? 1 : 0);
        hash = 31 * hash + (this.methodName == null ? 0 : this.methodName.hashCode());
        hash = 31 * hash + (this.methodValue == null ? 0 : this.methodValue.hashCode());
        hash = 31 * hash + (this.matchesNull ? 1 : 0);
        return 31 * hash + (this.matchNegated ? 1 : 0);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(MATCH_NEGATED_TAG, this.matchNegated);
        xw.writeAttribute(MATCHES_NULL_TAG, this.matchesNull);
        if (this.type != null) {
            xw.writeAttribute(TYPE_TAG, this.type);
        }
        if (this.abilityId != null) {
            xw.writeAttribute(ABILITY_ID_TAG, this.abilityId);
            xw.writeAttribute(ABILITY_VALUE_TAG, this.abilityValue);
        }
        if (this.methodName != null) {
            xw.writeAttribute(METHOD_NAME_TAG, this.methodName);
            if (this.methodValue != null) {
                xw.writeAttribute(METHOD_VALUE_TAG, this.methodValue);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.matchNegated = xr.getAttribute(MATCH_NEGATED_TAG, false);
        this.matchesNull = xr.getAttribute(MATCHES_NULL_TAG, true);
        this.type = xr.getAttribute(TYPE_TAG, null);
        if ("model.equipment.muskets".equals(this.type)) {
            this.type = "model.role.soldier";
        } else if ("model.equipment.indian.horses".equals(this.type)) {
            this.type = "model.role.mountedBrave";
        } else if ("model.equipment.indian.muskets".equals(this.type)) {
            this.type = "model.role.armedBrave";
        }
        this.abilityId = xr.getAttribute(ABILITY_ID_TAG, null);
        this.abilityValue = xr.getAttribute(ABILITY_VALUE_TAG, true);
        this.methodName = xr.getAttribute(METHOD_NAME_TAG, null);
        this.methodValue = xr.getAttribute(METHOD_VALUE_TAG, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[Scope ").append(this.type);
        if (this.abilityId != null) {
            sb.append(" ").append(this.abilityId).append("=").append(this.abilityValue);
        }
        if (this.methodName != null) {
            sb.append(" ").append(this.methodName).append("=").append(this.methodValue);
        }
        if (this.matchesNull) {
            sb.append(" matchesNull");
        }
        if (this.matchNegated) {
            sb.append(" matchNegated");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Scope.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "scope";
    }
}

