/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;

public abstract class NationType
extends FreeColGameObjectType {
    private SettlementNumber numberOfSettlements = SettlementNumber.AVERAGE;
    private AggressionLevel aggression = AggressionLevel.AVERAGE;
    private List<SettlementType> settlementTypes = null;
    private static final String AGGRESSION_TAG = "aggression";
    private static final String NUMBER_OF_SETTLEMENTS_TAG = "number-of-settlements";
    private static final String SETTLEMENT_TAG = "settlement";

    public NationType(String id, Specification specification) {
        super(id, specification);
    }

    public final List<SettlementType> getSettlementTypes() {
        return this.settlementTypes == null ? Collections.emptyList() : this.settlementTypes;
    }

    private void addSettlementType(SettlementType settlementType) {
        if (this.settlementTypes == null) {
            this.settlementTypes = new ArrayList<SettlementType>();
        }
        this.settlementTypes.add(settlementType);
    }

    private void addSettlementTypes(List<SettlementType> types) {
        if (this.settlementTypes == null) {
            this.settlementTypes = new ArrayList<SettlementType>();
        }
        this.settlementTypes.addAll(types);
    }

    public SettlementType getCapitalType() {
        return this.getSettlementType(true);
    }

    public SettlementType getSettlementType(boolean isCapital) {
        for (SettlementType settlementType : this.getSettlementTypes()) {
            if (settlementType.isCapital() != isCapital) continue;
            return settlementType;
        }
        return null;
    }

    public SettlementType getSettlementType(String id) {
        for (SettlementType settlementType : this.getSettlementTypes()) {
            if (!id.equals(settlementType.getId())) continue;
            return settlementType;
        }
        return null;
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public abstract boolean isEuropean();

    public abstract boolean isIndian();

    public abstract boolean isREF();

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NUMBER_OF_SETTLEMENTS_TAG, this.numberOfSettlements);
        xw.writeAttribute(AGGRESSION_TAG, this.aggression);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (SettlementType settlementType : this.getSettlementTypes()) {
            settlementType.toXML(xw, SETTLEMENT_TAG);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        NationType parent = xr.getType(spec, "extends", NationType.class, this);
        this.numberOfSettlements = xr.getAttribute(NUMBER_OF_SETTLEMENTS_TAG, SettlementNumber.class, parent.numberOfSettlements);
        this.aggression = xr.getAttribute(AGGRESSION_TAG, AggressionLevel.class, parent.aggression);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec;
        NationType parent;
        if (xr.shouldClearContainers()) {
            this.settlementTypes = null;
        }
        if ((parent = xr.getType(spec = this.getSpecification(), "extends", NationType.class, this)) != this) {
            if (parent.settlementTypes != null) {
                this.addSettlementTypes(parent.settlementTypes);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (SETTLEMENT_TAG.equals(tag)) {
            this.addSettlementType(new SettlementType(xr, spec));
        } else {
            super.readChild(xr);
        }
    }

    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;

    }

    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;

    }
}

